/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.PendingAddOp;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class PendingAddOpTest {
    private BookKeeper bk;
    private LedgerHandle lh;
    private ByteBuf payload;

    @Before
    public void setup() {
        this.bk = (BookKeeper)Mockito.mock(BookKeeper.class);
        Mockito.when((Object)this.bk.getAddEntryQuorumTimeoutNanos()).thenReturn((Object)1000L);
        Mockito.when((Object)this.bk.getAddOpLogger()).thenReturn((Object)NullStatsLogger.INSTANCE.getOpStatsLogger("test"));
        Mockito.when((Object)this.bk.getAddOpUrCounter()).thenReturn((Object)NullStatsLogger.INSTANCE.getCounter("test"));
        this.lh = (LedgerHandle)Mockito.mock(LedgerHandle.class);
        Mockito.when((Object)this.lh.getBk()).thenReturn((Object)this.bk);
        Mockito.when((Object)this.lh.getDistributionSchedule()).thenReturn((Object)new RoundRobinDistributionSchedule(3, 3, 2));
        byte[] data = "test-pending-add-op".getBytes(StandardCharsets.UTF_8);
        this.payload = Unpooled.wrappedBuffer((byte[])data);
        this.payload.writerIndex(data.length);
    }

    @Test
    public void testExecuteAfterCancelled() {
        AtomicInteger rcHolder = new AtomicInteger(-57005);
        PendingAddOp op = PendingAddOp.create((LedgerHandle)this.lh, (ByteBuf)this.payload, (rc, handle, entryId, qwcLatency, ctx) -> rcHolder.set(rc), null);
        Assert.assertSame((Object)this.lh, (Object)op.lh);
        op.submitCallback(-6);
        Assert.assertSame((Object)this.lh, (Object)op.lh);
        Assert.assertEquals((long)-6L, (long)rcHolder.get());
        op.run();
        Assert.assertNull((Object)op.lh);
    }
}

