/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.DefaultSpeculativeRequestExecutionPolicy;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.ReadLastConfirmedAndEntryOp;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.client.SpeculativeRequestExecutionPolicy;
import org.apache.bookkeeper.client.api.LastConfirmedAndEntry;
import org.apache.bookkeeper.client.impl.LastConfirmedAndEntryImpl;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.ReadLastConfirmedAndEntryContext;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.proto.checksum.DummyDigestManager;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.util.ByteBufList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadLastConfirmedAndEntryOpTest {
    private static final Logger log = LoggerFactory.getLogger(ReadLastConfirmedAndEntryOpTest.class);
    private static final long LEDGERID = System.currentTimeMillis();
    private final TestStatsProvider testStatsProvider = new TestStatsProvider();
    private OpStatsLogger readLacAndEntryOpLogger;
    private BookieClient mockBookieClient;
    private BookKeeper mockBk;
    private LedgerHandle mockLh;
    private ScheduledExecutorService scheduler;
    private OrderedScheduler orderedScheduler;
    private SpeculativeRequestExecutionPolicy speculativePolicy;
    private LedgerMetadata ledgerMetadata;
    private DistributionSchedule distributionSchedule;
    private DigestManager digestManager;

    @Before
    public void setup() throws Exception {
        this.readLacAndEntryOpLogger = this.testStatsProvider.getStatsLogger("").getOpStatsLogger("readLacAndEntry");
        this.speculativePolicy = new DefaultSpeculativeRequestExecutionPolicy(100, 200, 2.0f);
        this.ledgerMetadata = new LedgerMetadata(3, 3, 2, BookKeeper.DigestType.CRC32, new byte[0]);
        ArrayList<BookieSocketAddress> ensemble = new ArrayList<BookieSocketAddress>(3);
        for (int i = 0; i < 3; ++i) {
            ensemble.add(new BookieSocketAddress("127.0.0.1", 3181 + i));
        }
        this.ledgerMetadata.addEnsemble(0L, ensemble);
        this.distributionSchedule = new RoundRobinDistributionSchedule(3, 2, 3);
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.orderedScheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-ordered-scheduler").numThreads(1).build();
        this.mockBookieClient = (BookieClient)Mockito.mock(BookieClient.class);
        this.mockBk = (BookKeeper)Mockito.mock(BookKeeper.class);
        Mockito.when((Object)this.mockBk.getReadLACSpeculativeRequestPolicy()).thenReturn((Object)Optional.of((Object)this.speculativePolicy));
        Mockito.when((Object)this.mockBk.getBookieClient()).thenReturn((Object)this.mockBookieClient);
        Mockito.when((Object)this.mockBk.getReadLacAndEntryOpLogger()).thenReturn((Object)this.readLacAndEntryOpLogger);
        Mockito.when((Object)this.mockBk.getMainWorkerPool()).thenReturn((Object)this.orderedScheduler);
        EnsemblePlacementPolicy mockPlacementPolicy = (EnsemblePlacementPolicy)Mockito.mock(EnsemblePlacementPolicy.class);
        Mockito.when((Object)this.mockBk.getPlacementPolicy()).thenReturn((Object)mockPlacementPolicy);
        this.mockLh = (LedgerHandle)Mockito.mock(LedgerHandle.class);
        Mockito.when((Object)this.mockLh.getBk()).thenReturn((Object)this.mockBk);
        Mockito.when((Object)this.mockLh.getId()).thenReturn((Object)LEDGERID);
        Mockito.when((Object)this.mockLh.getLedgerMetadata()).thenReturn((Object)this.ledgerMetadata);
        Mockito.when((Object)this.mockLh.getDistributionSchedule()).thenReturn((Object)this.distributionSchedule);
        this.digestManager = new DummyDigestManager(LEDGERID, false);
        Mockito.when((Object)this.mockLh.getDigestManager()).thenReturn((Object)this.digestManager);
    }

    @After
    public void teardown() {
        this.scheduler.shutdown();
        this.orderedScheduler.shutdown();
    }

    @Test
    public void testSpeculativeResponses() throws Exception {
        long entryId = 2L;
        long lac = 1L;
        ByteBuf data = Unpooled.copiedBuffer((CharSequence)"test-speculative-responses", (Charset)StandardCharsets.UTF_8);
        ByteBufList dataWithDigest = this.digestManager.computeDigestAndPackageForSending(2L, 1L, (long)data.readableBytes(), data);
        byte[] bytesWithDigest = new byte[dataWithDigest.readableBytes()];
        Assert.assertEquals((long)bytesWithDigest.length, (long)dataWithDigest.getBytes(bytesWithDigest));
        Map callbacks = Collections.synchronizedMap(new HashMap());
        ((BookieClient)Mockito.doAnswer(invocationOnMock -> {
            BookieSocketAddress address = (BookieSocketAddress)invocationOnMock.getArgument(0);
            BookkeeperInternalCallbacks.ReadEntryCallback callback = (BookkeeperInternalCallbacks.ReadEntryCallback)invocationOnMock.getArgument(6);
            ReadLastConfirmedAndEntryContext context = (ReadLastConfirmedAndEntryContext)invocationOnMock.getArgument(7);
            ReadLastConfirmedAndEntryHolder holder = new ReadLastConfirmedAndEntryHolder(address, callback, context);
            log.info("Received read request to bookie {}", (Object)address);
            callbacks.put(address, holder);
            return null;
        }).when((Object)this.mockBookieClient)).readEntryWaitForLACUpdate((BookieSocketAddress)ArgumentMatchers.any(BookieSocketAddress.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean(), (BookkeeperInternalCallbacks.ReadEntryCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.ReadEntryCallback.class), ArgumentMatchers.any());
        CompletableFuture resultFuture = new CompletableFuture();
        ReadLastConfirmedAndEntryOp.LastConfirmedAndEntryCallback resultCallback = (rc, lastAddConfirmed, entry) -> {
            if (0 != rc) {
                FutureUtils.completeExceptionally((CompletableFuture)resultFuture, (Throwable)BKException.create((int)rc));
            } else {
                FutureUtils.complete((CompletableFuture)resultFuture, (Object)LastConfirmedAndEntryImpl.create((long)lastAddConfirmed, (LedgerEntry)entry));
            }
        };
        ReadLastConfirmedAndEntryOp op = new ReadLastConfirmedAndEntryOp(this.mockLh, resultCallback, 1L, 10000L, this.scheduler);
        op.initiate();
        while (callbacks.size() < 3) {
            log.info("Received {} read requests", (Object)callbacks.size());
            Thread.sleep(100L);
        }
        log.info("All speculative reads are outstanding now.");
        Iterator iter = callbacks.entrySet().iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Map.Entry firstBookieEntry = iter.next();
        ReadLastConfirmedAndEntryHolder firstBookieHolder = (ReadLastConfirmedAndEntryHolder)firstBookieEntry.getValue();
        ReadLastConfirmedAndEntryContext firstContext = firstBookieHolder.context;
        firstContext.setLastAddConfirmed(2L);
        firstBookieHolder.getCallback().readEntryComplete(0, LEDGERID, -1L, null, (Object)firstContext);
        LedgerEntryImpl entry2 = LedgerEntryImpl.create((long)LEDGERID, (long)Long.MAX_VALUE);
        Assert.assertTrue((boolean)iter.hasNext());
        Map.Entry secondBookieEntry = iter.next();
        ReadLastConfirmedAndEntryHolder secondBookieHolder = (ReadLastConfirmedAndEntryHolder)secondBookieEntry.getValue();
        ReadLastConfirmedAndEntryContext secondContext = secondBookieHolder.context;
        secondContext.setLastAddConfirmed(2L);
        secondBookieHolder.getCallback().readEntryComplete(0, LEDGERID, 2L, Unpooled.wrappedBuffer((byte[])bytesWithDigest), (Object)secondContext);
        Assert.assertNull((Object)entry2.getEntryBuffer());
        entry2.close();
        try (LastConfirmedAndEntry lacAndEntry = (LastConfirmedAndEntry)FutureUtils.result(resultFuture);){
            Assert.assertEquals((long)2L, (long)lacAndEntry.getLastAddConfirmed());
            Assert.assertNull((Object)lacAndEntry.getEntry());
        }
    }

    static class ReadLastConfirmedAndEntryHolder {
        private final BookieSocketAddress address;
        private final BookkeeperInternalCallbacks.ReadEntryCallback callback;
        private final ReadLastConfirmedAndEntryContext context;

        public ReadLastConfirmedAndEntryHolder(BookieSocketAddress address, BookkeeperInternalCallbacks.ReadEntryCallback callback, ReadLastConfirmedAndEntryContext context) {
            this.address = address;
            this.callback = callback;
            this.context = context;
        }

        public BookieSocketAddress getAddress() {
            return this.address;
        }

        public BookkeeperInternalCallbacks.ReadEntryCallback getCallback() {
            return this.callback;
        }

        public ReadLastConfirmedAndEntryContext getContext() {
            return this.context;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadLastConfirmedAndEntryHolder)) {
                return false;
            }
            ReadLastConfirmedAndEntryHolder other = (ReadLastConfirmedAndEntryHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BookieSocketAddress this$address = this.getAddress();
            BookieSocketAddress other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            BookkeeperInternalCallbacks.ReadEntryCallback this$callback = this.getCallback();
            BookkeeperInternalCallbacks.ReadEntryCallback other$callback = other.getCallback();
            if (this$callback == null ? other$callback != null : !this$callback.equals(other$callback)) {
                return false;
            }
            ReadLastConfirmedAndEntryContext this$context = this.getContext();
            ReadLastConfirmedAndEntryContext other$context = other.getContext();
            return !(this$context == null ? other$context != null : !this$context.equals(other$context));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReadLastConfirmedAndEntryHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BookieSocketAddress $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            BookkeeperInternalCallbacks.ReadEntryCallback $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            ReadLastConfirmedAndEntryContext $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : $context.hashCode());
            return result;
        }

        public String toString() {
            return "ReadLastConfirmedAndEntryOpTest.ReadLastConfirmedAndEntryHolder(address=" + this.getAddress() + ", callback=" + this.getCallback() + ", context=" + this.getContext() + ")";
        }
    }
}

