/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerChecker;
import org.apache.bookkeeper.client.LedgerFragment;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLedgerChecker
extends BookKeeperClusterTestCase {
    private static final byte[] TEST_LEDGER_ENTRY_DATA = "TestCheckerData".getBytes();
    private static final byte[] TEST_LEDGER_PASSWORD = "testpasswd".getBytes();
    private static final Logger LOG = LoggerFactory.getLogger(TestLedgerChecker.class);

    public TestLedgerChecker() {
        super(3);
    }

    @Test
    public void testChecker() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        this.startNewBookie();
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(TEST_LEDGER_ENTRY_DATA);
        }
        BookieSocketAddress replicaToKill = (BookieSocketAddress)((ArrayList)lh.getLedgerMetadata().getEnsembles().get(0L)).get(0);
        LOG.info("Killing {}", (Object)replicaToKill);
        this.killBookie(replicaToKill);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(TEST_LEDGER_ENTRY_DATA);
        }
        Set<LedgerFragment> result = this.getUnderReplicatedFragments(lh);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        for (LedgerFragment ledgerFragment2 : result) {
            LOG.info("unreplicated fragment: {}", (Object)ledgerFragment2);
        }
        Assert.assertEquals((String)"Should have one missing fragment", (long)1L, (long)result.size());
        Assert.assertTrue((String)"Fragment should be missing from first replica", (boolean)result.iterator().next().getAddresses().contains(replicaToKill));
        BookieSocketAddress replicaToKill2 = (BookieSocketAddress)((ArrayList)lh.getLedgerMetadata().getEnsembles().get(0L)).get(1);
        LOG.info("Killing {}", (Object)replicaToKill2);
        this.killBookie(replicaToKill2);
        result = this.getUnderReplicatedFragments(lh);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        for (LedgerFragment r : result) {
            LOG.info("unreplicated fragment: {}", (Object)r);
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        result.forEach(ledgerFragment -> number.addAndGet(ledgerFragment.getAddresses().size()));
        Assert.assertEquals((String)"Should have three missing fragments", (long)3L, (long)atomicInteger.get());
    }

    @Test
    public void testShouldNotGetTheFragmentIfThereIsNoMissedEntry() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 2, BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        lh.addEntry(TEST_LEDGER_ENTRY_DATA);
        ArrayList firstEnsemble = (ArrayList)lh.getLedgerMetadata().getEnsembles().get(0L);
        BookieSocketAddress lastBookieFromEnsemble = (BookieSocketAddress)firstEnsemble.get(2);
        LOG.info("Killing " + lastBookieFromEnsemble + " from ensemble=" + firstEnsemble);
        this.killBookie(lastBookieFromEnsemble);
        this.startNewBookie();
        LOG.info("Ensembles after first entry :" + lh.getLedgerMetadata().getEnsembles());
        lh.addEntry(TEST_LEDGER_ENTRY_DATA);
        LOG.info("Ensembles after second entry :" + lh.getLedgerMetadata().getEnsembles());
        Set<LedgerFragment> result = this.getUnderReplicatedFragments(lh);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        for (LedgerFragment r : result) {
            LOG.info("unreplicated fragment: {}", (Object)r);
        }
        Assert.assertEquals((String)"Should not have any missing fragment", (long)0L, (long)result.size());
    }

    @Test
    public void testShouldGetTwoFrgamentsIfTwoBookiesFailedInSameEnsemble() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 2, BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        this.startNewBookie();
        this.startNewBookie();
        lh.addEntry(TEST_LEDGER_ENTRY_DATA);
        ArrayList firstEnsemble = (ArrayList)lh.getLedgerMetadata().getEnsembles().get(0L);
        BookieSocketAddress firstBookieFromEnsemble = (BookieSocketAddress)firstEnsemble.get(0);
        this.killBookie(firstEnsemble, firstBookieFromEnsemble);
        BookieSocketAddress secondBookieFromEnsemble = (BookieSocketAddress)firstEnsemble.get(1);
        this.killBookie(firstEnsemble, secondBookieFromEnsemble);
        lh.addEntry(TEST_LEDGER_ENTRY_DATA);
        Set<LedgerFragment> result = this.getUnderReplicatedFragments(lh);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        for (LedgerFragment r : result) {
            LOG.info("unreplicated fragment: {}", (Object)r);
        }
        Assert.assertEquals((String)"There should be 1 fragments", (long)1L, (long)result.size());
        Assert.assertEquals((String)"There should be 2 failed bookies in the fragment", (long)2L, (long)result.iterator().next().getBookiesIndexes().size());
    }

    @Test
    public void testShouldNotGetAnyFragmentIfNoLedgerPresent() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 2, BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        ArrayList firstEnsemble = (ArrayList)lh.getLedgerMetadata().getEnsembles().get(0L);
        BookieSocketAddress firstBookieFromEnsemble = (BookieSocketAddress)firstEnsemble.get(0);
        this.killBookie(firstBookieFromEnsemble);
        this.startNewBookie();
        lh.addEntry(TEST_LEDGER_ENTRY_DATA);
        this.bkc.deleteLedger(lh.getId());
        LOG.info("Waiting to see ledger id {} deletion", (Object)lh.getId());
        boolean noSuchLedger = false;
        for (int retries = 40; retries > 0; --retries) {
            try {
                lh.readEntries(0L, 0L);
            }
            catch (BKException.BKNoSuchLedgerExistsException bkn) {
                noSuchLedger = true;
                break;
            }
            Thread.sleep(500L);
        }
        Assert.assertEquals((String)"Ledger exists", (Object)true, (Object)noSuchLedger);
        Set<LedgerFragment> result = this.getUnderReplicatedFragments(lh);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        Assert.assertEquals((String)("There should be 0 fragments. But returned fragments are " + result), (long)0L, (long)result.size());
    }

    @Test
    public void testShouldGetFailedEnsembleNumberOfFgmntsIfEnsembleBookiesFailedOnNextWrite() throws Exception {
        this.startNewBookie();
        this.startNewBookie();
        LedgerHandle lh = this.bkc.createLedger(3, 2, BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        for (int i = 0; i < 3; ++i) {
            lh.addEntry(TEST_LEDGER_ENTRY_DATA);
        }
        ArrayList firstEnsemble = (ArrayList)lh.getLedgerMetadata().getEnsembles().get(0L);
        for (BookieSocketAddress bkAddr : firstEnsemble) {
            this.killBookie(firstEnsemble, bkAddr);
        }
        Set<LedgerFragment> result = this.getUnderReplicatedFragments(lh);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        for (LedgerFragment r : result) {
            LOG.info("unreplicated fragment: {}", (Object)r);
        }
        Assert.assertEquals((String)"There should be 1 fragments", (long)1L, (long)result.size());
        Assert.assertEquals((String)"There should be 3 failed bookies in the fragment", (long)3L, (long)result.iterator().next().getBookiesIndexes().size());
    }

    @Test
    public void testShouldNotGetAnyFragmentWithEmptyLedger() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 2, BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        Set<LedgerFragment> result = this.getUnderReplicatedFragments(lh);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        Assert.assertEquals((String)("There should be 0 fragments. But returned fragments are " + result), (long)0L, (long)result.size());
    }

    @Test
    public void testShouldGet2FragmentsWithEmptyLedgerButBookiesDead() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 2, BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        for (BookieSocketAddress b : (ArrayList)lh.getLedgerMetadata().getEnsembles().get(0L)) {
            this.killBookie(b);
        }
        Set<LedgerFragment> result = this.getUnderReplicatedFragments(lh);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        Assert.assertEquals((String)"There should be 1 fragments.", (long)1L, (long)result.size());
        Assert.assertEquals((String)"There should be 2 failed bookies in the fragment", (long)2L, (long)result.iterator().next().getBookiesIndexes().size());
    }

    @Test
    public void testShouldGetOneFragmentWithSingleEntryOpenedLedger() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        lh.addEntry(TEST_LEDGER_ENTRY_DATA);
        ArrayList firstEnsemble = (ArrayList)lh.getLedgerMetadata().getEnsembles().get(0L);
        BookieSocketAddress lastBookieFromEnsemble = (BookieSocketAddress)firstEnsemble.get(0);
        LOG.info("Killing " + lastBookieFromEnsemble + " from ensemble=" + firstEnsemble);
        this.killBookie(lastBookieFromEnsemble);
        this.startNewBookie();
        LedgerHandle lh1 = this.bkc.openLedgerNoRecovery(lh.getId(), BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        Set<LedgerFragment> result = this.getUnderReplicatedFragments(lh1);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        Assert.assertEquals((String)("There should be 1 fragment. But returned fragments are " + result), (long)1L, (long)result.size());
        Assert.assertEquals((String)"There should be 1 failed bookies in the fragment", (long)1L, (long)result.iterator().next().getBookiesIndexes().size());
    }

    @Test
    public void testSingleEntryAfterEnsembleChange() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(TEST_LEDGER_ENTRY_DATA);
        }
        ArrayList firstEnsemble = (ArrayList)lh.getLedgerMetadata().getEnsembles().get(0L);
        DistributionSchedule.WriteSet writeSet = lh.getDistributionSchedule().getWriteSet(lh.getLastAddPushed());
        BookieSocketAddress lastBookieFromEnsemble = (BookieSocketAddress)firstEnsemble.get(writeSet.get(0));
        LOG.info("Killing " + lastBookieFromEnsemble + " from ensemble=" + firstEnsemble);
        this.killBookie(lastBookieFromEnsemble);
        this.startNewBookie();
        lh.addEntry(TEST_LEDGER_ENTRY_DATA);
        writeSet = lh.getDistributionSchedule().getWriteSet(lh.getLastAddPushed());
        lastBookieFromEnsemble = (BookieSocketAddress)firstEnsemble.get(writeSet.get(1));
        LOG.info("Killing " + lastBookieFromEnsemble + " from ensemble=" + firstEnsemble);
        this.killBookie(lastBookieFromEnsemble);
        LedgerHandle lh1 = this.bkc.openLedgerNoRecovery(lh.getId(), BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        Set<LedgerFragment> result = this.getUnderReplicatedFragments(lh1);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        Assert.assertEquals((String)("There should be 2 fragments. But returned fragments are " + result), (long)2L, (long)result.size());
        for (LedgerFragment lf : result) {
            if (lf.getFirstEntryId() == 0L) {
                Assert.assertEquals((String)"There should be 2 failed bookies in first fragment", (long)2L, (long)lf.getBookiesIndexes().size());
                continue;
            }
            Assert.assertEquals((String)"There should be 1 failed bookie in second fragment", (long)1L, (long)lf.getBookiesIndexes().size());
        }
    }

    @Test
    public void testClosedEmptyLedger() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        ArrayList firstEnsemble = (ArrayList)lh.getLedgerMetadata().getEnsembles().get(0L);
        lh.close();
        BookieSocketAddress lastBookieFromEnsemble = (BookieSocketAddress)firstEnsemble.get(0);
        LOG.info("Killing " + lastBookieFromEnsemble + " from ensemble=" + firstEnsemble);
        this.killBookie(lastBookieFromEnsemble);
        LedgerHandle lh1 = this.bkc.openLedgerNoRecovery(lh.getId(), BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        Set<LedgerFragment> result = this.getUnderReplicatedFragments(lh1);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        Assert.assertEquals((String)("There should be 0 fragment. But returned fragments are " + result), (long)0L, (long)result.size());
    }

    @Test
    public void testClosedSingleEntryLedger() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 2, BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        ArrayList firstEnsemble = (ArrayList)lh.getLedgerMetadata().getEnsembles().get(0L);
        lh.addEntry(TEST_LEDGER_ENTRY_DATA);
        lh.close();
        BookieSocketAddress lastBookieFromEnsemble = (BookieSocketAddress)firstEnsemble.get(2);
        LOG.info("Killing " + lastBookieFromEnsemble + " from ensemble=" + firstEnsemble);
        this.killBookie(lastBookieFromEnsemble);
        LedgerHandle lh1 = this.bkc.openLedgerNoRecovery(lh.getId(), BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        Set<LedgerFragment> result = this.getUnderReplicatedFragments(lh1);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        Assert.assertEquals((String)("There should be 0 fragment. But returned fragments are " + result), (long)0L, (long)result.size());
        lh1.close();
        lastBookieFromEnsemble = (BookieSocketAddress)firstEnsemble.get(1);
        LOG.info("Killing " + lastBookieFromEnsemble + " from ensemble=" + firstEnsemble);
        this.killBookie(lastBookieFromEnsemble);
        this.startNewBookie();
        lh1 = this.bkc.openLedgerNoRecovery(lh.getId(), BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        result = this.getUnderReplicatedFragments(lh1);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        Assert.assertEquals((String)("There should be 1 fragment. But returned fragments are " + result), (long)1L, (long)result.size());
        Assert.assertEquals((String)"There should be 1 failed bookies in the fragment", (long)1L, (long)result.iterator().next().getBookiesIndexes().size());
        lh1.close();
        lastBookieFromEnsemble = (BookieSocketAddress)firstEnsemble.get(0);
        LOG.info("Killing " + lastBookieFromEnsemble + " from ensemble=" + firstEnsemble);
        this.killBookie(lastBookieFromEnsemble);
        this.startNewBookie();
        lh1 = this.bkc.openLedgerNoRecovery(lh.getId(), BookKeeper.DigestType.CRC32, TEST_LEDGER_PASSWORD);
        result = this.getUnderReplicatedFragments(lh1);
        Assert.assertNotNull((String)"Result shouldn't be null", result);
        Assert.assertEquals((String)("There should be 1 fragment. But returned fragments are " + result), (long)1L, (long)result.size());
        Assert.assertEquals((String)"There should be 2 failed bookies in the fragment", (long)2L, (long)result.iterator().next().getBookiesIndexes().size());
        lh1.close();
    }

    private Set<LedgerFragment> getUnderReplicatedFragments(LedgerHandle lh) throws InterruptedException {
        LedgerChecker checker = new LedgerChecker((BookKeeper)this.bkc);
        CheckerCallback cb = new CheckerCallback();
        checker.checkLedger(lh, (BookkeeperInternalCallbacks.GenericCallback)cb);
        Set<LedgerFragment> result = cb.waitAndGetResult();
        return result;
    }

    private void killBookie(ArrayList<BookieSocketAddress> firstEnsemble, BookieSocketAddress ensemble) throws Exception {
        LOG.info("Killing " + ensemble + " from ensemble=" + firstEnsemble);
        this.killBookie(ensemble);
    }

    class CheckerCallback
    implements BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> {
        private Set<LedgerFragment> result = null;
        private CountDownLatch latch = new CountDownLatch(1);

        CheckerCallback() {
        }

        public void operationComplete(int rc, Set<LedgerFragment> result) {
            this.result = result;
            this.latch.countDown();
        }

        Set<LedgerFragment> waitAndGetResult() throws InterruptedException {
            this.latch.await();
            return this.result;
        }
    }
}

