/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.MockBookKeeperTestCase;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.junit.Assert;
import org.junit.Test;

public class TestMaxEnsembleChangeNum
extends MockBookKeeperTestCase {
    private static final byte[] password = new byte[5];
    private static final byte[] data = new byte[5];

    @Test
    public void testChangeEnsembleMaxNumWithWriter() throws Exception {
        int numEntries = 5;
        int changeNum = 5;
        this.setBookkeeperConfig(new ClientConfiguration().setDelayEnsembleChange(false).setMaxAllowedEnsembleChanges(5));
        try (WriteHandle writer = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withAckQuorumSize(3).withWriteQuorumSize(3).withEnsembleSize(3).withPassword(password).execute());){
            long lId = writer.getId();
            for (int i = 0; i < numEntries; ++i) {
                writer.append(ByteBuffer.wrap(data));
            }
            Assert.assertEquals((String)"There should be zero ensemble change", (long)1L, (long)this.getLedgerMetadata(lId).getEnsembles().size());
            this.simulateEnsembleChangeWithWriter(changeNum, numEntries, writer);
            this.startNewBookie();
            this.killBookie((BookieSocketAddress)writer.getLedgerMetadata().getEnsembleAt(writer.getLastAddConfirmed()).get(0));
            try {
                writer.append(ByteBuffer.wrap(data));
                Assert.fail((String)"should not come to here");
            }
            catch (BKException exception) {
                Assert.assertEquals((long)exception.getCode(), (long)-12L);
            }
        }
    }

    private void simulateEnsembleChangeWithWriter(int changeNum, int numEntries, WriteHandle writer) throws Exception {
        int expectedSize = writer.getLedgerMetadata().getAllEnsembles().size() + 1;
        for (int num = 0; num < changeNum; ++num) {
            this.startNewBookie();
            this.killBookie((BookieSocketAddress)writer.getLedgerMetadata().getEnsembleAt(writer.getLastAddConfirmed()).get(0));
            for (int i = 0; i < numEntries; ++i) {
                writer.append(ByteBuffer.wrap(data));
            }
            Assert.assertEquals((String)"There should be one ensemble change", (long)(expectedSize + num), (long)writer.getLedgerMetadata().getAllEnsembles().size());
        }
    }
}

