/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.HashedWheelTimer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.SettableFeatureProvider;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.StaticDNSResolver;
import org.apache.commons.configuration.Configuration;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRackawareEnsemblePlacementPolicy
extends TestCase {
    static final Logger LOG = LoggerFactory.getLogger(TestRackawareEnsemblePlacementPolicy.class);
    RackawareEnsemblePlacementPolicy repp;
    final ArrayList<BookieSocketAddress> ensemble = new ArrayList();
    DistributionSchedule.WriteSet writeSet = DistributionSchedule.NULL_WRITE_SET;
    ClientConfiguration conf = new ClientConfiguration();
    BookieSocketAddress addr1;
    BookieSocketAddress addr2;
    BookieSocketAddress addr3;
    BookieSocketAddress addr4;
    HashedWheelTimer timer;

    protected void setUp() throws Exception {
        super.setUp();
        StaticDNSResolver.reset();
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostAddress(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack("127.0.0.1", "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack("localhost", "/default-region/default-rack");
        LOG.info("Set up static DNS Resolver.");
        this.conf.setProperty("reppDnsResolverClass", (Object)StaticDNSResolver.class.getName());
        this.addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        this.addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        this.addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        this.addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/default-region/rack1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/default-region/rack2");
        this.ensemble.add(this.addr1);
        this.ensemble.add(this.addr2);
        this.ensemble.add(this.addr3);
        this.ensemble.add(this.addr4);
        this.writeSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{0, 1, 2, 3});
        this.timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("TestTimer-%d").build(), this.conf.getTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, this.conf.getTimeoutTimerNumTicks());
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
    }

    protected void tearDown() throws Exception {
        this.repp.uninitalize();
        super.tearDown();
    }

    static BookiesHealthInfo getBookiesHealthInfo() {
        return TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieSocketAddress, Long>(), new HashMap<BookieSocketAddress, Long>());
    }

    static BookiesHealthInfo getBookiesHealthInfo(final Map<BookieSocketAddress, Long> bookieFailureHistory, final Map<BookieSocketAddress, Long> bookiePendingRequests) {
        return new BookiesHealthInfo(){

            public long getBookieFailureHistory(BookieSocketAddress bookieSocketAddress) {
                return bookieFailureHistory.getOrDefault(bookieSocketAddress, -1L);
            }

            public long getBookiePendingRequests(BookieSocketAddress bookieSocketAddress) {
                return bookiePendingRequests.getOrDefault(bookieSocketAddress, 0L);
            }
        };
    }

    static void updateMyRack(String rack) throws Exception {
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostAddress(), rack);
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostName(), rack);
        StaticDNSResolver.addNodeToRack("127.0.0.1", rack);
        StaticDNSResolver.addNodeToRack("localhost", rack);
    }

    @Test
    public void testNodeDown() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/default-region/default-rack");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeReadOnly() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1);
        HashSet<BookieSocketAddress> ro = new HashSet<BookieSocketAddress>();
        ro.add(this.addr1);
        this.repp.onClusterChanged(addrs, ro);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)reorderSet, (Object)origWriteSet);
    }

    @Test
    public void testNodeSlow() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        this.repp.registerSlowBookie(this.addr1, 0L);
        HashMap<BookieSocketAddress, Long> bookiePendingMap = new HashMap<BookieSocketAddress, Long>();
        bookiePendingMap.put(this.addr1, 1L);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieSocketAddress, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testTwoNodesSlow() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        this.repp.registerSlowBookie(this.addr1, 0L);
        this.repp.registerSlowBookie(this.addr2, 0L);
        HashMap<BookieSocketAddress, Long> bookiePendingMap = new HashMap<BookieSocketAddress, Long>();
        bookiePendingMap.put(this.addr1, 1L);
        bookiePendingMap.put(this.addr2, 2L);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieSocketAddress, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{2, 3, 0, 1});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testTwoNodesDown() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1);
        addrs.remove(this.addr2);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{2, 3, 0, 1});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeDownAndReadOnly() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1);
        addrs.remove(this.addr2);
        HashSet<BookieSocketAddress> roAddrs = new HashSet<BookieSocketAddress>();
        roAddrs.add(this.addr2);
        this.repp.onClusterChanged(addrs, roAddrs);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{2, 3, 1, 0});
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeDownAndNodeSlow() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        this.repp.registerSlowBookie(this.addr1, 0L);
        HashMap<BookieSocketAddress, Long> bookiePendingMap = new HashMap<BookieSocketAddress, Long>();
        bookiePendingMap.put(this.addr1, 1L);
        addrs.remove(this.addr2);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieSocketAddress, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{2, 3, 0, 1});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeDownAndReadOnlyAndNodeSlow() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1);
        addrs.remove(this.addr2);
        HashSet<BookieSocketAddress> ro = new HashSet<BookieSocketAddress>();
        ro.add(this.addr2);
        this.repp.registerSlowBookie(this.addr3, 0L);
        HashMap<BookieSocketAddress, Long> bookiePendingMap = new HashMap<BookieSocketAddress, Long>();
        bookiePendingMap.put(this.addr3, 1L);
        addrs.remove(this.addr2);
        this.repp.onClusterChanged(addrs, ro);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieSocketAddress, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 1, 2, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInSameRack() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r3");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        BookieSocketAddress replacedBookie = this.repp.replaceBookie(1, 1, 1, null, new HashSet(), addr2, new HashSet());
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)addr3, (Object)replacedBookie);
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInDifferentRack() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r4");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieSocketAddress> excludedAddrs = new HashSet<BookieSocketAddress>();
        excludedAddrs.add(addr1);
        BookieSocketAddress replacedBookie = this.repp.replaceBookie(1, 1, 1, null, new HashSet(), addr2, excludedAddrs);
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)addr1.equals((Object)replacedBookie));
        TestRackawareEnsemblePlacementPolicy.assertTrue((addr3.equals((Object)replacedBookie) || addr4.equals((Object)replacedBookie) ? 1 : 0) != 0);
    }

    @Test
    public void testReplaceBookieWithNotEnoughBookies() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r4");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieSocketAddress> excludedAddrs = new HashSet<BookieSocketAddress>();
        excludedAddrs.add(addr1);
        excludedAddrs.add(addr3);
        excludedAddrs.add(addr4);
        try {
            this.repp.replaceBookie(1, 1, 1, null, new HashSet(), addr2, excludedAddrs);
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should throw BKNotEnoughBookiesException when there is not enough bookies");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInSameRackAsEnsemble() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/r3");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieSocketAddress> ensembleBookies = new HashSet<BookieSocketAddress>();
        ensembleBookies.add(addr2);
        ensembleBookies.add(addr4);
        BookieSocketAddress replacedBookie = this.repp.replaceBookie(1, 1, 1, null, ensembleBookies, addr4, new HashSet());
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)addr1, (Object)replacedBookie);
    }

    @Test
    public void testNewEnsembleWithSingleRack() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.9", 3181);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            ArrayList ensemble = this.repp.newEnsemble(3, 2, 2, null, new HashSet());
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)0, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, 2));
            ArrayList ensemble2 = this.repp.newEnsemble(4, 2, 2, null, new HashSet());
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)0, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble2, 2));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithMultipleRacks() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r2");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            ArrayList ensemble = this.repp.newEnsemble(3, 2, 2, null, new HashSet());
            int numCovered = TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, 2);
            TestRackawareEnsemblePlacementPolicy.assertTrue((numCovered >= 1 && numCovered < 3 ? 1 : 0) != 0);
            ArrayList ensemble2 = this.repp.newEnsemble(4, 2, 2, null, new HashSet());
            numCovered = TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble2, 2);
            TestRackawareEnsemblePlacementPolicy.assertTrue((numCovered >= 1 && numCovered < 3 ? 1 : 0) != 0);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithEnoughRacks() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/default-region/r4");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        addrs.add(addr5);
        addrs.add(addr6);
        addrs.add(addr7);
        addrs.add(addr8);
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            ArrayList ensemble1 = this.repp.newEnsemble(3, 2, 2, null, new HashSet());
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)3, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble1, 2));
            ArrayList ensemble2 = this.repp.newEnsemble(4, 2, 2, null, new HashSet());
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)4, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble2, 2));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testRemoveBookieFromCluster() {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r3");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(addr1);
        this.repp.onClusterChanged(addrs, new HashSet());
    }

    @Test
    public void testWeightedPlacementAndReplaceBookieWithEnoughBookiesInSameRack() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getSocketAddress().getAddress().getHostAddress(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr4.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        int multiple = 10;
        this.conf.setDiskWeightBasedPlacementEnabled(true);
        this.conf.setBookieMaxWeightMultipleForWeightBasedPlacement(-1);
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieSocketAddress, BookieInfoReader.BookieInfo> bookieInfoMap = new HashMap<BookieSocketAddress, BookieInfoReader.BookieInfo>();
        bookieInfoMap.put(addr1, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr2, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr3, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr4, new BookieInfoReader.BookieInfo((long)multiple * 100L, (long)multiple * 100L));
        this.repp.updateBookieInfo(bookieInfoMap);
        HashMap<BookieSocketAddress, Long> selectionCounts = new HashMap<BookieSocketAddress, Long>();
        selectionCounts.put(addr3, 0L);
        selectionCounts.put(addr4, 0L);
        int numTries = 50000;
        for (int i = 0; i < numTries; ++i) {
            BookieSocketAddress replacedBookie = this.repp.replaceBookie(1, 1, 1, null, new HashSet(), addr2, new HashSet());
            TestRackawareEnsemblePlacementPolicy.assertTrue((String)("replaced : " + replacedBookie), (addr3.equals((Object)replacedBookie) || addr4.equals((Object)replacedBookie) ? 1 : 0) != 0);
            selectionCounts.put(replacedBookie, (Long)selectionCounts.get(replacedBookie) + 1L);
        }
        double observedMultiple = (double)((Long)selectionCounts.get(addr4)).longValue() / (double)((Long)selectionCounts.get(addr3)).longValue();
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("Weights not being honored " + observedMultiple), (Math.abs(observedMultiple - (double)multiple) < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testWeightedPlacementAndReplaceBookieWithoutEnoughBookiesInSameRack() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        StaticDNSResolver.reset();
        StaticDNSResolver.addNodeToRack(addr1.getSocketAddress().getAddress().getHostAddress(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr4.getSocketAddress().getAddress().getHostAddress(), "/default-region/r4");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        int multiple = 10;
        int maxMultiple = 4;
        this.conf.setDiskWeightBasedPlacementEnabled(true);
        this.conf.setBookieMaxWeightMultipleForWeightBasedPlacement(maxMultiple);
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieSocketAddress, BookieInfoReader.BookieInfo> bookieInfoMap = new HashMap<BookieSocketAddress, BookieInfoReader.BookieInfo>();
        bookieInfoMap.put(addr1, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr2, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr3, new BookieInfoReader.BookieInfo(200L, 200L));
        bookieInfoMap.put(addr4, new BookieInfoReader.BookieInfo((long)multiple * 100L, (long)multiple * 100L));
        this.repp.updateBookieInfo(bookieInfoMap);
        HashMap<BookieSocketAddress, Long> selectionCounts = new HashMap<BookieSocketAddress, Long>();
        selectionCounts.put(addr1, 0L);
        selectionCounts.put(addr2, 0L);
        selectionCounts.put(addr3, 0L);
        selectionCounts.put(addr4, 0L);
        int numTries = 50000;
        for (int i = 0; i < numTries; ++i) {
            BookieSocketAddress replacedBookie = this.repp.replaceBookie(1, 1, 1, null, new HashSet(), addr2, new HashSet());
            TestRackawareEnsemblePlacementPolicy.assertTrue((addr1.equals((Object)replacedBookie) || addr3.equals((Object)replacedBookie) || addr4.equals((Object)replacedBookie) ? 1 : 0) != 0);
            selectionCounts.put(replacedBookie, (Long)selectionCounts.get(replacedBookie) + 1L);
        }
        double medianWeight = 150.0;
        double medianSelectionCounts = medianWeight / (double)((BookieInfoReader.BookieInfo)bookieInfoMap.get(addr1)).getWeight() * (double)((Long)selectionCounts.get(addr1)).longValue();
        double observedMultiple1 = (double)((Long)selectionCounts.get(addr4)).longValue() / medianSelectionCounts;
        double observedMultiple2 = (double)((Long)selectionCounts.get(addr4)).longValue() / (double)((Long)selectionCounts.get(addr3)).longValue();
        LOG.info("oM1 " + observedMultiple1 + " oM2 " + observedMultiple2);
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("Weights not being honored expected " + maxMultiple + " observed " + observedMultiple1), (Math.abs(observedMultiple1 - (double)maxMultiple) < 1.0 ? 1 : 0) != 0);
        double expected = medianWeight * (double)maxMultiple / (double)((BookieInfoReader.BookieInfo)bookieInfoMap.get(addr3)).getWeight();
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("Weights not being honored expected " + expected + " observed " + observedMultiple2), (Math.abs(observedMultiple2 - expected) < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testWeightedPlacementAndNewEnsembleWithEnoughBookiesInSameRack() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.9", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getSocketAddress().getAddress().getHostAddress(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr4.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr5.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr6.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr7.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr8.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr9.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        addrs.add(addr5);
        addrs.add(addr6);
        addrs.add(addr7);
        addrs.add(addr8);
        addrs.add(addr9);
        int maxMultiple = 4;
        this.conf.setDiskWeightBasedPlacementEnabled(true);
        this.conf.setBookieMaxWeightMultipleForWeightBasedPlacement(maxMultiple);
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieSocketAddress, BookieInfoReader.BookieInfo> bookieInfoMap = new HashMap<BookieSocketAddress, BookieInfoReader.BookieInfo>();
        bookieInfoMap.put(addr1, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr2, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr3, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr4, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr5, new BookieInfoReader.BookieInfo(1000L, 1000L));
        bookieInfoMap.put(addr6, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr7, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr8, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr9, new BookieInfoReader.BookieInfo(1000L, 1000L));
        this.repp.updateBookieInfo(bookieInfoMap);
        HashMap<BookieSocketAddress, Long> selectionCounts = new HashMap<BookieSocketAddress, Long>();
        for (BookieSocketAddress b : addrs) {
            selectionCounts.put(b, 0L);
        }
        int numTries = 10000;
        HashSet excludeList = new HashSet();
        for (int i = 0; i < numTries; ++i) {
            ArrayList ensemble = this.repp.newEnsemble(3, 2, 2, null, excludeList);
            TestRackawareEnsemblePlacementPolicy.assertTrue((String)("Rackaware selection not happening " + TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, 2)), (TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, 2) >= 2 ? 1 : 0) != 0);
            for (BookieSocketAddress b : ensemble) {
                selectionCounts.put(b, (Long)selectionCounts.get(b) + 1L);
            }
        }
        double observedMultiple1 = (double)((Long)selectionCounts.get(addr5)).longValue() / (double)((Long)selectionCounts.get(addr2)).longValue();
        double observedMultiple2 = (double)((Long)selectionCounts.get(addr9)).longValue() / (double)((Long)selectionCounts.get(addr6)).longValue();
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("Weights not being honored expected 2 observed " + observedMultiple1), (Math.abs(observedMultiple1 - (double)maxMultiple) < 0.5 ? 1 : 0) != 0);
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("Weights not being honored expected 4 observed " + observedMultiple2), (Math.abs(observedMultiple2 - (double)maxMultiple) < 0.5 ? 1 : 0) != 0);
    }

    @Test
    public void testWeightedPlacementAndNewEnsembleWithoutEnoughBookies() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getSocketAddress().getAddress().getHostAddress(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr4.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr5.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        addrs.add(addr5);
        int maxMultiple = 4;
        this.conf.setDiskWeightBasedPlacementEnabled(true);
        this.conf.setBookieMaxWeightMultipleForWeightBasedPlacement(maxMultiple);
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieSocketAddress, BookieInfoReader.BookieInfo> bookieInfoMap = new HashMap<BookieSocketAddress, BookieInfoReader.BookieInfo>();
        bookieInfoMap.put(addr1, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr2, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr3, new BookieInfoReader.BookieInfo(1000L, 1000L));
        bookieInfoMap.put(addr4, new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr5, new BookieInfoReader.BookieInfo(1000L, 1000L));
        this.repp.updateBookieInfo(bookieInfoMap);
        ArrayList ensemble = new ArrayList();
        HashSet<BookieSocketAddress> excludeList = new HashSet<BookieSocketAddress>();
        try {
            excludeList.add(addr1);
            excludeList.add(addr2);
            excludeList.add(addr3);
            excludeList.add(addr4);
            ensemble = this.repp.newEnsemble(3, 2, 2, null, excludeList);
            TestRackawareEnsemblePlacementPolicy.fail((String)("Should throw BKNotEnoughBookiesException when there is not enough bookies" + ensemble));
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        try {
            ensemble = this.repp.newEnsemble(1, 1, 1, null, excludeList);
        }
        catch (BKException.BKNotEnoughBookiesException e) {
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should not throw BKNotEnoughBookiesException when there are enough bookies for the ensemble");
        }
    }

    static int getNumCoveredWriteQuorums(ArrayList<BookieSocketAddress> ensemble, int writeQuorumSize) throws Exception {
        int ensembleSize = ensemble.size();
        int numCoveredWriteQuorums = 0;
        for (int i = 0; i < ensembleSize; ++i) {
            HashSet<String> racks = new HashSet<String>();
            for (int j = 0; j < writeQuorumSize; ++j) {
                int bookieIdx = (i + j) % ensembleSize;
                BookieSocketAddress addr = ensemble.get(bookieIdx);
                racks.add(StaticDNSResolver.getRack(addr.getHostName()));
            }
            numCoveredWriteQuorums += racks.size() > 1 ? 1 : 0;
        }
        return numCoveredWriteQuorums;
    }

    @Test
    public void testNodeWithFailures() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/default-region/default-rack");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieSocketAddress, Long> bookieFailures = new HashMap<BookieSocketAddress, Long>();
        bookieFailures.put(this.addr1, 20L);
        bookieFailures.put(this.addr2, 22L);
        addrs = new HashSet();
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet reoderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(bookieFailures, new HashMap<BookieSocketAddress, Long>()), this.writeSet);
        LOG.info("reorder set : {}", (Object)reoderSet);
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(2)), (Object)this.addr1);
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(3)), (Object)this.addr2);
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(0)), (Object)this.addr3);
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(1)), (Object)this.addr4);
    }

    @Test
    public void testPlacementOnStabilizeNetworkTopology() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/default-region/default-rack");
        this.repp = new RackawareEnsemblePlacementPolicy();
        ClientConfiguration confLocal = new ClientConfiguration();
        confLocal.addConfiguration((Configuration)this.conf);
        confLocal.setNetworkTopologyStabilizePeriodSeconds(99999);
        this.repp.initialize(confLocal, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(this.addr1);
        addrs.add(this.addr2);
        addrs.add(this.addr3);
        addrs.add(this.addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr4);
        Set deadBookies = this.repp.onClusterChanged(addrs, new HashSet());
        TestRackawareEnsemblePlacementPolicy.assertTrue((boolean)deadBookies.isEmpty());
        for (int i = 0; i < 5; ++i) {
            ArrayList ensemble = this.repp.newEnsemble(3, 3, 3, null, new HashSet());
            TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)ensemble.contains(this.addr4));
        }
        ArrayList ensemble = this.repp.newEnsemble(4, 4, 4, null, new HashSet());
        TestRackawareEnsemblePlacementPolicy.assertTrue((boolean)ensemble.contains(this.addr4));
    }

    @Test
    public void testShuffleWithMask() {
        DistributionSchedule.WriteSet w;
        int i;
        int mask = 0xE10000;
        int maskBits = 0xFF0000;
        boolean shuffleOccurred = false;
        for (i = 0; i < 100; ++i) {
            w = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3 & mask, 4 & mask, 5 & mask, 6});
            RackawareEnsemblePlacementPolicy.shuffleWithMask((DistributionSchedule.WriteSet)w, (int)mask, (int)maskBits);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(0), (int)1);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(1), (int)2);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(5), (int)6);
            if (w.get(3) == (3 & mask) || w.get(4) == (3 & mask)) {
                shuffleOccurred = true;
            } else if (w.get(2) != (3 & mask)) {
                TestRackawareEnsemblePlacementPolicy.fail((String)"3 not found");
            }
            if (w.get(2) == (4 & mask) || w.get(4) == (4 & mask)) {
                shuffleOccurred = true;
            } else if (w.get(3) != (4 & mask)) {
                TestRackawareEnsemblePlacementPolicy.fail((String)"4 not found");
            }
            if (w.get(2) == (5 & mask) || w.get(3) == (5 & mask)) {
                shuffleOccurred = true;
                continue;
            }
            if (w.get(4) == (5 & mask)) continue;
            TestRackawareEnsemblePlacementPolicy.fail((String)"5 not found");
        }
        TestRackawareEnsemblePlacementPolicy.assertTrue((boolean)shuffleOccurred);
        shuffleOccurred = false;
        for (i = 0; i < 100; ++i) {
            w = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1 & mask, 2 & mask, 3 & mask, 4, 5, 6});
            RackawareEnsemblePlacementPolicy.shuffleWithMask((DistributionSchedule.WriteSet)w, (int)mask, (int)maskBits);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(3), (int)4);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(4), (int)5);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(5), (int)6);
            if (w.get(1) == (1 & mask) || w.get(2) == (1 & mask)) {
                shuffleOccurred = true;
            } else if (w.get(0) != (1 & mask)) {
                TestRackawareEnsemblePlacementPolicy.fail((String)"1 not found");
            }
            if (w.get(0) == (2 & mask) || w.get(2) == (2 & mask)) {
                shuffleOccurred = true;
            } else if (w.get(1) != (2 & mask)) {
                TestRackawareEnsemblePlacementPolicy.fail((String)"2 not found");
            }
            if (w.get(0) == (3 & mask) || w.get(1) == (3 & mask)) {
                shuffleOccurred = true;
                continue;
            }
            if (w.get(2) == (3 & mask)) continue;
            TestRackawareEnsemblePlacementPolicy.fail((String)"3 not found");
        }
        TestRackawareEnsemblePlacementPolicy.assertTrue((boolean)shuffleOccurred);
        shuffleOccurred = false;
        for (i = 0; i < 100; ++i) {
            w = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3, 4 & mask, 5 & mask, 6 & mask});
            RackawareEnsemblePlacementPolicy.shuffleWithMask((DistributionSchedule.WriteSet)w, (int)mask, (int)maskBits);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(0), (int)1);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(1), (int)2);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(2), (int)3);
            if (w.get(4) == (4 & mask) || w.get(5) == (4 & mask)) {
                shuffleOccurred = true;
            } else if (w.get(3) != (4 & mask)) {
                TestRackawareEnsemblePlacementPolicy.fail((String)"4 not found");
            }
            if (w.get(3) == (5 & mask) || w.get(5) == (5 & mask)) {
                shuffleOccurred = true;
            } else if (w.get(4) != (5 & mask)) {
                TestRackawareEnsemblePlacementPolicy.fail((String)"5 not found");
            }
            if (w.get(3) == (6 & mask) || w.get(4) == (6 & mask)) {
                shuffleOccurred = true;
                continue;
            }
            if (w.get(5) == (6 & mask)) continue;
            TestRackawareEnsemblePlacementPolicy.fail((String)"6 not found");
        }
        TestRackawareEnsemblePlacementPolicy.assertTrue((boolean)shuffleOccurred);
    }
}

