/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.HashedWheelTimer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.SettableFeatureProvider;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.ScriptBasedMapping;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRackawareEnsemblePlacementPolicyUsingScript {
    static final Logger LOG = LoggerFactory.getLogger(TestRackawareEnsemblePlacementPolicyUsingScript.class);
    HashedWheelTimer timer;
    RackawareEnsemblePlacementPolicy repp;
    ClientConfiguration conf = new ClientConfiguration();

    @Before
    public void setUp() throws Exception {
        this.conf.setProperty("reppDnsResolverClass", (Object)ScriptBasedMapping.class.getName());
        this.conf.setProperty("networkTopologyScriptFileName", (Object)"src/test/resources/networkmappingscript.sh");
        this.timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("TestTimer-%d").build(), this.conf.getTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, this.conf.getTimeoutTimerNumTicks());
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    @After
    public void tearDown() throws Exception {
        this.repp.uninitalize();
    }

    private void ignoreTestIfItIsWindowsOS() {
        Assume.assumeTrue((!Shell.WINDOWS ? 1 : 0) != 0);
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInSameRack() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.1.2", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        BookieSocketAddress replacedBookie = this.repp.replaceBookie(1, 1, 1, null, new HashSet(), addr2, new HashSet());
        Assert.assertEquals((Object)addr3, (Object)replacedBookie);
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInDifferentRack() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieSocketAddress> excludedAddrs = new HashSet<BookieSocketAddress>();
        excludedAddrs.add(addr1);
        BookieSocketAddress replacedBookie = this.repp.replaceBookie(1, 1, 1, null, new HashSet(), addr2, excludedAddrs);
        Assert.assertFalse((boolean)addr1.equals((Object)replacedBookie));
        Assert.assertTrue((addr3.equals((Object)replacedBookie) || addr4.equals((Object)replacedBookie) ? 1 : 0) != 0);
    }

    @Test
    public void testReplaceBookieWithNotEnoughBookies() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieSocketAddress> excludedAddrs = new HashSet<BookieSocketAddress>();
        excludedAddrs.add(addr1);
        excludedAddrs.add(addr3);
        excludedAddrs.add(addr4);
        try {
            this.repp.replaceBookie(1, 1, 1, null, new HashSet(), addr2, excludedAddrs);
            Assert.fail((String)"Should throw BKNotEnoughBookiesException when there is not enough bookies");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceBookieWithScriptMappingError() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr0 = new BookieSocketAddress("127.0.0.0", 3181);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs = new HashSet();
        addrs.add(addr0);
        addrs.add(addr1);
        addrs.add(addr2);
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieSocketAddress> excludedAddrs = new HashSet<BookieSocketAddress>();
        excludedAddrs.add(addr1);
        BookieSocketAddress replacedBookie = this.repp.replaceBookie(1, 1, 1, null, new HashSet(), addr2, excludedAddrs);
        Assert.assertFalse((boolean)addr1.equals((Object)replacedBookie));
        Assert.assertFalse((boolean)addr2.equals((Object)replacedBookie));
        Assert.assertTrue((boolean)addr0.equals((Object)replacedBookie));
    }

    @Test
    public void testReplaceBookieWithScriptMappingError2() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr0 = new BookieSocketAddress("127.0.0.0", 3181);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr0);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs = new HashSet();
        addrs.add(addr0);
        addrs.add(addr1);
        addrs.add(addr2);
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieSocketAddress> excludedAddrs = new HashSet<BookieSocketAddress>();
        excludedAddrs.add(addr1);
        BookieSocketAddress replacedBookie = this.repp.replaceBookie(1, 1, 1, null, new HashSet(), addr2, excludedAddrs);
        Assert.assertFalse((boolean)addr1.equals((Object)replacedBookie));
        Assert.assertFalse((boolean)addr2.equals((Object)replacedBookie));
        Assert.assertTrue((boolean)addr0.equals((Object)replacedBookie));
    }

    @Test
    public void testNewEnsembleWithSingleRack() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.1.1", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.2.1", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.3.1", 3181);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            ArrayList ensemble = this.repp.newEnsemble(3, 2, 2, null, new HashSet());
            Assert.assertEquals((long)0L, (long)this.getNumCoveredWriteQuorums(ensemble, 2));
            ArrayList ensemble2 = this.repp.newEnsemble(4, 2, 2, null, new HashSet());
            Assert.assertEquals((long)0L, (long)this.getNumCoveredWriteQuorums(ensemble2, 2));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            Assert.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithMultipleRacks() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.1.2", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.2.2", 3181);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            ArrayList ensemble = this.repp.newEnsemble(3, 2, 2, null, new HashSet());
            int numCovered = this.getNumCoveredWriteQuorums(ensemble, 2);
            Assert.assertTrue((numCovered == 2 ? 1 : 0) != 0);
            ArrayList ensemble2 = this.repp.newEnsemble(4, 2, 2, null, new HashSet());
            numCovered = this.getNumCoveredWriteQuorums(ensemble2, 2);
            Assert.assertTrue((numCovered == 2 ? 1 : 0) != 0);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            Assert.fail((String)"Should not get not enough bookies exception");
        }
    }

    @Test
    public void testNewEnsembleWithEnoughRacks() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.1.1", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.1.2", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.1.3", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.1.4", 3181);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        addrs.add(addr5);
        addrs.add(addr6);
        addrs.add(addr7);
        addrs.add(addr8);
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            ArrayList ensemble1 = this.repp.newEnsemble(3, 2, 2, null, new HashSet());
            Assert.assertEquals((long)3L, (long)this.getNumCoveredWriteQuorums(ensemble1, 2));
            ArrayList ensemble2 = this.repp.newEnsemble(4, 2, 2, null, new HashSet());
            Assert.assertEquals((long)4L, (long)this.getNumCoveredWriteQuorums(ensemble2, 2));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            Assert.fail((String)"Should not get not enough bookies exception.");
        }
    }

    @Test
    public void testRemoveBookieFromCluster() {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.1.2", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        HashSet<BookieSocketAddress> addrs = new HashSet<BookieSocketAddress>();
        addrs.add(addr1);
        addrs.add(addr2);
        addrs.add(addr3);
        addrs.add(addr4);
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(addr1);
        this.repp.onClusterChanged(addrs, new HashSet());
    }

    private int getNumCoveredWriteQuorums(ArrayList<BookieSocketAddress> ensemble, int writeQuorumSize) throws Exception {
        int ensembleSize = ensemble.size();
        int numCoveredWriteQuorums = 0;
        for (int i = 0; i < ensembleSize; ++i) {
            HashSet<String> racks = new HashSet<String>();
            for (int j = 0; j < writeQuorumSize; ++j) {
                int bookieIdx = (i + j) % ensembleSize;
                BookieSocketAddress addr = ensemble.get(bookieIdx);
                String hostAddress = addr.getSocketAddress().getAddress().getHostAddress();
                String rack = "/" + hostAddress.charAt(hostAddress.length() - 1);
                racks.add(rack);
            }
            numCoveredWriteQuorums += racks.size() > 1 ? 1 : 0;
        }
        return numCoveredWriteQuorums;
    }
}

