/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSequenceRead
extends BookKeeperClusterTestCase {
    private static final Logger logger = LoggerFactory.getLogger(TestSequenceRead.class);
    final BookKeeper.DigestType digestType;
    final byte[] passwd = "sequence-read".getBytes();

    public TestSequenceRead() {
        super(5);
        this.digestType = BookKeeper.DigestType.CRC32;
    }

    private LedgerHandle createLedgerWithDuplicatedBookies() throws Exception {
        final LedgerHandle lh = this.bkc.createLedger(3, 3, 3, this.digestType, this.passwd);
        TreeMap ensembles = lh.getLedgerMetadata().getEnsembles();
        TreeMap newEnsembles = new TreeMap();
        for (Map.Entry entry : ensembles.entrySet()) {
            ArrayList<BookieSocketAddress> newList = new ArrayList<BookieSocketAddress>(((ArrayList)entry.getValue()).size());
            BookieSocketAddress firstBookie = (BookieSocketAddress)((ArrayList)entry.getValue()).get(0);
            for (BookieSocketAddress ignored : (ArrayList)entry.getValue()) {
                newList.add(firstBookie);
            }
            newEnsembles.put(entry.getKey(), newList);
        }
        lh.getLedgerMetadata().setEnsembles(newEnsembles);
        final CountDownLatch latch = new CountDownLatch(1);
        this.bkc.getLedgerManager().writeLedgerMetadata(lh.getId(), lh.getLedgerMetadata(), (BookkeeperInternalCallbacks.GenericCallback)new BookkeeperInternalCallbacks.GenericCallback<Void>(){

            public void operationComplete(int rc, Void result) {
                if (0 == rc) {
                    latch.countDown();
                } else {
                    logger.error("Error on writing ledger metadata for ledger {} : ", (Object)lh.getId(), (Object)BKException.getMessage((int)rc));
                }
            }
        });
        latch.await();
        logger.info("Update ledger metadata with duplicated bookies for ledger {}.", (Object)lh.getId());
        return lh;
    }

    @Test
    public void testSequenceReadOnDuplicatedBookies() throws Exception {
        LedgerHandle lh = this.createLedgerWithDuplicatedBookies();
        LedgerHandle readLh = this.bkc.openLedger(lh.getId(), this.digestType, this.passwd);
        Assert.assertEquals((long)-1L, (long)readLh.getLastAddConfirmed());
    }
}

