/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTryReadLastConfirmed
extends BookKeeperClusterTestCase {
    private static final Logger logger = LoggerFactory.getLogger(TestTryReadLastConfirmed.class);
    final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    public TestTryReadLastConfirmed() {
        super(6);
    }

    @Test
    public void testTryReadLACWhenAllBookiesUp() throws Exception {
        int numEntries = 3;
        LedgerHandle lh = this.bkc.createLedger(3, 3, 1, this.digestType, "".getBytes());
        LedgerHandle readLh = this.bkc.openLedgerNoRecovery(lh.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((long)-1L, (long)readLh.getLastAddConfirmed());
        for (int i = 0; i < 3; ++i) {
            lh.addEntry(("data" + i).getBytes());
        }
        final AtomicBoolean success = new AtomicBoolean(false);
        final AtomicInteger numCallbacks = new AtomicInteger(0);
        final CountDownLatch latch1 = new CountDownLatch(1);
        readLh.asyncTryReadLastConfirmed(new AsyncCallback.ReadLastConfirmedCallback(){

            public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
                numCallbacks.incrementAndGet();
                if (0 == rc) {
                    success.set(true);
                } else {
                    success.set(false);
                }
                latch1.countDown();
            }
        }, null);
        latch1.await();
        TimeUnit.SECONDS.sleep(2L);
        Assert.assertTrue((boolean)success.get());
        Assert.assertTrue((numCallbacks.get() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)readLh.getLastAddConfirmed());
        success.set(false);
        numCallbacks.set(0);
        final CountDownLatch latch2 = new CountDownLatch(1);
        readLh.asyncTryReadLastConfirmed(new AsyncCallback.ReadLastConfirmedCallback(){

            public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
                numCallbacks.incrementAndGet();
                if (0 == rc && lastConfirmed == 1L) {
                    success.set(true);
                } else {
                    success.set(false);
                }
                latch2.countDown();
            }
        }, null);
        latch2.await();
        TimeUnit.SECONDS.sleep(2L);
        Assert.assertTrue((boolean)success.get());
        Assert.assertTrue((numCallbacks.get() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)readLh.getLastAddConfirmed());
        lh.close();
        readLh.close();
    }

    @Test
    public void testTryReadLaCWhenSomeBookiesDown() throws Exception {
        int i;
        int numEntries = 3;
        int ensembleSize = 3;
        LedgerHandle lh = this.bkc.createLedger(3, 1, 1, this.digestType, "".getBytes());
        LedgerHandle readLh = this.bkc.openLedgerNoRecovery(lh.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((long)-1L, (long)readLh.getLastAddConfirmed());
        for (i = 0; i < 3; ++i) {
            lh.addEntry(("data" + i).getBytes());
        }
        for (i = 0; i < 3; ++i) {
            ServerConfiguration[] confs = new ServerConfiguration[2];
            for (int j = 0; j < 2; ++j) {
                int idx = (i + 1 + j) % 3;
                confs[j] = this.killBookie((BookieSocketAddress)lh.getLedgerMetadata().currentEnsemble.get(idx));
            }
            final AtomicBoolean success = new AtomicBoolean(false);
            final AtomicInteger numCallbacks = new AtomicInteger(0);
            final CountDownLatch latch = new CountDownLatch(1);
            final int entryId = i;
            readLh.asyncTryReadLastConfirmed(new AsyncCallback.ReadLastConfirmedCallback(){

                public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
                    numCallbacks.incrementAndGet();
                    if (0 == rc) {
                        success.set(lastConfirmed == (long)(entryId - 1));
                    } else {
                        success.set(false);
                    }
                    latch.countDown();
                }
            }, null);
            latch.await();
            Assert.assertTrue((boolean)success.get());
            Assert.assertTrue((numCallbacks.get() == 1 ? 1 : 0) != 0);
            for (ServerConfiguration conf : confs) {
                this.bs.add(this.startBookie(conf));
                this.bsConfs.add(conf);
            }
        }
        lh.close();
        readLh.close();
    }

    @Test
    public void testTryReadLACWhenAllBookiesDown() throws Exception {
        int i;
        int numEntries = 2;
        int ensembleSize = 3;
        LedgerHandle lh = this.bkc.createLedger(3, 1, 1, this.digestType, "".getBytes());
        LedgerHandle readLh = this.bkc.openLedgerNoRecovery(lh.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((long)-1L, (long)readLh.getLastAddConfirmed());
        for (i = 0; i < 2; ++i) {
            lh.addEntry(("data" + i).getBytes());
        }
        for (i = 0; i < 3; ++i) {
            this.killBookie((BookieSocketAddress)lh.getLedgerMetadata().currentEnsemble.get(i));
        }
        final AtomicBoolean success = new AtomicBoolean(false);
        final AtomicInteger numCallbacks = new AtomicInteger(0);
        final CountDownLatch latch = new CountDownLatch(1);
        readLh.asyncTryReadLastConfirmed(new AsyncCallback.ReadLastConfirmedCallback(){

            public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
                logger.info("ReadLastConfirmedComplete : rc = {}, lac = {}.", (Object)rc, (Object)lastConfirmed);
                numCallbacks.incrementAndGet();
                if (0 == rc) {
                    success.set(lastConfirmed == -1L);
                } else {
                    success.set(false);
                }
                latch.countDown();
            }
        }, null);
        latch.await();
        TimeUnit.SECONDS.sleep(2L);
        Assert.assertFalse((boolean)success.get());
        Assert.assertTrue((numCallbacks.get() == 1 ? 1 : 0) != 0);
        lh.close();
        readLh.close();
    }
}

