/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.FlatLedgerManagerFactory;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LongHierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.MSLedgerManagerFactory;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.versioning.Version;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestWatchEnsembleChange
extends BookKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(TestWatchEnsembleChange.class);
    final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    final Class<? extends LedgerManagerFactory> lmFactoryCls;

    public TestWatchEnsembleChange(Class<? extends LedgerManagerFactory> lmFactoryCls) {
        super(7);
        this.lmFactoryCls = lmFactoryCls;
        this.baseClientConf.setLedgerManagerFactoryClass(lmFactoryCls);
        this.baseConf.setLedgerManagerFactoryClass(lmFactoryCls);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        return Arrays.asList({FlatLedgerManagerFactory.class}, {HierarchicalLedgerManagerFactory.class}, {LongHierarchicalLedgerManagerFactory.class}, {MSLedgerManagerFactory.class});
    }

    @Test
    public void testWatchEnsembleChange() throws Exception {
        int numEntries = 10;
        LedgerHandle lh = this.bkc.createLedger(3, 3, 3, this.digestType, "".getBytes());
        for (int i = 0; i < numEntries; ++i) {
            lh.addEntry(("data" + i).getBytes());
            LOG.info("Added entry {}.", (Object)i);
        }
        LedgerHandle readLh = this.bkc.openLedgerNoRecovery(lh.getId(), this.digestType, "".getBytes());
        long lastLAC = readLh.getLastAddConfirmed();
        Assert.assertEquals((long)(numEntries - 2), (long)lastLAC);
        ArrayList ensemble = lh.getLedgerMetadata().currentEnsemble;
        for (BookieSocketAddress addr : ensemble) {
            this.killBookie(addr);
        }
        for (int i = 0; i < numEntries; ++i) {
            lh.addEntry(("data" + (numEntries + i)).getBytes());
            LOG.info("Added entry {}.", (Object)(numEntries + i));
        }
        TimeUnit.SECONDS.sleep(5L);
        readLh.readLastConfirmed();
        Assert.assertEquals((long)(2 * numEntries - 2), (long)readLh.getLastAddConfirmed());
        readLh.close();
        lh.close();
    }

    @Test
    public void testWatchMetadataRemoval() throws Exception {
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        MetadataDrivers.runFunctionWithLedgerManagerFactory((ServerConfiguration)this.baseConf, factory -> {
            try {
                this.testWatchMetadataRemoval((LedgerManagerFactory)factory);
            }
            catch (Exception e) {
                throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWatchMetadataRemoval(LedgerManagerFactory factory) throws Exception {
        final LedgerManager manager = factory.newLedgerManager();
        try {
            LedgerIdGenerator idGenerator = factory.newLedgerIdGenerator();
            try {
                final ByteBuffer bbLedgerId = ByteBuffer.allocate(8);
                final CountDownLatch createLatch = new CountDownLatch(1);
                final CountDownLatch removeLatch = new CountDownLatch(1);
                idGenerator.generateLedgerId((BookkeeperInternalCallbacks.GenericCallback)new BookkeeperInternalCallbacks.GenericCallback<Long>(){

                    public void operationComplete(int rc, final Long lid) {
                        manager.createLedgerMetadata(lid.longValue(), new LedgerMetadata(4, 2, 2, TestWatchEnsembleChange.this.digestType, "fpj was here".getBytes()), (BookkeeperInternalCallbacks.GenericCallback)new BookkeeperInternalCallbacks.GenericCallback<Void>(){

                            public void operationComplete(int rc, Void result) {
                                bbLedgerId.putLong(lid);
                                bbLedgerId.flip();
                                createLatch.countDown();
                            }
                        });
                    }
                });
                Assert.assertTrue((boolean)createLatch.await(2000L, TimeUnit.MILLISECONDS));
                final long createdLid = bbLedgerId.getLong();
                manager.registerLedgerMetadataListener(createdLid, new BookkeeperInternalCallbacks.LedgerMetadataListener(){

                    public void onChanged(long ledgerId, LedgerMetadata metadata) {
                        Assert.assertEquals((long)ledgerId, (long)createdLid);
                        Assert.assertEquals((Object)metadata, null);
                        removeLatch.countDown();
                    }
                });
                manager.removeLedgerMetadata(createdLid, Version.ANY, (BookkeeperInternalCallbacks.GenericCallback)new BookkeeperInternalCallbacks.GenericCallback<Void>(){

                    public void operationComplete(int rc, Void result) {
                        Assert.assertEquals((long)rc, (long)0L);
                    }
                });
                Assert.assertTrue((boolean)removeLatch.await(2000L, TimeUnit.MILLISECONDS));
            }
            finally {
                if (Collections.singletonList(idGenerator).get(0) != null) {
                    idGenerator.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(manager).get(0) != null) {
                manager.close();
            }
        }
    }
}

