/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateLedgerCmdTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateLedgerCmdTest.class);
    private BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    private static final String PASSWORD = "testPasswd";

    public UpdateLedgerCmdTest() {
        super(3);
        this.baseConf.setGcWaitTime(100000L);
    }

    @Test
    public void testUpdateLedgersToHostname() throws Exception {
        BookKeeper bk = new BookKeeper(this.baseClientConf, this.zkc);
        LOG.info("Create ledger and add entries to it");
        ArrayList<LedgerHandle> ledgers = new ArrayList<LedgerHandle>();
        LedgerHandle lh1 = this.createLedgerWithEntries(bk, 0);
        ledgers.add(lh1);
        for (int i = 1; i < 40; ++i) {
            ledgers.add(this.createLedgerWithEntries(bk, 0));
        }
        String[] argv = new String[]{"updateledgers", "-b", "hostname", "-v", "true", "-p", "2"};
        ServerConfiguration conf = (ServerConfiguration)this.bsConfs.get(0);
        conf.setUseHostNameAsBookieID(true);
        BookieSocketAddress toBookieId = Bookie.getBookieAddress((ServerConfiguration)conf);
        BookieSocketAddress toBookieAddr = new BookieSocketAddress(toBookieId.getHostName() + ":" + conf.getBookiePort());
        this.updateLedgerCmd(argv, 0, conf);
        int updatedLedgersCount = this.getUpdatedLedgersCount(bk, ledgers, toBookieAddr);
        Assert.assertEquals((String)"Failed to update the ledger metadata to use bookie host name", (long)40L, (long)updatedLedgersCount);
    }

    private void updateLedgerCmd(String[] argv, int exitCode, ServerConfiguration conf) throws KeeperException, InterruptedException, IOException, UnknownHostException, Exception {
        LOG.info("Perform updateledgers command");
        BookieShell bkShell = new BookieShell();
        bkShell.setConf((CompositeConfiguration)conf);
        Assert.assertEquals((String)"Failed to return exit code!", (long)exitCode, (long)bkShell.run(argv));
    }

    private int getUpdatedLedgersCount(BookKeeper bk, List<LedgerHandle> ledgers, BookieSocketAddress toBookieAddr) throws InterruptedException, BKException {
        int updatedLedgersCount = 0;
        for (LedgerHandle lh : ledgers) {
            lh.close();
            LedgerHandle openLedger = bk.openLedger(lh.getId(), this.digestType, PASSWORD.getBytes());
            ArrayList ensemble = openLedger.getLedgerMetadata().getEnsemble(0L);
            if (!ensemble.contains(toBookieAddr)) continue;
            ++updatedLedgersCount;
        }
        return updatedLedgersCount;
    }

    private LedgerHandle createLedgerWithEntries(BookKeeper bk, int numOfEntries) throws Exception {
        LedgerHandle lh = bk.createLedger(3, 3, this.digestType, PASSWORD.getBytes());
        final AtomicInteger rc = new AtomicInteger(0);
        final CountDownLatch latch = new CountDownLatch(numOfEntries);
        AsyncCallback.AddCallback cb = new AsyncCallback.AddCallback(){

            public void addComplete(int rccb, LedgerHandle lh, long entryId, Object ctx) {
                rc.compareAndSet(0, rccb);
                latch.countDown();
            }
        };
        for (int i = 0; i < numOfEntries; ++i) {
            lh.asyncAddEntry(("foobar" + i).getBytes(), cb, null);
        }
        if (!latch.await(30L, TimeUnit.SECONDS)) {
            throw new Exception("Entries took too long to add");
        }
        if (rc.get() != 0) {
            throw BKException.create((int)rc.get());
        }
        return lh;
    }
}

