/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.api;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.MockBookKeeperTestCase;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.WriteAdvHandle;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.junit.Assert;
import org.junit.Test;

public class BookKeeperBuildersTest
extends MockBookKeeperTestCase {
    private static final int ensembleSize = 3;
    private static final int writeQuorumSize = 2;
    private static final int ackQuorumSize = 1;
    private static final long ledgerId = 12342L;
    private static final Map<String, byte[]> customMetadata = new HashMap<String, byte[]>();
    private static final byte[] password = new byte[3];
    private static final byte[] entryData = new byte[32];
    private static final EnumSet<WriteFlag> writeFlagsDeferredSync = EnumSet.of(WriteFlag.DEFERRED_SYNC);

    @Test
    public void testCreateLedger() throws Exception {
        this.setNewGeneratedLedgerId(12342L);
        WriteHandle writer = (WriteHandle)this.newCreateLedgerOp().withAckQuorumSize(1).withEnsembleSize(3).withWriteQuorumSize(2).withCustomMetadata(customMetadata).withPassword(password).execute().get();
        Assert.assertEquals((long)12342L, (long)writer.getId());
        LedgerMetadata metadata = this.getLedgerMetadata(12342L);
        Assert.assertEquals((long)3L, (long)metadata.getEnsembleSize());
        Assert.assertEquals((long)1L, (long)metadata.getAckQuorumSize());
        Assert.assertEquals((long)2L, (long)metadata.getWriteQuorumSize());
        Assert.assertArrayEquals((byte[])password, (byte[])metadata.getPassword());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testFailEnsembleSize0() throws Exception {
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withEnsembleSize(0).withPassword(password).execute());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testFailWriteQuorumSize0() throws Exception {
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withEnsembleSize(2).withWriteQuorumSize(0).withPassword(password).execute());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testFailNullWriteFlags() throws Exception {
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withWriteFlags((EnumSet)null).withPassword(password).execute());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testFailAckQuorumSize0() throws Exception {
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withEnsembleSize(2).withWriteQuorumSize(1).withAckQuorumSize(0).withPassword(password).execute());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testFailWriteQuorumSizeGreaterThanEnsembleSize() throws Exception {
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withEnsembleSize(1).withWriteQuorumSize(2).withAckQuorumSize(1).withPassword(password).execute());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testFailAckQuorumSizeGreaterThanWriteQuorumSize() throws Exception {
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withEnsembleSize(1).withWriteQuorumSize(1).withAckQuorumSize(2).withPassword(password).execute());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testFailNoPassword() throws Exception {
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().execute());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testFailPasswordNull() throws Exception {
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withPassword(null).execute());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testFailCustomMetadataNull() throws Exception {
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withCustomMetadata(null).withPassword(password).execute());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testFailDigestTypeNullAndAutodetectionTrue() throws Exception {
        ClientConfiguration config = new ClientConfiguration();
        config.setEnableDigestTypeAutodetection(true);
        this.setBookkeeperConfig(config);
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withDigestType(null).withPassword(password).execute());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testFailDigestTypeNullAndAutodetectionFalse() throws Exception {
        ClientConfiguration config = new ClientConfiguration();
        config.setEnableDigestTypeAutodetection(false);
        this.setBookkeeperConfig(config);
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withDigestType(null).withPassword(password).execute());
        Assert.fail((String)"shoud not be able to create a ledger with such specs");
    }

    @Test(expected=BKException.BKClientClosedException.class)
    public void testFailDigestTypeNullAndBookkKeeperClosed() throws Exception {
        this.closeBookkeeper();
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withPassword(password).execute());
        Assert.fail((String)"shoud not be able to create a ledger, client is closed");
    }

    @Test
    public void testCreateAdvLedger() throws Exception {
        this.setNewGeneratedLedgerId(12342L);
        WriteAdvHandle writer = (WriteAdvHandle)this.newCreateLedgerOp().withAckQuorumSize(1).withEnsembleSize(3).withPassword(password).withWriteQuorumSize(2).withCustomMetadata(customMetadata).makeAdv().execute().get();
        Assert.assertEquals((long)12342L, (long)writer.getId());
        LedgerMetadata metadata = this.getLedgerMetadata(12342L);
        Assert.assertEquals((long)3L, (long)metadata.getEnsembleSize());
        Assert.assertEquals((long)1L, (long)metadata.getAckQuorumSize());
        Assert.assertEquals((long)2L, (long)metadata.getWriteQuorumSize());
        Assert.assertArrayEquals((byte[])password, (byte[])metadata.getPassword());
    }

    @Test
    public void testDefaultWriteFlagsEmpty() throws Exception {
        this.setNewGeneratedLedgerId(12342L);
        WriteHandle writer = (WriteHandle)this.newCreateLedgerOp().withAckQuorumSize(1).withEnsembleSize(3).withPassword(password).withWriteQuorumSize(2).withCustomMetadata(customMetadata).execute().get();
        Assert.assertEquals((long)12342L, (long)writer.getId());
        LedgerMetadata metadata = this.getLedgerMetadata(12342L);
        Assert.assertEquals((long)3L, (long)metadata.getEnsembleSize());
        Assert.assertEquals((long)1L, (long)metadata.getAckQuorumSize());
        Assert.assertEquals((long)2L, (long)metadata.getWriteQuorumSize());
        Assert.assertArrayEquals((byte[])password, (byte[])metadata.getPassword());
        LedgerHandle lh = (LedgerHandle)writer;
        Assert.assertEquals(EnumSet.noneOf(WriteFlag.class), (Object)lh.getWriteFlags());
    }

    @Test
    public void testCreateAdvLedgerWriteFlags() throws Exception {
        this.setNewGeneratedLedgerId(12342L);
        WriteAdvHandle writer = (WriteAdvHandle)this.newCreateLedgerOp().withWriteFlags(writeFlagsDeferredSync).withAckQuorumSize(1).withEnsembleSize(3).withPassword(password).withWriteQuorumSize(2).withCustomMetadata(customMetadata).makeAdv().execute().get();
        Assert.assertEquals((long)12342L, (long)writer.getId());
        LedgerMetadata metadata = this.getLedgerMetadata(12342L);
        Assert.assertEquals((long)3L, (long)metadata.getEnsembleSize());
        Assert.assertEquals((long)1L, (long)metadata.getAckQuorumSize());
        Assert.assertEquals((long)2L, (long)metadata.getWriteQuorumSize());
        Assert.assertArrayEquals((byte[])password, (byte[])metadata.getPassword());
        LedgerHandle lh = (LedgerHandle)writer;
        Assert.assertEquals(writeFlagsDeferredSync, (Object)lh.getWriteFlags());
    }

    @Test
    public void testCreateLedgerWriteFlags() throws Exception {
        this.setNewGeneratedLedgerId(12342L);
        WriteHandle writer = (WriteHandle)this.newCreateLedgerOp().withWriteFlags(writeFlagsDeferredSync).withAckQuorumSize(1).withEnsembleSize(3).withPassword(password).withWriteQuorumSize(2).withCustomMetadata(customMetadata).execute().get();
        Assert.assertEquals((long)12342L, (long)writer.getId());
        LedgerMetadata metadata = this.getLedgerMetadata(12342L);
        Assert.assertEquals((long)3L, (long)metadata.getEnsembleSize());
        Assert.assertEquals((long)1L, (long)metadata.getAckQuorumSize());
        Assert.assertEquals((long)2L, (long)metadata.getWriteQuorumSize());
        Assert.assertArrayEquals((byte[])password, (byte[])metadata.getPassword());
        LedgerHandle lh = (LedgerHandle)writer;
        Assert.assertEquals(writeFlagsDeferredSync, (Object)lh.getWriteFlags());
    }

    @Test
    public void testCreateLedgerWriteFlagsVarargs() throws Exception {
        this.setNewGeneratedLedgerId(12342L);
        WriteHandle writer = (WriteHandle)this.newCreateLedgerOp().withWriteFlags(new WriteFlag[]{WriteFlag.DEFERRED_SYNC}).withAckQuorumSize(1).withEnsembleSize(3).withPassword(password).withWriteQuorumSize(2).withCustomMetadata(customMetadata).execute().get();
        Assert.assertEquals((long)12342L, (long)writer.getId());
        LedgerMetadata metadata = this.getLedgerMetadata(12342L);
        Assert.assertEquals((long)3L, (long)metadata.getEnsembleSize());
        Assert.assertEquals((long)1L, (long)metadata.getAckQuorumSize());
        Assert.assertEquals((long)2L, (long)metadata.getWriteQuorumSize());
        Assert.assertArrayEquals((byte[])password, (byte[])metadata.getPassword());
        LedgerHandle lh = (LedgerHandle)writer;
        Assert.assertEquals(writeFlagsDeferredSync, (Object)lh.getWriteFlags());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testFailCreateAdvLedgerBadFixedLedgerIdMinus1() throws Exception {
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withPassword(password).makeAdv().withLedgerId(-1L).execute());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testFailCreateAdvLedgerBadFixedLedgerIdNegative() throws Exception {
        FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withPassword(password).makeAdv().withLedgerId(-2L).execute());
        Assert.fail((String)"shoud not be able to create a ledger with such specs");
    }

    @Test(expected=BKException.BKNoSuchLedgerExistsException.class)
    public void testOpenLedgerNoId() throws Exception {
        FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().execute());
    }

    @Test(expected=BKException.BKNoSuchLedgerExistsException.class)
    public void testOpenLedgerBadId() throws Exception {
        FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().withPassword(password).withLedgerId(12342L).execute());
    }

    @Test(expected=BKException.BKClientClosedException.class)
    public void testOpenLedgerClientClosed() throws Exception {
        this.closeBookkeeper();
        FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().withPassword(password).withLedgerId(12342L).execute());
    }

    @Test
    public void testOpenLedgerNoRecovery() throws Exception {
        LedgerMetadata ledgerMetadata = this.generateLedgerMetadata(3, 2, 1, password, customMetadata);
        this.registerMockLedgerMetadata(12342L, ledgerMetadata);
        ledgerMetadata.getEnsembles().values().forEach(bookieAddressList -> bookieAddressList.forEach(bookieAddress -> {
            this.registerMockEntryForRead(12342L, -1L, (BookieSocketAddress)bookieAddress, entryData, -1L);
            this.registerMockEntryForRead(12342L, 0L, (BookieSocketAddress)bookieAddress, entryData, -1L);
        }));
        FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().withPassword(ledgerMetadata.getPassword()).withDigestType(DigestType.CRC32).withLedgerId(12342L).withRecovery(false).execute());
    }

    @Test
    public void testOpenLedgerRecovery() throws Exception {
        LedgerMetadata ledgerMetadata = this.generateLedgerMetadata(3, 2, 1, password, customMetadata);
        this.registerMockLedgerMetadata(12342L, ledgerMetadata);
        ledgerMetadata.getEnsembles().values().forEach(bookieAddressList -> bookieAddressList.forEach(bookieAddress -> {
            this.registerMockEntryForRead(12342L, -1L, (BookieSocketAddress)bookieAddress, entryData, -1L);
            this.registerMockEntryForRead(12342L, 0L, (BookieSocketAddress)bookieAddress, entryData, -1L);
        }));
        FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().withPassword(ledgerMetadata.getPassword()).withDigestType(DigestType.CRC32).withLedgerId(12342L).withRecovery(true).execute());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testDeleteLedgerNoLedgerId() throws Exception {
        FutureUtils.result((CompletableFuture)this.newDeleteLedgerOp().execute());
    }

    @Test(expected=BKException.BKIncorrectParameterException.class)
    public void testDeleteLedgerBadLedgerId() throws Exception {
        FutureUtils.result((CompletableFuture)this.newDeleteLedgerOp().withLedgerId(-1L).execute());
    }

    @Test
    public void testDeleteLedger() throws Exception {
        LedgerMetadata ledgerMetadata = this.generateLedgerMetadata(3, 2, 1, password, customMetadata);
        this.registerMockLedgerMetadata(12342L, ledgerMetadata);
        FutureUtils.result((CompletableFuture)this.newDeleteLedgerOp().withLedgerId(12342L).execute());
    }

    @Test(expected=BKException.BKClientClosedException.class)
    public void testDeleteLedgerBookKeeperClosed() throws Exception {
        this.closeBookkeeper();
        FutureUtils.result((CompletableFuture)this.newDeleteLedgerOp().withLedgerId(12342L).execute());
    }

    protected LedgerMetadata generateLedgerMetadata(int ensembleSize, int writeQuorumSize, int ackQuorumSize, byte[] password, Map<String, byte[]> customMetadata) {
        LedgerMetadata ledgerMetadata = new LedgerMetadata(ensembleSize, writeQuorumSize, ackQuorumSize, BookKeeper.DigestType.CRC32, password, customMetadata, true);
        ledgerMetadata.addEnsemble(0L, this.generateNewEnsemble(ensembleSize));
        return ledgerMetadata;
    }
}

