/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.conf;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBKConfiguration {
    static final Logger LOG = LoggerFactory.getLogger(TestBKConfiguration.class);

    public static ServerConfiguration newServerConfiguration() {
        ServerConfiguration confReturn = new ServerConfiguration();
        confReturn.setJournalFlushWhenQueueEmpty(true);
        confReturn.setJournalFormatVersionToWrite(5);
        confReturn.setAllowEphemeralPorts(true);
        confReturn.setBookiePort(0);
        confReturn.setGcWaitTime(1000L);
        confReturn.setDiskUsageThreshold(0.999f);
        confReturn.setDiskUsageWarnThreshold(0.99f);
        TestBKConfiguration.setLoopbackInterfaceAndAllowLoopback(confReturn);
        return confReturn;
    }

    private static String getLoopbackInterfaceName() {
        try {
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface nif : Collections.list(nifs)) {
                if (!nif.isLoopback()) continue;
                return nif.getName();
            }
        }
        catch (SocketException se) {
            LOG.warn("Exception while figuring out loopback interface. Will use null.", (Throwable)se);
            return null;
        }
        LOG.warn("Unable to deduce loopback interface. Will use null");
        return null;
    }

    public static ServerConfiguration setLoopbackInterfaceAndAllowLoopback(ServerConfiguration serverConf) {
        serverConf.setListeningInterface(TestBKConfiguration.getLoopbackInterfaceName());
        serverConf.setAllowLoopback(true);
        return serverConf;
    }
}

