/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.conf;

import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestServerConfiguration {
    private final ServerConfiguration serverConf = new ServerConfiguration();

    @Before
    public void setup() throws Exception {
        this.serverConf.loadConf(this.getClass().getClassLoader().getResource("bk_server.conf"));
    }

    @Test
    public void testEphemeralPortsAllowed() throws ConfigurationException {
        ServerConfiguration conf = new ServerConfiguration();
        conf.setAllowEphemeralPorts(true);
        conf.setBookiePort(0);
        conf.validate();
        Assert.assertTrue((boolean)true);
    }

    @Test(expected=ConfigurationException.class)
    public void testEphemeralPortsDisallowed() throws ConfigurationException {
        ServerConfiguration conf = new ServerConfiguration();
        conf.setAllowEphemeralPorts(false);
        conf.setBookiePort(0);
        conf.validate();
    }

    @Test
    public void testSetExtraServerComponents() {
        ServerConfiguration conf = new ServerConfiguration();
        Assert.assertNull((Object)conf.getExtraServerComponents());
        Object[] components = new String[]{"test1", "test2", "test3"};
        conf.setExtraServerComponents((String[])components);
        Assert.assertArrayEquals((Object[])components, (Object[])conf.getExtraServerComponents());
    }

    @Test
    public void testGetExtraServerComponents() {
        Object[] components = new String[]{"test1", "test2", "test3"};
        Assert.assertArrayEquals((Object[])components, (Object[])this.serverConf.getExtraServerComponents());
    }
}

