/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.EntryLocation;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.GarbageCollector;
import org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.ScanAndCompareGarbageCollector;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.CleanupLedgerManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerManagerTestCase;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.versioning.Version;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcLedgersTest
extends LedgerManagerTestCase {
    static final Logger LOG = LoggerFactory.getLogger(GcLedgersTest.class);

    public GcLedgersTest(Class<? extends LedgerManagerFactory> lmFactoryCls) {
        super(lmFactoryCls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLedgers(int numLedgers, final Set<Long> createdLedgers) throws IOException {
        final AtomicInteger expected = new AtomicInteger(numLedgers);
        for (int i = 0; i < numLedgers; ++i) {
            this.getLedgerIdGenerator().generateLedgerId((BookkeeperInternalCallbacks.GenericCallback)new BookkeeperInternalCallbacks.GenericCallback<Long>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(int rc, final Long ledgerId) {
                    if (0 != rc) {
                        AtomicInteger atomicInteger = expected;
                        synchronized (atomicInteger) {
                            int num = expected.decrementAndGet();
                            if (num == 0) {
                                expected.notify();
                            }
                        }
                        return;
                    }
                    GcLedgersTest.this.getLedgerManager().createLedgerMetadata(ledgerId.longValue(), new LedgerMetadata(1, 1, 1, BookKeeper.DigestType.MAC, "".getBytes()), (BookkeeperInternalCallbacks.GenericCallback)new BookkeeperInternalCallbacks.GenericCallback<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void operationComplete(int rc, Void result) {
                            if (rc == 0) {
                                GcLedgersTest.this.activeLedgers.put((Object)ledgerId, (Object)true);
                                createdLedgers.add(ledgerId);
                            }
                            AtomicInteger atomicInteger = expected;
                            synchronized (atomicInteger) {
                                int num = expected.decrementAndGet();
                                if (num == 0) {
                                    expected.notify();
                                }
                            }
                        }
                    });
                }
            });
        }
        AtomicInteger atomicInteger = expected;
        synchronized (atomicInteger) {
            try {
                while (expected.get() > 0) {
                    expected.wait(100L);
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void removeLedger(long ledgerId) throws Exception {
        final AtomicInteger rc = new AtomicInteger(0);
        final CountDownLatch latch = new CountDownLatch(1);
        this.getLedgerManager().removeLedgerMetadata(ledgerId, Version.ANY, (BookkeeperInternalCallbacks.GenericCallback)new BookkeeperInternalCallbacks.GenericCallback<Void>(){

            public void operationComplete(int rc2, Void result) {
                rc.set(rc2);
                latch.countDown();
            }
        });
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Assert.assertEquals((String)("Remove should have succeeded for ledgerId: " + ledgerId), (long)0L, (long)rc.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGarbageCollectLedgers() throws Exception {
        int numLedgers = 100;
        int numRemovedLedgers = 10;
        final HashSet<Long> createdLedgers = new HashSet<Long>();
        final HashSet<Long> removedLedgers = new HashSet<Long>();
        this.createLedgers(numLedgers, createdLedgers);
        Random r = new Random(System.currentTimeMillis());
        ArrayList<Long> tmpList = new ArrayList<Long>();
        tmpList.addAll(createdLedgers);
        Collections.shuffle(tmpList, r);
        for (int i = 0; i < numRemovedLedgers; ++i) {
            long ledgerId = (Long)tmpList.get(i);
            HashSet<Long> hashSet = removedLedgers;
            synchronized (hashSet) {
                this.getLedgerManager().removeLedgerMetadata(ledgerId, Version.ANY, (BookkeeperInternalCallbacks.GenericCallback)new BookkeeperInternalCallbacks.GenericCallback<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void operationComplete(int rc, Void result) {
                        Set set = removedLedgers;
                        synchronized (set) {
                            removedLedgers.notify();
                        }
                    }
                });
                removedLedgers.wait();
            }
            removedLedgers.add(ledgerId);
            createdLedgers.remove(ledgerId);
        }
        final CountDownLatch inGcProgress = new CountDownLatch(1);
        final CountDownLatch createLatch = new CountDownLatch(1);
        final CountDownLatch endLatch = new CountDownLatch(2);
        MockLedgerStorage mockLedgerStorage = new MockLedgerStorage();
        TestStatsProvider stats = new TestStatsProvider();
        ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector(this.getLedgerManager(), (CompactableLedgerStorage)mockLedgerStorage, this.baseConf, (StatsLogger)stats.getStatsLogger("gc"));
        Thread gcThread = new Thread((GarbageCollector)garbageCollector, mockLedgerStorage, inGcProgress, createLatch, endLatch){
            final /* synthetic */ GarbageCollector val$garbageCollector;
            final /* synthetic */ CompactableLedgerStorage val$mockLedgerStorage;
            final /* synthetic */ CountDownLatch val$inGcProgress;
            final /* synthetic */ CountDownLatch val$createLatch;
            final /* synthetic */ CountDownLatch val$endLatch;
            {
                this.val$garbageCollector = garbageCollector;
                this.val$mockLedgerStorage = compactableLedgerStorage;
                this.val$inGcProgress = countDownLatch;
                this.val$createLatch = countDownLatch2;
                this.val$endLatch = countDownLatch3;
            }

            @Override
            public void run() {
                this.val$garbageCollector.gc(new GarbageCollector.GarbageCleaner(){
                    boolean paused = false;

                    public void clean(long ledgerId) {
                        try {
                            val$mockLedgerStorage.deleteLedger(ledgerId);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return;
                        }
                        if (!this.paused) {
                            val$inGcProgress.countDown();
                            try {
                                val$createLatch.await();
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                            }
                            this.paused = true;
                        }
                        LOG.info("Garbage Collected ledger {}", (Object)ledgerId);
                    }
                });
                LOG.info("Gc Thread quits.");
                this.val$endLatch.countDown();
            }
        };
        Thread createThread = new Thread(){

            @Override
            public void run() {
                try {
                    inGcProgress.await();
                    GcLedgersTest.this.createLedgers(10, createdLedgers);
                    LOG.info("Finished creating 10 more ledgers.");
                    createLatch.countDown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOG.info("Create Thread quits.");
                endLatch.countDown();
            }
        };
        createThread.start();
        gcThread.start();
        endLatch.await();
        for (Long ledger : removedLedgers) {
            Assert.assertFalse((boolean)this.activeLedgers.containsKey((Object)ledger));
        }
        for (Long ledger : createdLedgers) {
            Assert.assertTrue((boolean)this.activeLedgers.containsKey((Object)ledger));
        }
        Assert.assertTrue((String)"Wrong DELETED_LEDGER_COUNT", (stats.getCounter("gc.DELETED_LEDGER_COUNT").get() == (long)removedLedgers.size() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrong ACTIVE_LEDGER_COUNT", (stats.getGauge("gc.ACTIVE_LEDGER_COUNT").getSample().intValue() == createdLedgers.size() ? 1 : 0) != 0);
    }

    @Test
    public void testGcLedgersOutsideRange() throws Exception {
        SortedSet<Long> createdLedgers = Collections.synchronizedSortedSet(new TreeSet());
        final LinkedList cleaned = new LinkedList();
        int numLedgers = 100;
        this.createLedgers(numLedgers, createdLedgers);
        final MockLedgerStorage mockLedgerStorage = new MockLedgerStorage();
        TestStatsProvider stats = new TestStatsProvider();
        ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector(this.getLedgerManager(), (CompactableLedgerStorage)mockLedgerStorage, this.baseConf, (StatsLogger)stats.getStatsLogger("gc"));
        GarbageCollector.GarbageCleaner cleaner = new GarbageCollector.GarbageCleaner(){

            public void clean(long ledgerId) {
                LOG.info("Cleaned {}", (Object)ledgerId);
                cleaned.add(ledgerId);
                try {
                    mockLedgerStorage.deleteLedger(ledgerId);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Exception from deleteLedger");
                }
            }
        };
        garbageCollector.gc(cleaner);
        Assert.assertNull((String)"Should have cleaned nothing", cleaned.poll());
        Assert.assertTrue((String)"Wrong DELETED_LEDGER_COUNT", (stats.getCounter("gc.DELETED_LEDGER_COUNT").get() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrong ACTIVE_LEDGER_COUNT", (stats.getGauge("gc.ACTIVE_LEDGER_COUNT").getSample().intValue() == numLedgers ? 1 : 0) != 0);
        long last = createdLedgers.last();
        this.removeLedger(last);
        garbageCollector.gc(cleaner);
        Assert.assertNotNull((String)"Should have cleaned something", cleaned.peek());
        Assert.assertEquals((String)("Should have cleaned last ledger" + last), (long)last, (long)((Long)cleaned.poll()));
        Assert.assertTrue((String)"Wrong DELETED_LEDGER_COUNT", (stats.getCounter("gc.DELETED_LEDGER_COUNT").get() == 1L ? 1 : 0) != 0);
        long first = createdLedgers.first();
        this.removeLedger(first);
        garbageCollector.gc(cleaner);
        Assert.assertNotNull((String)"Should have cleaned something", cleaned.peek());
        Assert.assertEquals((String)("Should have cleaned first ledger" + first), (long)first, (long)((Long)cleaned.poll()));
        Assert.assertTrue((String)"Wrong DELETED_LEDGER_COUNT", (stats.getCounter("gc.DELETED_LEDGER_COUNT").get() == 2L ? 1 : 0) != 0);
        garbageCollector.gc(cleaner);
        Assert.assertTrue((String)"Wrong ACTIVE_LEDGER_COUNT", (stats.getGauge("gc.ACTIVE_LEDGER_COUNT").getSample().intValue() == numLedgers - 2 ? 1 : 0) != 0);
    }

    @Test
    public void testGcLedgersNotLast() throws Exception {
        SortedSet<Long> createdLedgers = Collections.synchronizedSortedSet(new TreeSet());
        final ArrayList cleaned = new ArrayList();
        int numLedgers = 30001;
        this.createLedgers(30001, createdLedgers);
        ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector(this.getLedgerManager(), (CompactableLedgerStorage)new MockLedgerStorage(), this.baseConf, (StatsLogger)NullStatsLogger.INSTANCE);
        GarbageCollector.GarbageCleaner cleaner = new GarbageCollector.GarbageCleaner(){

            public void clean(long ledgerId) {
                LOG.info("Cleaned {}", (Object)ledgerId);
                cleaned.add(ledgerId);
            }
        };
        TreeSet scannedLedgers = new TreeSet();
        LedgerManager.LedgerRangeIterator iterator = this.getLedgerManager().getLedgerRanges();
        while (iterator.hasNext()) {
            LedgerManager.LedgerRange ledgerRange = iterator.next();
            scannedLedgers.addAll(ledgerRange.getLedgers());
        }
        Assert.assertEquals(createdLedgers, scannedLedgers);
        garbageCollector.gc(cleaner);
        Assert.assertTrue((String)"Should have cleaned nothing", (boolean)cleaned.isEmpty());
        long first = createdLedgers.first();
        this.removeLedger(first);
        garbageCollector.gc(cleaner);
        Assert.assertEquals((String)"Should have cleaned something", (long)1L, (long)cleaned.size());
        Assert.assertEquals((String)("Should have cleaned first ledger" + first), (long)first, (long)((Long)cleaned.get(0)));
    }

    @Test
    public void testGcLedgersWithNoLedgers() throws Exception {
        SortedSet<Long> createdLedgers = Collections.synchronizedSortedSet(new TreeSet());
        ArrayList cleaned = new ArrayList();
        ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector(this.getLedgerManager(), (CompactableLedgerStorage)new MockLedgerStorage(), this.baseConf, (StatsLogger)NullStatsLogger.INSTANCE);
        final AtomicBoolean cleanerCalled = new AtomicBoolean(false);
        GarbageCollector.GarbageCleaner cleaner = new GarbageCollector.GarbageCleaner(){

            public void clean(long ledgerId) {
                LOG.info("Cleaned {}", (Object)ledgerId);
                cleanerCalled.set(true);
            }
        };
        this.validateLedgerRangeIterator(createdLedgers);
        garbageCollector.gc(cleaner);
        Assert.assertFalse((String)"Should have cleaned nothing, since no ledger is created", (boolean)cleanerCalled.get());
    }

    @Test
    public void testGcLedgersWithLedgersInSameLedgerRange() throws Exception {
        this.baseConf.setVerifyMetadataOnGc(true);
        SortedSet<Long> createdLedgers = Collections.synchronizedSortedSet(new TreeSet());
        final SortedSet cleaned = Collections.synchronizedSortedSet(new TreeSet());
        int numLedgers = 5;
        this.createLedgers(5, createdLedgers);
        ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector(this.getLedgerManager(), (CompactableLedgerStorage)new MockLedgerStorage(), this.baseConf, (StatsLogger)NullStatsLogger.INSTANCE);
        GarbageCollector.GarbageCleaner cleaner = new GarbageCollector.GarbageCleaner(){

            public void clean(long ledgerId) {
                LOG.info("Cleaned {}", (Object)ledgerId);
                cleaned.add(ledgerId);
            }
        };
        this.validateLedgerRangeIterator(createdLedgers);
        garbageCollector.gc(cleaner);
        Assert.assertTrue((String)"Should have cleaned nothing", (boolean)cleaned.isEmpty());
        Iterator iterator = createdLedgers.iterator();
        while (iterator.hasNext()) {
            long ledgerId = (Long)iterator.next();
            this.removeLedger(ledgerId);
        }
        garbageCollector.gc(cleaner);
        Assert.assertEquals((String)"Should have cleaned all the created ledgers", createdLedgers, cleaned);
    }

    @Test
    public void testGcLedgersIfLedgerManagerIteratorFails() throws Exception {
        this.baseConf.setVerifyMetadataOnGc(true);
        SortedSet<Long> createdLedgers = Collections.synchronizedSortedSet(new TreeSet());
        final SortedSet cleaned = Collections.synchronizedSortedSet(new TreeSet());
        int numLedgers = 5;
        this.createLedgers(5, createdLedgers);
        CleanupLedgerManager mockLedgerManager = new CleanupLedgerManager(this.getLedgerManager()){

            public LedgerManager.LedgerRangeIterator getLedgerRanges() {
                return new LedgerManager.LedgerRangeIterator(){

                    public LedgerManager.LedgerRange next() throws IOException {
                        return null;
                    }

                    public boolean hasNext() throws IOException {
                        return false;
                    }
                };
            }
        };
        ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector((LedgerManager)mockLedgerManager, (CompactableLedgerStorage)new MockLedgerStorage(), this.baseConf, (StatsLogger)NullStatsLogger.INSTANCE);
        GarbageCollector.GarbageCleaner cleaner = new GarbageCollector.GarbageCleaner(){

            public void clean(long ledgerId) {
                LOG.info("Cleaned {}", (Object)ledgerId);
                cleaned.add(ledgerId);
            }
        };
        this.validateLedgerRangeIterator(createdLedgers);
        garbageCollector.gc(cleaner);
        Assert.assertTrue((String)"Should have cleaned nothing", (boolean)cleaned.isEmpty());
    }

    @Test
    public void testGcLedgersIfReadLedgerMetadataSaysNoSuchLedger() throws Exception {
        SortedSet<Long> createdLedgers = Collections.synchronizedSortedSet(new TreeSet());
        final SortedSet cleaned = Collections.synchronizedSortedSet(new TreeSet());
        int numLedgers = 5;
        this.createLedgers(5, createdLedgers);
        CleanupLedgerManager mockLedgerManager = new CleanupLedgerManager(this.getLedgerManager()){

            public void readLedgerMetadata(long ledgerId, BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> readCb) {
                readCb.operationComplete(-7, null);
            }
        };
        ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector((LedgerManager)mockLedgerManager, (CompactableLedgerStorage)new MockLedgerStorage(), this.baseConf, (StatsLogger)NullStatsLogger.INSTANCE);
        GarbageCollector.GarbageCleaner cleaner = new GarbageCollector.GarbageCleaner(){

            public void clean(long ledgerId) {
                LOG.info("Cleaned {}", (Object)ledgerId);
                cleaned.add(ledgerId);
            }
        };
        this.validateLedgerRangeIterator(createdLedgers);
        garbageCollector.gc(cleaner);
        Assert.assertTrue((String)"Should have cleaned nothing", (boolean)cleaned.isEmpty());
    }

    @Test
    public void testGcLedgersIfReadLedgerMetadataFailsForDeletedLedgers() throws Exception {
        this.baseConf.setVerifyMetadataOnGc(true);
        SortedSet<Long> createdLedgers = Collections.synchronizedSortedSet(new TreeSet());
        final SortedSet cleaned = Collections.synchronizedSortedSet(new TreeSet());
        int numLedgers = 5;
        this.createLedgers(5, createdLedgers);
        CleanupLedgerManager mockLedgerManager = new CleanupLedgerManager(this.getLedgerManager()){

            public void readLedgerMetadata(long ledgerId, BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> readCb) {
                readCb.operationComplete(-9, null);
            }
        };
        ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector((LedgerManager)mockLedgerManager, (CompactableLedgerStorage)new MockLedgerStorage(), this.baseConf, (StatsLogger)NullStatsLogger.INSTANCE);
        GarbageCollector.GarbageCleaner cleaner = new GarbageCollector.GarbageCleaner(){

            public void clean(long ledgerId) {
                LOG.info("Cleaned {}", (Object)ledgerId);
                cleaned.add(ledgerId);
            }
        };
        this.validateLedgerRangeIterator(createdLedgers);
        Iterator iterator = createdLedgers.iterator();
        while (iterator.hasNext()) {
            long ledgerId = (Long)iterator.next();
            this.removeLedger(ledgerId);
        }
        garbageCollector.gc(cleaner);
        Assert.assertTrue((String)"Should have cleaned nothing", (boolean)cleaned.isEmpty());
    }

    public void validateLedgerRangeIterator(SortedSet<Long> createdLedgers) throws IOException {
        TreeSet scannedLedgers = new TreeSet();
        LedgerManager.LedgerRangeIterator iterator = this.getLedgerManager().getLedgerRanges();
        while (iterator.hasNext()) {
            LedgerManager.LedgerRange ledgerRange = iterator.next();
            scannedLedgers.addAll(ledgerRange.getLedgers());
        }
        Assert.assertEquals(createdLedgers, scannedLedgers);
    }

    class MockLedgerStorage
    implements CompactableLedgerStorage {
        MockLedgerStorage() {
        }

        public void initialize(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StateManager stateManager, CheckpointSource checkpointSource, Checkpointer checkpointer, StatsLogger statsLogger) throws IOException {
        }

        public void start() {
        }

        public void shutdown() throws InterruptedException {
        }

        public long getLastAddConfirmed(long ledgerId) throws IOException {
            return 0L;
        }

        public void setExplicitlac(long ledgerId, ByteBuf lac) throws IOException {
        }

        public ByteBuf getExplicitLac(long ledgerId) {
            return null;
        }

        public boolean ledgerExists(long ledgerId) throws IOException {
            return false;
        }

        public boolean setFenced(long ledgerId) throws IOException {
            return false;
        }

        public boolean isFenced(long ledgerId) throws IOException {
            return false;
        }

        public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        }

        public byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
            return null;
        }

        public long addEntry(ByteBuf entry) throws IOException {
            return 0L;
        }

        public ByteBuf getEntry(long ledgerId, long entryId) throws IOException {
            return null;
        }

        public void flush() throws IOException {
        }

        public void checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
        }

        public void deleteLedger(long ledgerId) throws IOException {
            GcLedgersTest.this.activeLedgers.remove((Object)ledgerId);
        }

        public Iterable<Long> getActiveLedgersInRange(long firstLedgerId, long lastLedgerId) {
            NavigableMap bkActiveLedgersSnapshot = GcLedgersTest.this.activeLedgers.snapshot();
            NavigableMap subBkActiveLedgers = bkActiveLedgersSnapshot.subMap(firstLedgerId, true, lastLedgerId, false);
            return subBkActiveLedgers.keySet();
        }

        public EntryLogger getEntryLogger() {
            return null;
        }

        public void updateEntriesLocations(Iterable<EntryLocation> locations) throws IOException {
        }

        public void registerLedgerDeletionListener(LedgerStorage.LedgerDeletionListener listener) {
        }

        public void flushEntriesLocationsIndex() throws IOException {
        }

        public boolean waitForLastAddConfirmedUpdate(long ledgerId, long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
            return false;
        }
    }
}

