/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.EntryLocation;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.FlatLedgerManagerFactory;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LongHierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.MSLedgerManagerFactory;
import org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.SnapshotMap;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class LedgerManagerTestCase
extends BookKeeperClusterTestCase {
    protected MetadataClientDriver clientDriver;
    protected Class<? extends LedgerManagerFactory> lmFactoryClass;
    protected LedgerManagerFactory ledgerManagerFactory;
    protected LedgerManager ledgerManager = null;
    protected LedgerIdGenerator ledgerIdGenerator = null;
    protected SnapshotMap<Long, Boolean> activeLedgers = new SnapshotMap();
    protected OrderedScheduler scheduler;

    public LedgerManagerTestCase(Class<? extends LedgerManagerFactory> lmFactoryCls) {
        this(lmFactoryCls, 0);
    }

    public LedgerManagerTestCase(Class<? extends LedgerManagerFactory> lmFactoryCls, int numBookies) {
        super(numBookies);
        this.lmFactoryClass = lmFactoryCls;
        this.baseConf.setLedgerManagerFactoryClass(lmFactoryCls);
        this.baseClientConf.setLedgerManagerFactoryClass(lmFactoryCls);
    }

    @Override
    protected String getMetadataServiceUri(String ledgersRootPath) {
        String ledgerManagerType = this.lmFactoryClass == FlatLedgerManagerFactory.class ? "flat" : (this.lmFactoryClass == LongHierarchicalLedgerManagerFactory.class ? "longhierarchical" : (this.lmFactoryClass == MSLedgerManagerFactory.class ? "ms" : "hierarchical"));
        return this.zkUtil.getMetadataServiceUri(ledgersRootPath, ledgerManagerType);
    }

    public LedgerManager getIndependentLedgerManager() {
        return this.ledgerManagerFactory.newLedgerManager();
    }

    public LedgerManager getLedgerManager() {
        if (null == this.ledgerManager) {
            this.ledgerManager = this.ledgerManagerFactory.newLedgerManager();
        }
        return this.ledgerManager;
    }

    public LedgerIdGenerator getLedgerIdGenerator() throws IOException {
        if (null == this.ledgerIdGenerator) {
            this.ledgerIdGenerator = this.ledgerManagerFactory.newLedgerIdGenerator();
        }
        return this.ledgerIdGenerator;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        return Arrays.asList({FlatLedgerManagerFactory.class}, {HierarchicalLedgerManagerFactory.class}, {LongHierarchicalLedgerManagerFactory.class}, {MSLedgerManagerFactory.class});
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-scheduler").numThreads(1).build();
        this.clientDriver = MetadataDrivers.getClientDriver((URI)URI.create(this.baseClientConf.getMetadataServiceUri()));
        this.clientDriver.initialize(this.baseClientConf, (ScheduledExecutorService)this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, Optional.empty());
        this.ledgerManagerFactory = this.clientDriver.getLedgerManagerFactory();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (null != this.ledgerManager) {
            this.ledgerManager.close();
        }
        if (null != this.clientDriver) {
            this.clientDriver.close();
        }
        if (null != this.scheduler) {
            this.scheduler.shutdown();
        }
        super.tearDown();
    }

    public class MockLedgerStorage
    implements CompactableLedgerStorage {
        public void initialize(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StateManager stateManager, CheckpointSource checkpointSource, Checkpointer checkpointer, StatsLogger statsLogger) throws IOException {
        }

        public void start() {
        }

        public void shutdown() throws InterruptedException {
        }

        public boolean ledgerExists(long ledgerId) throws IOException {
            return false;
        }

        public boolean setFenced(long ledgerId) throws IOException {
            return false;
        }

        public boolean isFenced(long ledgerId) throws IOException {
            return false;
        }

        public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        }

        public byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
            return null;
        }

        public long addEntry(ByteBuf entry) throws IOException {
            return 0L;
        }

        public ByteBuf getEntry(long ledgerId, long entryId) throws IOException {
            return null;
        }

        public long getLastAddConfirmed(long ledgerId) throws IOException {
            return 0L;
        }

        public void flush() throws IOException {
        }

        public void checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
        }

        public void registerLedgerDeletionListener(LedgerStorage.LedgerDeletionListener listener) {
        }

        public void deleteLedger(long ledgerId) throws IOException {
            LedgerManagerTestCase.this.activeLedgers.remove((Object)ledgerId);
        }

        public Iterable<Long> getActiveLedgersInRange(long firstLedgerId, long lastLedgerId) {
            NavigableMap bkActiveLedgersSnapshot = LedgerManagerTestCase.this.activeLedgers.snapshot();
            NavigableMap subBkActiveLedgers = bkActiveLedgersSnapshot.subMap(firstLedgerId, true, lastLedgerId, false);
            return subBkActiveLedgers.keySet();
        }

        public EntryLogger getEntryLogger() {
            return null;
        }

        public void updateEntriesLocations(Iterable<EntryLocation> locations) throws IOException {
        }

        public void flushEntriesLocationsIndex() throws IOException {
        }

        public boolean waitForLastAddConfirmedUpdate(long ledgerId, long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
            return false;
        }

        public void setExplicitlac(long ledgerId, ByteBuf lac) throws IOException {
        }

        public ByteBuf getExplicitLac(long ledgerId) {
            return null;
        }
    }
}

