/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.AbstractZkLedgerManagerFactory;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerLayout;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LongHierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.ZkLayoutManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLedgerManager
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestLedgerManager.class);

    public TestLedgerManager() {
        super(0);
    }

    private void writeLedgerLayout(String ledgersRootPath, String managerType, int managerVersion, int layoutVersion) throws Exception {
        LedgerLayout layout = new LedgerLayout(managerType, managerVersion);
        Field f = LedgerLayout.class.getDeclaredField("layoutFormatVersion");
        f.setAccessible(true);
        f.set(layout, layoutVersion);
        ZkLayoutManager zkLayoutManager = new ZkLayoutManager(this.zkc, ledgersRootPath, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        zkLayoutManager.storeLedgerLayout(layout);
    }

    @Test
    public void testBadConf() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        String root0 = "/goodconf0";
        this.zkc.create(root0, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        conf.setZkServers(this.zkUtil.getZooKeeperConnectString());
        conf.setZkLedgersRootPath(root0);
        ZkLayoutManager zkLayoutManager = new ZkLayoutManager(this.zkc, ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)conf), ZkUtils.getACLs((AbstractConfiguration)conf));
        LedgerManagerFactory m = AbstractZkLedgerManagerFactory.newLedgerManagerFactory((AbstractConfiguration)conf, (LayoutManager)zkLayoutManager);
        Assert.assertTrue((String)"Ledger manager is unexpected type", (boolean)(m instanceof HierarchicalLedgerManagerFactory));
        m.close();
        conf.setLedgerManagerFactoryClass(LongHierarchicalLedgerManagerFactory.class);
        try {
            AbstractZkLedgerManagerFactory.newLedgerManagerFactory((AbstractConfiguration)conf, (LayoutManager)zkLayoutManager);
            Assert.fail((String)"Shouldn't reach here");
        }
        catch (Exception e) {
            LOG.error("Received exception", (Throwable)e);
            Assert.assertTrue((String)"Invalid exception", (boolean)e.getMessage().contains("does not match existing layout"));
        }
        String root1 = "/badconf1";
        this.zkc.create(root1, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        conf.setZkLedgersRootPath(root1);
        conf.setLedgerManagerFactoryClassName("DoesNotExist");
        try {
            AbstractZkLedgerManagerFactory.newLedgerManagerFactory((AbstractConfiguration)conf, (LayoutManager)zkLayoutManager);
            Assert.fail((String)"Shouldn't reach here");
        }
        catch (Exception e) {
            LOG.error("Received exception", (Throwable)e);
            Assert.assertTrue((String)"Invalid exception", (boolean)e.getMessage().contains("Failed to retrieve metadata service uri from configuration"));
        }
    }

    @Test
    public void testBadConfV1() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        String root0 = "/goodconf0";
        this.zkc.create(root0, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        conf.setMetadataServiceUri(this.newMetadataServiceUri(root0));
        this.writeLedgerLayout(root0, "hierarchical", 1, 1);
        conf.setLedgerManagerFactoryClass(HierarchicalLedgerManagerFactory.class);
        ZkLayoutManager zkLayoutManager = new ZkLayoutManager(this.zkc, ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)conf), ZkUtils.getACLs((AbstractConfiguration)conf));
        LedgerManagerFactory m = AbstractZkLedgerManagerFactory.newLedgerManagerFactory((AbstractConfiguration)conf, (LayoutManager)zkLayoutManager);
        Assert.assertTrue((String)"Ledger manager is unexpected type", (boolean)(m instanceof HierarchicalLedgerManagerFactory));
        m.close();
        conf.setLedgerManagerFactoryClass(HierarchicalLedgerManagerFactory.class);
        m = AbstractZkLedgerManagerFactory.newLedgerManagerFactory((AbstractConfiguration)conf, (LayoutManager)zkLayoutManager);
        Assert.assertTrue((String)"Ledger manager is unexpected type", (boolean)(m instanceof HierarchicalLedgerManagerFactory));
        m.close();
        conf.setLedgerManagerType("longhierarchical");
        try {
            AbstractZkLedgerManagerFactory.newLedgerManagerFactory((AbstractConfiguration)conf, (LayoutManager)zkLayoutManager);
            Assert.fail((String)"Shouldn't reach here");
        }
        catch (Exception e) {
            LOG.error("Received exception", (Throwable)e);
            Assert.assertTrue((String)"Invalid exception", (boolean)e.getMessage().contains("does not match existing layout"));
        }
    }

    @Test
    public void testBadZkContents() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        String root0 = "/badzk0";
        this.zkc.create(root0, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        conf.setMetadataServiceUri(this.newMetadataServiceUri(root0));
        LedgerLayout layout = new LedgerLayout("DoesNotExist", -559038737);
        ZkLayoutManager zkLayoutManager = new ZkLayoutManager(this.zkc, root0, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        zkLayoutManager.storeLedgerLayout(layout);
        try {
            AbstractZkLedgerManagerFactory.newLedgerManagerFactory((AbstractConfiguration)conf, (LayoutManager)zkLayoutManager);
            Assert.fail((String)"Shouldn't reach here");
        }
        catch (Exception e) {
            LOG.error("Received exception", (Throwable)e);
            Assert.assertTrue((String)"Invalid exception", (boolean)e.getMessage().contains("Configured layout org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory does not match existing layout DoesNotExist"));
        }
        String root1 = "/badzk1";
        this.zkc.create(root1, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        conf.setMetadataServiceUri(this.newMetadataServiceUri(root1));
        LedgerLayout layout1 = new LedgerLayout(HierarchicalLedgerManagerFactory.class.getName(), -559038737);
        ZkLayoutManager zkLayoutManager1 = new ZkLayoutManager(this.zkc, root1, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        zkLayoutManager1.storeLedgerLayout(layout1);
        try {
            AbstractZkLedgerManagerFactory.newLedgerManagerFactory((AbstractConfiguration)conf, (LayoutManager)zkLayoutManager1);
            Assert.fail((String)"Shouldn't reach here");
        }
        catch (Exception e) {
            LOG.error("Received exception", (Throwable)e);
            Assert.assertTrue((String)"Invalid exception", (boolean)e.getMessage().contains("Incompatible layout version found"));
        }
    }

    @Test
    public void testConcurrent1() throws Exception {
        int numThreads = 50;
        String root0 = "/lmroot0";
        this.zkc.create(root0, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CyclicBarrier barrier = new CyclicBarrier(numThreads + 1);
        ArrayList<CreateLMThread> threads = new ArrayList<CreateLMThread>(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            CreateLMThread t = new CreateLMThread(this.zkUtil.getZooKeeperConnectString(), root0, HierarchicalLedgerManagerFactory.class.getName(), barrier);
            t.start();
            threads.add(t);
        }
        barrier.await();
        boolean success = true;
        for (CreateLMThread t : threads) {
            t.join();
            t.close();
            success = t.isSuccessful() && success;
        }
        Assert.assertTrue((String)"Not all ledger managers created", (boolean)success);
    }

    @Test
    public void testConcurrent2() throws Exception {
        int numThreadsEach = 25;
        String root0 = "/lmroot0";
        this.zkc.create(root0, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CyclicBarrier barrier = new CyclicBarrier(numThreadsEach * 2 + 1);
        ArrayList<CreateLMThread> threadsA = new ArrayList<CreateLMThread>(numThreadsEach);
        for (int i = 0; i < numThreadsEach; ++i) {
            CreateLMThread t = new CreateLMThread(this.zkUtil.getZooKeeperConnectString(), root0, HierarchicalLedgerManagerFactory.class.getName(), barrier);
            t.start();
            threadsA.add(t);
        }
        ArrayList<CreateLMThread> threadsB = new ArrayList<CreateLMThread>(numThreadsEach);
        for (int i = 0; i < numThreadsEach; ++i) {
            CreateLMThread t = new CreateLMThread(this.zkUtil.getZooKeeperConnectString(), root0, LongHierarchicalLedgerManagerFactory.class.getName(), barrier);
            t.start();
            threadsB.add(t);
        }
        barrier.await();
        int numSuccess = 0;
        int numFails = 0;
        for (CreateLMThread t : threadsA) {
            t.join();
            t.close();
            if (t.isSuccessful()) {
                ++numSuccess;
                continue;
            }
            ++numFails;
        }
        for (CreateLMThread t : threadsB) {
            t.join();
            t.close();
            if (t.isSuccessful()) {
                ++numSuccess;
                continue;
            }
            ++numFails;
        }
        Assert.assertEquals((String)"Incorrect number of successes", (long)numThreadsEach, (long)numSuccess);
        Assert.assertEquals((String)"Incorrect number of failures", (long)numThreadsEach, (long)numFails);
    }

    private static class CreateLMThread
    extends Thread {
        private boolean success = false;
        private final String factoryCls;
        private final CyclicBarrier barrier;
        private ZooKeeper zkc;
        private ClientConfiguration conf;

        CreateLMThread(String zkConnectString, String root, String factoryCls, CyclicBarrier barrier) throws Exception {
            this.factoryCls = factoryCls;
            this.barrier = barrier;
            this.zkc = ZooKeeperClient.newBuilder().connectString(zkConnectString).build();
            this.conf = new ClientConfiguration();
            this.conf.setZkServers(zkConnectString);
            this.conf.setZkLedgersRootPath(root);
        }

        @Override
        public void run() {
            this.conf.setLedgerManagerFactoryClassName(this.factoryCls);
            try {
                this.barrier.await();
                MetadataDrivers.runFunctionWithLedgerManagerFactory((ServerConfiguration)new ServerConfiguration((AbstractConfiguration)this.conf), factory -> null);
                this.success = true;
            }
            catch (Exception e) {
                LOG.error("Failed to create ledger manager", (Throwable)e);
            }
        }

        public boolean isSuccessful() {
            return this.success;
        }

        public void close() throws Exception {
            this.zkc.close();
        }
    }
}

