/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.bookkeeper.meta.LongZkLedgerIdGenerator;
import org.apache.bookkeeper.meta.TestZkLedgerIdGenerator;
import org.apache.bookkeeper.meta.ZkLedgerIdGenerator;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.test.ZooKeeperUtil;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLongZkLedgerIdGenerator
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestZkLedgerIdGenerator.class);
    ZooKeeperUtil zkutil;
    ZooKeeper zk;
    LongZkLedgerIdGenerator ledgerIdGenerator;

    @Before
    public void setUp() throws Exception {
        LOG.info("Setting up test");
        super.setUp();
        this.zkutil = new ZooKeeperUtil();
        this.zkutil.startServer();
        this.zk = this.zkutil.getZooKeeperClient();
        ZkLedgerIdGenerator shortLedgerIdGenerator = new ZkLedgerIdGenerator(this.zk, "/test-zk-ledger-id-generator", "idgen", (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        this.ledgerIdGenerator = new LongZkLedgerIdGenerator(this.zk, "/test-zk-ledger-id-generator", "idgen-long", shortLedgerIdGenerator, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("Tearing down test");
        this.ledgerIdGenerator.close();
        this.zk.close();
        this.zkutil.killServer();
        super.tearDown();
    }

    @Test
    public void testGenerateLedgerId() throws Exception {
        int i;
        int nThread = 2;
        int nLedgers = 2000;
        final CountDownLatch countDownLatch = new CountDownLatch(8000);
        final AtomicInteger errCount = new AtomicInteger(0);
        final ConcurrentLinkedQueue ledgerIds = new ConcurrentLinkedQueue();
        BookkeeperInternalCallbacks.GenericCallback<Long> cb = new BookkeeperInternalCallbacks.GenericCallback<Long>(){

            public void operationComplete(int rc, Long result) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    ledgerIds.add(result);
                } else {
                    errCount.incrementAndGet();
                }
                countDownLatch.countDown();
            }
        };
        long start = System.currentTimeMillis();
        for (i = 0; i < 2; ++i) {
            new Thread((BookkeeperInternalCallbacks.GenericCallback)cb){
                final /* synthetic */ BookkeeperInternalCallbacks.GenericCallback val$cb;
                {
                    this.val$cb = genericCallback;
                }

                @Override
                public void run() {
                    for (int j = 0; j < 2000; ++j) {
                        TestLongZkLedgerIdGenerator.this.ledgerIdGenerator.generateLedgerId(this.val$cb);
                    }
                }
            }.start();
        }
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.zk, (String)"/test-zk-ledger-id-generator/idgen-long", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        this.ledgerIdGenerator.invalidateLedgerIdGenPathStatus();
        for (i = 0; i < 2; ++i) {
            new Thread((BookkeeperInternalCallbacks.GenericCallback)cb){
                final /* synthetic */ BookkeeperInternalCallbacks.GenericCallback val$cb;
                {
                    this.val$cb = genericCallback;
                }

                @Override
                public void run() {
                    for (int j = 0; j < 2000; ++j) {
                        TestLongZkLedgerIdGenerator.this.ledgerIdGenerator.generateLedgerId(this.val$cb);
                    }
                }
            }.start();
        }
        TestLongZkLedgerIdGenerator.assertTrue((String)"Wait ledger id generation threads to stop timeout : ", (boolean)countDownLatch.await(120L, TimeUnit.SECONDS));
        LOG.info("Number of generated ledger id: {}, time used: {}", (Object)ledgerIds.size(), (Object)(System.currentTimeMillis() - start));
        TestLongZkLedgerIdGenerator.assertEquals((String)"Error occur during ledger id generation : ", (int)0, (int)errCount.get());
        HashSet<Long> ledgers = new HashSet<Long>();
        while (!ledgerIds.isEmpty()) {
            Long ledger = (Long)ledgerIds.poll();
            TestLongZkLedgerIdGenerator.assertNotNull((String)"Generated ledger id is null : ", (Object)ledger);
            TestLongZkLedgerIdGenerator.assertFalse((String)("Ledger id [" + ledger + "] conflict : "), (boolean)ledgers.contains(ledger));
            ledgers.add(ledger);
        }
    }
}

