/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.protobuf.ByteString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.WriteEntryProcessorV3;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

public class WriteEntryProcessorV3Test {
    private BookkeeperProtocol.Request request;
    private WriteEntryProcessorV3 processor;
    private Channel channel;
    private BookieRequestProcessor requestProcessor;
    private Bookie bookie;

    @Before
    public void setup() {
        this.request = BookkeeperProtocol.Request.newBuilder().setHeader(BookkeeperProtocol.BKPacketHeader.newBuilder().setTxnId(System.currentTimeMillis()).setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.ADD_ENTRY).build()).setAddRequest(BookkeeperProtocol.AddRequest.newBuilder().setLedgerId(System.currentTimeMillis()).setEntryId(System.currentTimeMillis() + 1L).setBody(ByteString.copyFromUtf8((String)"test-entry-data")).setMasterKey(ByteString.copyFrom((byte[])new byte[0])).build()).build();
        this.channel = (Channel)Mockito.mock(Channel.class);
        this.bookie = (Bookie)Mockito.mock(Bookie.class);
        this.requestProcessor = (BookieRequestProcessor)Mockito.mock(BookieRequestProcessor.class);
        Mockito.when((Object)this.requestProcessor.getBookie()).thenReturn((Object)this.bookie);
        Mockito.when((Object)this.requestProcessor.getAddEntryStats()).thenReturn((Object)NullStatsLogger.INSTANCE.getOpStatsLogger("add_entry"));
        Mockito.when((Object)this.requestProcessor.getAddRequestStats()).thenReturn((Object)NullStatsLogger.INSTANCE.getOpStatsLogger("add_requests"));
        this.processor = new WriteEntryProcessorV3(this.request, this.channel, this.requestProcessor);
    }

    private void reinitRequest(int priority) {
        this.request = BookkeeperProtocol.Request.newBuilder((BookkeeperProtocol.Request)this.request).setHeader(BookkeeperProtocol.BKPacketHeader.newBuilder((BookkeeperProtocol.BKPacketHeader)this.request.getHeader()).setPriority(priority).build()).build();
        this.processor = new WriteEntryProcessorV3(this.request, this.channel, this.requestProcessor);
    }

    @Test
    public void testNoneHighPriorityWritesOnReadOnlyBookie() throws Exception {
        Mockito.when((Object)this.bookie.isReadOnly()).thenReturn((Object)true);
        Mockito.when((Object)this.channel.voidPromise()).thenReturn(Mockito.mock(ChannelPromise.class));
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(arg_0 -> WriteEntryProcessorV3Test.lambda$testNoneHighPriorityWritesOnReadOnlyBookie$0(writtenObject, latch, (ChannelPromise)promise, arg_0)).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any());
        this.processor.run();
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(BookkeeperProtocol.Response.class));
        latch.await();
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookkeeperProtocol.Response));
        BookkeeperProtocol.Response response = (BookkeeperProtocol.Response)writtenObject.get();
        Assert.assertEquals((Object)BookkeeperProtocol.StatusCode.EREADONLY, (Object)response.getStatus());
    }

    @Test
    public void testHighPriorityWritesOnReadOnlyBookieWhenHighPriorityWritesDisallowed() throws Exception {
        this.reinitRequest(100);
        Mockito.when((Object)this.bookie.isReadOnly()).thenReturn((Object)true);
        Mockito.when((Object)this.bookie.isAvailableForHighPriorityWrites()).thenReturn((Object)false);
        Mockito.when((Object)this.channel.voidPromise()).thenReturn(Mockito.mock(ChannelPromise.class));
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(arg_0 -> WriteEntryProcessorV3Test.lambda$testHighPriorityWritesOnReadOnlyBookieWhenHighPriorityWritesDisallowed$1(writtenObject, latch, (ChannelPromise)promise, arg_0)).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any());
        this.processor.run();
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(BookkeeperProtocol.Response.class));
        latch.await();
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookkeeperProtocol.Response));
        BookkeeperProtocol.Response response = (BookkeeperProtocol.Response)writtenObject.get();
        Assert.assertEquals((Object)BookkeeperProtocol.StatusCode.EREADONLY, (Object)response.getStatus());
    }

    @Test
    public void testHighPriorityWritesOnReadOnlyBookieWhenHighPriorityWritesAllowed() throws Exception {
        this.reinitRequest(4);
        Mockito.when((Object)this.bookie.isReadOnly()).thenReturn((Object)true);
        Mockito.when((Object)this.bookie.isAvailableForHighPriorityWrites()).thenReturn((Object)true);
        Mockito.when((Object)this.channel.voidPromise()).thenReturn(Mockito.mock(ChannelPromise.class));
        ((Bookie)Mockito.doAnswer(invocationOnMock -> {
            BookkeeperInternalCallbacks.WriteCallback wc = (BookkeeperInternalCallbacks.WriteCallback)invocationOnMock.getArgument(2);
            wc.writeComplete(0, this.request.getAddRequest().getLedgerId(), this.request.getAddRequest().getEntryId(), null, null);
            return null;
        }).when((Object)this.bookie)).addEntry((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.eq((boolean)false), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.WriteCallback.class), ArgumentMatchers.same((Object)this.channel), (byte[])ArgumentMatchers.eq((Object)new byte[0]));
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(arg_0 -> WriteEntryProcessorV3Test.lambda$testHighPriorityWritesOnReadOnlyBookieWhenHighPriorityWritesAllowed$3(writtenObject, latch, (ChannelPromise)promise, arg_0)).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any());
        this.processor.run();
        ((Bookie)Mockito.verify((Object)this.bookie, (VerificationMode)Mockito.times((int)1))).addEntry((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.eq((boolean)false), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.WriteCallback.class), ArgumentMatchers.same((Object)this.channel), (byte[])ArgumentMatchers.eq((Object)new byte[0]));
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(BookkeeperProtocol.Response.class));
        latch.await();
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookkeeperProtocol.Response));
        BookkeeperProtocol.Response response = (BookkeeperProtocol.Response)writtenObject.get();
        Assert.assertEquals((Object)BookkeeperProtocol.StatusCode.EOK, (Object)response.getStatus());
    }

    @Test
    public void testNormalWritesOnWritableBookie() throws Exception {
        Mockito.when((Object)this.bookie.isReadOnly()).thenReturn((Object)false);
        Mockito.when((Object)this.channel.voidPromise()).thenReturn(Mockito.mock(ChannelPromise.class));
        Mockito.when((Object)this.channel.writeAndFlush(ArgumentMatchers.any())).thenReturn(Mockito.mock(ChannelPromise.class));
        ((Bookie)Mockito.doAnswer(invocationOnMock -> {
            BookkeeperInternalCallbacks.WriteCallback wc = (BookkeeperInternalCallbacks.WriteCallback)invocationOnMock.getArgument(2);
            wc.writeComplete(0, this.request.getAddRequest().getLedgerId(), this.request.getAddRequest().getEntryId(), null, null);
            return null;
        }).when((Object)this.bookie)).addEntry((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.eq((boolean)false), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.WriteCallback.class), ArgumentMatchers.same((Object)this.channel), (byte[])ArgumentMatchers.eq((Object)new byte[0]));
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(arg_0 -> WriteEntryProcessorV3Test.lambda$testNormalWritesOnWritableBookie$5(writtenObject, latch, (ChannelPromise)promise, arg_0)).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any());
        this.processor.run();
        ((Bookie)Mockito.verify((Object)this.bookie, (VerificationMode)Mockito.times((int)1))).addEntry((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.eq((boolean)false), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.WriteCallback.class), ArgumentMatchers.same((Object)this.channel), (byte[])ArgumentMatchers.eq((Object)new byte[0]));
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(BookkeeperProtocol.Response.class));
        latch.await();
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookkeeperProtocol.Response));
        BookkeeperProtocol.Response response = (BookkeeperProtocol.Response)writtenObject.get();
        Assert.assertEquals((Object)BookkeeperProtocol.StatusCode.EOK, (Object)response.getStatus());
    }

    private static /* synthetic */ Object lambda$testNormalWritesOnWritableBookie$5(AtomicReference writtenObject, CountDownLatch latch, ChannelPromise promise, InvocationOnMock invocationOnMock) throws Throwable {
        writtenObject.set(invocationOnMock.getArgument(0));
        latch.countDown();
        return promise;
    }

    private static /* synthetic */ Object lambda$testHighPriorityWritesOnReadOnlyBookieWhenHighPriorityWritesAllowed$3(AtomicReference writtenObject, CountDownLatch latch, ChannelPromise promise, InvocationOnMock invocationOnMock) throws Throwable {
        writtenObject.set(invocationOnMock.getArgument(0));
        latch.countDown();
        return promise;
    }

    private static /* synthetic */ Object lambda$testHighPriorityWritesOnReadOnlyBookieWhenHighPriorityWritesDisallowed$1(AtomicReference writtenObject, CountDownLatch latch, ChannelPromise promise, InvocationOnMock invocationOnMock) throws Throwable {
        writtenObject.set(invocationOnMock.getArgument(0));
        latch.countDown();
        return promise;
    }

    private static /* synthetic */ Object lambda$testNoneHighPriorityWritesOnReadOnlyBookie$0(AtomicReference writtenObject, CountDownLatch latch, ChannelPromise promise, InvocationOnMock invocationOnMock) throws Throwable {
        writtenObject.set(invocationOnMock.getArgument(0));
        latch.countDown();
        return promise;
    }
}

