/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.AuditorElector;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditorBookieTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AuditorBookieTest.class);
    private String electionPath;
    private HashMap<String, AuditorElector> auditorElectors = new HashMap();
    private List<ZooKeeper> zkClients = new LinkedList<ZooKeeper>();

    public AuditorBookieTest() {
        super(6);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.startAuditorElectors();
        this.electionPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseConf) + "/underreplication/auditorelection";
    }

    @Override
    public void tearDown() throws Exception {
        this.stopAuditorElectors();
        for (ZooKeeper zk : this.zkClients) {
            zk.close();
        }
        this.zkClients.clear();
        super.tearDown();
    }

    @Test
    public void testEnsureOnlySingleAuditor() throws Exception {
        BookieServer auditor = this.verifyAuditor();
        int indexOf = this.bs.indexOf(auditor);
        int bkIndexDownBookie = indexOf < this.bs.size() - 1 ? indexOf + 1 : indexOf - 1;
        this.shutdownBookie((BookieServer)this.bs.get(bkIndexDownBookie));
        this.startNewBookie();
        this.startNewBookie();
        BookieServer newAuditor = this.waitForNewAuditor(auditor);
        Assert.assertSame((String)"Auditor re-election is not happened for auditor failure!", (Object)auditor, (Object)newAuditor);
    }

    @Test
    public void testSuccessiveAuditorCrashes() throws Exception {
        BookieServer auditor = this.verifyAuditor();
        this.shutdownBookie(auditor);
        BookieServer newAuditor1 = this.waitForNewAuditor(auditor);
        this.bs.remove(auditor);
        this.shutdownBookie(newAuditor1);
        BookieServer newAuditor2 = this.waitForNewAuditor(newAuditor1);
        Assert.assertNotSame((String)"Auditor re-election is not happened for auditor failure!", (Object)auditor, (Object)newAuditor2);
        this.bs.remove(newAuditor1);
    }

    @Test
    public void testBookieClusterRestart() throws Exception {
        BookieServer auditor = this.verifyAuditor();
        for (AuditorElector auditorElector : this.auditorElectors.values()) {
            Assert.assertTrue((String)"Auditor elector is not running!", (boolean)auditorElector.isRunning());
        }
        this.stopBKCluster();
        this.stopAuditorElectors();
        this.startBKCluster(this.zkUtil.getMetadataServiceUri());
        this.startAuditorElectors();
        BookieServer newAuditor = this.waitForNewAuditor(auditor);
        Assert.assertNotSame((String)"Auditor re-election is not happened for auditor failure!", (Object)auditor, (Object)newAuditor);
    }

    @Test
    public void testShutdown() throws Exception {
        BookieServer auditor = this.verifyAuditor();
        this.shutdownBookie(auditor);
        BookieServer newAuditor = this.waitForNewAuditor(auditor);
        Assert.assertNotSame((String)"Auditor re-election is not happened for auditor failure!", (Object)auditor, (Object)newAuditor);
        int indexOfDownBookie = this.bs.indexOf(auditor);
        this.bs.remove(indexOfDownBookie);
        this.bsConfs.remove(indexOfDownBookie);
        List children = this.zkc.getChildren(this.electionPath, false);
        for (String child : children) {
            byte[] data = this.zkc.getData(this.electionPath + '/' + child, false, null);
            String bookieIP = new String(data);
            String addr = auditor.getLocalAddress().toString();
            Assert.assertFalse((String)"AuditorElection cleanup fails", (boolean)bookieIP.contains(addr));
        }
    }

    @Test
    public void testRestartAuditorBookieAfterCrashing() throws Exception {
        BookieServer auditor = this.verifyAuditor();
        this.shutdownBookie(auditor);
        String addr = auditor.getLocalAddress().toString();
        int indexOfDownBookie = this.bs.indexOf(auditor);
        ServerConfiguration serverConfiguration = (ServerConfiguration)this.bsConfs.get(indexOfDownBookie);
        this.bs.remove(indexOfDownBookie);
        this.bsConfs.remove(indexOfDownBookie);
        this.auditorElectors.remove(addr);
        this.startBookie(serverConfiguration);
        LOG.debug("Performing Auditor Election:" + addr);
        this.startAuditorElector(addr);
        BookieServer newAuditor = this.waitForNewAuditor(auditor);
        Assert.assertNotSame((String)"Auditor re-election is not happened for auditor failure!", (Object)auditor, (Object)newAuditor);
        Assert.assertFalse((String)"No relection after old auditor rejoins", (auditor.getLocalAddress().getPort() == newAuditor.getLocalAddress().getPort() ? 1 : 0) != 0);
    }

    private void startAuditorElector(String addr) throws Exception {
        ZooKeeperClient zk = ZooKeeperClient.newBuilder().connectString(this.zkUtil.getZooKeeperConnectString()).sessionTimeoutMs(10000).build();
        this.zkClients.add((ZooKeeper)zk);
        AuditorElector auditorElector = new AuditorElector(addr, this.baseConf, (ZooKeeper)zk);
        this.auditorElectors.put(addr, auditorElector);
        auditorElector.start();
        LOG.debug("Starting Auditor Elector");
    }

    private void startAuditorElectors() throws Exception {
        for (BookieServer bserver : this.bs) {
            String addr = bserver.getLocalAddress().toString();
            this.startAuditorElector(addr);
        }
    }

    private void stopAuditorElectors() throws Exception {
        for (AuditorElector auditorElector : this.auditorElectors.values()) {
            auditorElector.shutdown();
            LOG.debug("Stopping Auditor Elector!");
        }
    }

    private BookieServer verifyAuditor() throws Exception {
        List<BookieServer> auditors = this.getAuditorBookie();
        Assert.assertEquals((String)"Multiple Bookies acting as Auditor!", (long)1L, (long)auditors.size());
        LOG.debug("Bookie running as Auditor:" + auditors.get(0));
        return auditors.get(0);
    }

    private List<BookieServer> getAuditorBookie() throws Exception {
        LinkedList<BookieServer> auditors = new LinkedList<BookieServer>();
        byte[] data = this.zkc.getData(this.electionPath, false, null);
        Assert.assertNotNull((String)"Auditor election failed", (Object)data);
        for (BookieServer bks : this.bs) {
            if (!new String(data).contains(bks.getLocalAddress().getPort() + "")) continue;
            auditors.add(bks);
        }
        return auditors;
    }

    private void shutdownBookie(BookieServer bkServer) throws Exception {
        String addr = bkServer.getLocalAddress().toString();
        LOG.debug("Shutting down bookie:" + addr);
        bkServer.shutdown();
        this.auditorElectors.get(addr).shutdown();
    }

    private BookieServer waitForNewAuditor(BookieServer auditor) throws Exception {
        List<BookieServer> auditors;
        BookieServer newAuditor = null;
        for (int retryCount = 8; retryCount > 0 && ((auditors = this.getAuditorBookie()).size() <= 0 || auditor == (newAuditor = auditors.get(0))); --retryCount) {
            Thread.sleep(500L);
        }
        Assert.assertNotNull((String)"New Auditor is not reelected after auditor crashes", newAuditor);
        this.verifyAuditor();
        return newAuditor;
    }
}

