/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.AuditorElector;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditorLedgerCheckerTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AuditorLedgerCheckerTest.class);
    private static final byte[] ledgerPassword = "aaa".getBytes();
    private Random rng;
    private BookKeeper.DigestType digestType;
    private String underreplicatedPath;
    private Map<String, AuditorElector> auditorElectors = new ConcurrentHashMap<String, AuditorElector>();
    private ZkLedgerUnderreplicationManager urLedgerMgr;
    private Set<Long> urLedgerList;
    private String electionPath;
    private List<Long> ledgerList;

    public AuditorLedgerCheckerTest() throws IOException, KeeperException, InterruptedException, ReplicationException.CompatibilityException {
        this("org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory");
    }

    AuditorLedgerCheckerTest(String ledgerManagerFactoryClass) throws IOException, KeeperException, InterruptedException, ReplicationException.CompatibilityException {
        super(3);
        LOG.info("Running test case using ledger manager : " + ledgerManagerFactoryClass);
        this.digestType = BookKeeper.DigestType.CRC32;
        this.baseConf.setLedgerManagerFactoryClassName(ledgerManagerFactoryClass);
        this.baseClientConf.setLedgerManagerFactoryClassName(ledgerManagerFactoryClass);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.underreplicatedPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseClientConf) + "/underreplication/ledgers";
        this.electionPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseConf) + "/underreplication/auditorelection";
        this.urLedgerMgr = new ZkLedgerUnderreplicationManager((AbstractConfiguration)this.baseClientConf, this.zkc);
        this.startAuditorElectors();
        this.rng = new Random(System.currentTimeMillis());
        this.urLedgerList = new HashSet<Long>();
        this.ledgerList = new ArrayList<Long>(2);
        this.baseClientConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
    }

    @Override
    public void tearDown() throws Exception {
        this.stopAuditorElectors();
        super.tearDown();
    }

    private void startAuditorElectors() throws Exception {
        for (BookieServer bserver : this.bs) {
            String addr = bserver.getLocalAddress().toString();
            AuditorElector auditorElector = new AuditorElector(addr, this.baseConf, this.zkc);
            this.auditorElectors.put(addr, auditorElector);
            auditorElector.start();
            LOG.debug("Starting Auditor Elector");
        }
    }

    private void stopAuditorElectors() throws Exception {
        for (AuditorElector auditorElector : this.auditorElectors.values()) {
            auditorElector.shutdown();
            LOG.debug("Stopping Auditor Elector!");
        }
    }

    @Test
    public void testSimpleLedger() throws Exception {
        LedgerHandle lh1 = this.createAndAddEntriesToLedger();
        Long ledgerId = lh1.getId();
        LOG.debug("Created ledger : " + ledgerId);
        this.ledgerList.add(ledgerId);
        lh1.close();
        CountDownLatch underReplicaLatch = this.registerUrLedgerWatcher(this.ledgerList.size());
        int bkShutdownIndex = this.bs.size() - 1;
        String shutdownBookie = this.shutdownBookie(bkShutdownIndex);
        LOG.debug("Waiting for ledgers to be marked as under replicated");
        this.waitForAuditToComplete();
        underReplicaLatch.await(5L, TimeUnit.SECONDS);
        Map<Long, String> urLedgerData = this.getUrLedgerData(this.urLedgerList);
        Assert.assertEquals((String)"Missed identifying under replicated ledgers", (long)1L, (long)this.urLedgerList.size());
        Assert.assertTrue((String)("Ledger is not marked as underreplicated:" + ledgerId), (boolean)this.urLedgerList.contains(ledgerId));
        String data = urLedgerData.get(ledgerId);
        Assert.assertTrue((String)("Bookie " + shutdownBookie + "is not listed in the ledger as missing replica :" + data), (boolean)data.contains(shutdownBookie));
    }

    @Test
    public void testRestartBookie() throws Exception {
        LedgerHandle lh1 = this.createAndAddEntriesToLedger();
        LedgerHandle lh2 = this.createAndAddEntriesToLedger();
        LOG.debug("Created following ledgers : {}, {}", (Object)lh1, (Object)lh2);
        int bkShutdownIndex = this.bs.size() - 1;
        ServerConfiguration bookieConf1 = (ServerConfiguration)this.bsConfs.get(bkShutdownIndex);
        String shutdownBookie = this.shutdownBookie(bkShutdownIndex);
        this.bs.add(this.startBookie(bookieConf1));
        this.waitForLedgerMissingReplicas(lh1.getId(), 10L, shutdownBookie);
        this.waitForLedgerMissingReplicas(lh2.getId(), 10L, shutdownBookie);
    }

    @Test
    public void testMultipleBookieFailures() throws Exception {
        LedgerHandle lh1 = this.createAndAddEntriesToLedger();
        this.shutdownBookie(this.bs.size() - 1);
        this.doLedgerRereplication(lh1.getId());
        String shutdownBookie = this.shutdownBookie(this.bs.size() - 1);
        LOG.debug("Waiting for ledgers to be marked as under replicated");
        Assert.assertTrue((String)"Ledger should be missing second replica", (boolean)this.waitForLedgerMissingReplicas(lh1.getId(), 10L, shutdownBookie));
    }

    @Test
    public void testToggleLedgerReplication() throws Exception {
        LedgerHandle lh1 = this.createAndAddEntriesToLedger();
        this.ledgerList.add(lh1.getId());
        LOG.debug("Created following ledgers : " + this.ledgerList);
        CountDownLatch urReplicaLatch = this.registerUrLedgerWatcher(this.ledgerList.size());
        this.urLedgerMgr.disableLedgerReplication();
        ArrayList<String> shutdownBookieList = new ArrayList<String>();
        shutdownBookieList.add(this.shutdownBookie(this.bs.size() - 1));
        shutdownBookieList.add(this.shutdownBookie(this.bs.size() - 1));
        Assert.assertFalse((String)"Ledger replication is not disabled!", (boolean)urReplicaLatch.await(1L, TimeUnit.SECONDS));
        this.urLedgerMgr.enableLedgerReplication();
        Assert.assertTrue((String)"Ledger replication is not enabled!", (boolean)urReplicaLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testDuplicateEnDisableAutoRecovery() throws Exception {
        this.urLedgerMgr.disableLedgerReplication();
        try {
            this.urLedgerMgr.disableLedgerReplication();
            Assert.fail((String)"Must throw exception, since AutoRecovery is already disabled");
        }
        catch (ReplicationException.UnavailableException e) {
            Assert.assertTrue((String)"AutoRecovery is not disabled previously!", (boolean)(e.getCause() instanceof KeeperException.NodeExistsException));
        }
        this.urLedgerMgr.enableLedgerReplication();
        try {
            this.urLedgerMgr.enableLedgerReplication();
            Assert.fail((String)"Must throw exception, since AutoRecovery is already enabled");
        }
        catch (ReplicationException.UnavailableException e) {
            Assert.assertTrue((String)"AutoRecovery is not enabled previously!", (boolean)(e.getCause() instanceof KeeperException.NoNodeException));
        }
    }

    @Test
    public void testReadOnlyBookieExclusionFromURLedgersCheck() throws Exception {
        LedgerHandle lh = this.createAndAddEntriesToLedger();
        this.ledgerList.add(lh.getId());
        LOG.debug("Created following ledgers : " + this.ledgerList);
        int count = this.ledgerList.size();
        CountDownLatch underReplicaLatch = this.registerUrLedgerWatcher(count);
        int bkIndex = 2;
        ServerConfiguration bookieConf = (ServerConfiguration)this.bsConfs.get(2);
        BookieServer bk = (BookieServer)this.bs.get(2);
        bookieConf.setReadOnlyModeEnabled(true);
        bk.getBookie().getStateManager().doTransitionToReadOnlyMode();
        this.bkc.waitForReadOnlyBookie(Bookie.getBookieAddress((ServerConfiguration)((ServerConfiguration)this.bsConfs.get(2)))).get(30L, TimeUnit.SECONDS);
        LOG.debug("Waiting for Auditor to finish ledger check.");
        this.waitForAuditToComplete();
        Assert.assertFalse((String)"latch should not have completed", (boolean)underReplicaLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testReadOnlyBookieShutdown() throws Exception {
        LedgerHandle lh = this.createAndAddEntriesToLedger();
        long ledgerId = lh.getId();
        this.ledgerList.add(ledgerId);
        LOG.debug("Created following ledgers : " + this.ledgerList);
        int count = this.ledgerList.size();
        CountDownLatch underReplicaLatch = this.registerUrLedgerWatcher(count);
        int bkIndex = this.bs.size() - 1;
        LOG.debug("Moving bookie {} {} to read only...", (Object)bkIndex, this.bs.get(bkIndex));
        ServerConfiguration bookieConf = (ServerConfiguration)this.bsConfs.get(bkIndex);
        BookieServer bk = (BookieServer)this.bs.get(bkIndex);
        bookieConf.setReadOnlyModeEnabled(true);
        bk.getBookie().getStateManager().doTransitionToReadOnlyMode();
        this.bkc.waitForReadOnlyBookie(Bookie.getBookieAddress((ServerConfiguration)((ServerConfiguration)this.bsConfs.get(bkIndex)))).get(30L, TimeUnit.SECONDS);
        LOG.debug("Waiting for Auditor to finish ledger check.");
        this.waitForAuditToComplete();
        Assert.assertFalse((String)"latch should not have completed", (boolean)underReplicaLatch.await(1L, TimeUnit.SECONDS));
        String shutdownBookie = this.shutdownBookie(bkIndex);
        LOG.debug("Waiting for ledgers to be marked as under replicated");
        this.waitForAuditToComplete();
        underReplicaLatch.await(5L, TimeUnit.SECONDS);
        Map<Long, String> urLedgerData = this.getUrLedgerData(this.urLedgerList);
        Assert.assertEquals((String)"Missed identifying under replicated ledgers", (long)1L, (long)this.urLedgerList.size());
        Assert.assertTrue((String)("Ledger is not marked as underreplicated:" + ledgerId), (boolean)this.urLedgerList.contains(ledgerId));
        String data = urLedgerData.get(ledgerId);
        Assert.assertTrue((String)("Bookie " + shutdownBookie + "is not listed in the ledger as missing replica :" + data), (boolean)data.contains(shutdownBookie));
    }

    public void testInnerDelayedAuditOfLostBookies() throws Exception {
        LedgerHandle lh1 = this.createAndAddEntriesToLedger();
        Long ledgerId = lh1.getId();
        LOG.debug("Created ledger : " + ledgerId);
        this.ledgerList.add(ledgerId);
        lh1.close();
        CountDownLatch underReplicaLatch = this.registerUrLedgerWatcher(this.ledgerList.size());
        this.urLedgerMgr.setLostBookieRecoveryDelay(5);
        String shutdownBookie = this.shutDownNonAuditorBookie();
        LOG.debug("Waiting for ledgers to be marked as under replicated");
        Assert.assertFalse((String)"audit of lost bookie isn't delayed", (boolean)underReplicaLatch.await(4L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"under replicated ledgers identified when it was not expected", (long)0L, (long)this.urLedgerList.size());
        Assert.assertTrue((String)"audit of lost bookie isn't delayed", (boolean)underReplicaLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("Ledger is not marked as underreplicated:" + ledgerId), (boolean)this.urLedgerList.contains(ledgerId));
        Map<Long, String> urLedgerData = this.getUrLedgerData(this.urLedgerList);
        String data = urLedgerData.get(ledgerId);
        Assert.assertTrue((String)("Bookie " + shutdownBookie + "is not listed in the ledger as missing replica :" + data), (boolean)data.contains(shutdownBookie));
    }

    @Test
    public void testDelayedAuditOfLostBookies() throws Exception {
        Thread.sleep(1000L);
        this.testInnerDelayedAuditOfLostBookies();
    }

    @Test
    public void testDelayedAuditWithPeriodicBookieCheck() throws Exception {
        this.stopAuditorElectors();
        this.baseConf.setAuditorPeriodicBookieCheckInterval(2L);
        this.startAuditorElectors();
        Thread.sleep(1000L);
        this.testInnerDelayedAuditOfLostBookies();
    }

    @Test
    public void testRescheduleOfDelayedAuditOfLostBookiesToStartImmediately() throws Exception {
        Thread.sleep(1000L);
        LedgerHandle lh1 = this.createAndAddEntriesToLedger();
        Long ledgerId = lh1.getId();
        LOG.debug("Created ledger : " + ledgerId);
        this.ledgerList.add(ledgerId);
        lh1.close();
        CountDownLatch underReplicaLatch = this.registerUrLedgerWatcher(this.ledgerList.size());
        this.urLedgerMgr.setLostBookieRecoveryDelay(50);
        String shutdownBookie = this.shutDownNonAuditorBookie();
        LOG.debug("Waiting for ledgers to be marked as under replicated");
        Assert.assertFalse((String)"audit of lost bookie isn't delayed", (boolean)underReplicaLatch.await(4L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"under replicated ledgers identified when it was not expected", (long)0L, (long)this.urLedgerList.size());
        this.urLedgerMgr.setLostBookieRecoveryDelay(0);
        Assert.assertTrue((String)"audit of lost bookie isn't delayed", (boolean)underReplicaLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("Ledger is not marked as underreplicated:" + ledgerId), (boolean)this.urLedgerList.contains(ledgerId));
        Map<Long, String> urLedgerData = this.getUrLedgerData(this.urLedgerList);
        String data = urLedgerData.get(ledgerId);
        Assert.assertTrue((String)("Bookie " + shutdownBookie + "is not listed in the ledger as missing replica :" + data), (boolean)data.contains(shutdownBookie));
    }

    @Test
    public void testRescheduleOfDelayedAuditOfLostBookiesToStartLater() throws Exception {
        Thread.sleep(1000L);
        LedgerHandle lh1 = this.createAndAddEntriesToLedger();
        Long ledgerId = lh1.getId();
        LOG.debug("Created ledger : " + ledgerId);
        this.ledgerList.add(ledgerId);
        lh1.close();
        CountDownLatch underReplicaLatch = this.registerUrLedgerWatcher(this.ledgerList.size());
        this.urLedgerMgr.setLostBookieRecoveryDelay(3);
        String shutdownBookie = this.shutDownNonAuditorBookie();
        LOG.debug("Waiting for ledgers to be marked as under replicated");
        Assert.assertFalse((String)"audit of lost bookie isn't delayed", (boolean)underReplicaLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"under replicated ledgers identified when it was not expected", (long)0L, (long)this.urLedgerList.size());
        this.urLedgerMgr.setLostBookieRecoveryDelay(4);
        LOG.debug("Waiting for ledgers to be marked as under replicated");
        Assert.assertFalse((String)"audit of lost bookie isn't delayed", (boolean)underReplicaLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"under replicated ledgers identified when it was not expected", (long)0L, (long)this.urLedgerList.size());
        Assert.assertTrue((String)"audit of lost bookie isn't delayed", (boolean)underReplicaLatch.await(3L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("Ledger is not marked as underreplicated:" + ledgerId), (boolean)this.urLedgerList.contains(ledgerId));
        Map<Long, String> urLedgerData = this.getUrLedgerData(this.urLedgerList);
        String data = urLedgerData.get(ledgerId);
        Assert.assertTrue((String)("Bookie " + shutdownBookie + "is not listed in the ledger as missing replica :" + data), (boolean)data.contains(shutdownBookie));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTriggerAuditorWithNoPendingAuditTask() throws Exception {
        Thread.sleep(1000L);
        int lostBookieRecoveryDelayConfValue = this.baseConf.getLostBookieRecoveryDelay();
        Auditor auditorBookiesAuditor = this.getAuditorBookiesAuditor();
        Future auditTask = auditorBookiesAuditor.getAuditTask();
        int lostBookieRecoveryDelayBeforeChange = auditorBookiesAuditor.getLostBookieRecoveryDelayBeforeChange();
        Assert.assertEquals((String)"auditTask is supposed to be null", null, (Object)auditTask);
        Assert.assertEquals((String)"lostBookieRecoveryDelayBeforeChange of Auditor should be equal to BaseConf's lostBookieRecoveryDelay", (long)lostBookieRecoveryDelayConfValue, (long)lostBookieRecoveryDelayBeforeChange);
        OrderedScheduler scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-scheduler").numThreads(1).build();
        try {
            MetadataClientDriver driver = MetadataDrivers.getClientDriver((URI)URI.create(this.baseClientConf.getMetadataServiceUri()));
            try {
                driver.initialize(this.baseClientConf, (ScheduledExecutorService)scheduler, (StatsLogger)NullStatsLogger.INSTANCE, Optional.of(this.zkc));
                int numofledgers = 5;
                Random rand = new Random();
                for (int i = 0; i < numofledgers; ++i) {
                    LedgerMetadata metadata = new LedgerMetadata(3, 2, 2, BookKeeper.DigestType.CRC32, "passwd".getBytes());
                    ArrayList<BookieSocketAddress> ensemble = new ArrayList<BookieSocketAddress>();
                    ensemble.add(new BookieSocketAddress("99.99.99.99:9999"));
                    ensemble.add(new BookieSocketAddress("11.11.11.11:1111"));
                    ensemble.add(new BookieSocketAddress("88.88.88.88:8888"));
                    metadata.addEnsemble(0L, ensemble);
                    MutableInt ledgerCreateRC = new MutableInt(-1);
                    CountDownLatch latch = new CountDownLatch(1);
                    long ledgerId = Math.abs(rand.nextLong()) % 100000000L;
                    try (LedgerManager lm = driver.getLedgerManagerFactory().newLedgerManager();){
                        lm.createLedgerMetadata(ledgerId, metadata, (rc, result) -> {
                            ledgerCreateRC.setValue(rc);
                            latch.countDown();
                        });
                    }
                    Assert.assertTrue((String)"Ledger creation should complete within 2 secs", (boolean)latch.await(2000L, TimeUnit.MILLISECONDS));
                    Assert.assertEquals((String)"LedgerCreate should succeed and return OK rc value", (Object)0, (Object)ledgerCreateRC.getValue());
                    this.ledgerList.add(ledgerId);
                }
                CountDownLatch underReplicaLatch = this.registerUrLedgerWatcher(this.ledgerList.size());
                this.urLedgerMgr.setLostBookieRecoveryDelay(lostBookieRecoveryDelayBeforeChange);
                Assert.assertTrue((String)"Audit should be triggered and created ledgers should be marked as underreplicated", (boolean)underReplicaLatch.await(2L, TimeUnit.SECONDS));
                Assert.assertEquals((String)"All the ledgers should be marked as underreplicated", (long)this.ledgerList.size(), (long)this.urLedgerList.size());
                auditTask = auditorBookiesAuditor.getAuditTask();
                Assert.assertEquals((String)"auditTask is supposed to be null", null, (Object)auditTask);
                Assert.assertEquals((String)"lostBookieRecoveryDelayBeforeChange of Auditor should be equal to BaseConf's lostBookieRecoveryDelay", (long)lostBookieRecoveryDelayBeforeChange, (long)auditorBookiesAuditor.getLostBookieRecoveryDelayBeforeChange());
            }
            finally {
                if (Collections.singletonList(driver).get(0) != null) {
                    driver.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(scheduler).get(0) != null) {
                scheduler.shutdown();
            }
        }
    }

    @Test
    public void testTriggerAuditorWithPendingAuditTask() throws Exception {
        Thread.sleep(1000L);
        Auditor auditorBookiesAuditor = this.getAuditorBookiesAuditor();
        LedgerHandle lh1 = this.createAndAddEntriesToLedger();
        Long ledgerId = lh1.getId();
        LOG.debug("Created ledger : " + ledgerId);
        this.ledgerList.add(ledgerId);
        lh1.close();
        CountDownLatch underReplicaLatch = this.registerUrLedgerWatcher(this.ledgerList.size());
        int lostBookieRecoveryDelay = 5;
        this.urLedgerMgr.setLostBookieRecoveryDelay(lostBookieRecoveryDelay);
        String shutdownBookie = this.shutDownNonAuditorBookie();
        LOG.debug("Waiting for ledgers to be marked as under replicated");
        Assert.assertFalse((String)"audit of lost bookie isn't delayed", (boolean)underReplicaLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"under replicated ledgers identified when it was not expected", (long)0L, (long)this.urLedgerList.size());
        Future auditTask = auditorBookiesAuditor.getAuditTask();
        Assert.assertNotEquals((String)"auditTask is not supposed to be null", null, (Object)auditTask);
        Assert.assertEquals((String)"lostBookieRecoveryDelayBeforeChange of Auditor should be equal to what we set", (long)lostBookieRecoveryDelay, (long)auditorBookiesAuditor.getLostBookieRecoveryDelayBeforeChange());
        this.urLedgerMgr.setLostBookieRecoveryDelay(lostBookieRecoveryDelay);
        Assert.assertTrue((String)"audit of lost bookie shouldn't be delayed", (boolean)underReplicaLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"all under replicated ledgers should be identified", (long)this.ledgerList.size(), (long)this.urLedgerList.size());
        Thread.sleep(100L);
        auditTask = auditorBookiesAuditor.getAuditTask();
        Assert.assertEquals((String)"auditTask is supposed to be null", null, (Object)auditTask);
        Assert.assertEquals((String)"lostBookieRecoveryDelayBeforeChange of Auditor should be equal to previously set value", (long)lostBookieRecoveryDelay, (long)auditorBookiesAuditor.getLostBookieRecoveryDelayBeforeChange());
    }

    @Test
    public void testTriggerAuditorBySettingDelayToZeroWithPendingAuditTask() throws Exception {
        Thread.sleep(1000L);
        Auditor auditorBookiesAuditor = this.getAuditorBookiesAuditor();
        LedgerHandle lh1 = this.createAndAddEntriesToLedger();
        Long ledgerId = lh1.getId();
        LOG.debug("Created ledger : " + ledgerId);
        this.ledgerList.add(ledgerId);
        lh1.close();
        CountDownLatch underReplicaLatch = this.registerUrLedgerWatcher(this.ledgerList.size());
        int lostBookieRecoveryDelay = 5;
        this.urLedgerMgr.setLostBookieRecoveryDelay(lostBookieRecoveryDelay);
        String shutdownBookie = this.shutDownNonAuditorBookie();
        LOG.debug("Waiting for ledgers to be marked as under replicated");
        Assert.assertFalse((String)"audit of lost bookie isn't delayed", (boolean)underReplicaLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"under replicated ledgers identified when it was not expected", (long)0L, (long)this.urLedgerList.size());
        Future auditTask = auditorBookiesAuditor.getAuditTask();
        Assert.assertNotEquals((String)"auditTask is not supposed to be null", null, (Object)auditTask);
        Assert.assertEquals((String)"lostBookieRecoveryDelayBeforeChange of Auditor should be equal to what we set", (long)lostBookieRecoveryDelay, (long)auditorBookiesAuditor.getLostBookieRecoveryDelayBeforeChange());
        this.urLedgerMgr.setLostBookieRecoveryDelay(0);
        Assert.assertTrue((String)"audit of lost bookie shouldn't be delayed", (boolean)underReplicaLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"all under replicated ledgers should be identified", (long)this.ledgerList.size(), (long)this.urLedgerList.size());
        Thread.sleep(100L);
        auditTask = auditorBookiesAuditor.getAuditTask();
        Assert.assertEquals((String)"auditTask is supposed to be null", null, (Object)auditTask);
        Assert.assertEquals((String)"lostBookieRecoveryDelayBeforeChange of Auditor should be equal to previously set value", (long)0L, (long)auditorBookiesAuditor.getLostBookieRecoveryDelayBeforeChange());
    }

    @Test
    public void testDelayedAuditWithMultipleBookieFailures() throws Exception {
        Thread.sleep(1000L);
        LedgerHandle lh1 = this.createAndAddEntriesToLedger();
        Long ledgerId = lh1.getId();
        LOG.debug("Created ledger : " + ledgerId);
        this.ledgerList.add(ledgerId);
        lh1.close();
        CountDownLatch underReplicaLatch = this.registerUrLedgerWatcher(this.ledgerList.size());
        this.urLedgerMgr.setLostBookieRecoveryDelay(10);
        String shutdownBookie1 = this.shutDownNonAuditorBookie();
        Assert.assertFalse((String)"audit of lost bookie isn't delayed", (boolean)underReplicaLatch.await(3L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"under replicated ledgers identified when it was not expected", (long)0L, (long)this.urLedgerList.size());
        String shutdownBookie2 = this.shutDownNonAuditorBookie();
        Thread.sleep(2000L);
        Assert.assertTrue((String)("Ledger is not marked as underreplicated:" + ledgerId), (boolean)this.urLedgerList.contains(ledgerId));
        Map<Long, String> urLedgerData = this.getUrLedgerData(this.urLedgerList);
        String data = urLedgerData.get(ledgerId);
        Assert.assertTrue((String)("Bookie " + shutdownBookie1 + shutdownBookie2 + " are not listed in the ledger as missing replicas :" + data), (data.contains(shutdownBookie1) && data.contains(shutdownBookie2) ? 1 : 0) != 0);
    }

    @Test
    public void testDelayedAuditWithRollingUpgrade() throws Exception {
        Thread.sleep(1000L);
        LedgerHandle lh1 = this.createAndAddEntriesToLedger();
        Long ledgerId = lh1.getId();
        LOG.debug("Created ledger : " + ledgerId);
        this.ledgerList.add(ledgerId);
        lh1.close();
        CountDownLatch underReplicaLatch = this.registerUrLedgerWatcher(this.ledgerList.size());
        this.urLedgerMgr.setLostBookieRecoveryDelay(5);
        int idx1 = this.getShutDownNonAuditorBookieIdx("");
        ServerConfiguration conf1 = (ServerConfiguration)this.bsConfs.get(idx1);
        String shutdownBookie1 = this.shutdownBookie(idx1);
        Assert.assertFalse((String)"audit of lost bookie isn't delayed", (boolean)underReplicaLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"under replicated ledgers identified when it was not expected", (long)0L, (long)this.urLedgerList.size());
        this.bs.add(this.startBookie(conf1));
        String shutdownBookie2 = this.shutDownNonAuditorBookie(shutdownBookie1);
        Assert.assertFalse((String)"audit of lost bookie isn't delayed", (boolean)underReplicaLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"under replicated ledgers identified when it was not expected", (long)0L, (long)this.urLedgerList.size());
        Thread.sleep(4000L);
        Assert.assertTrue((String)("Ledger is not marked as underreplicated:" + ledgerId), (boolean)this.urLedgerList.contains(ledgerId));
        Map<Long, String> urLedgerData = this.getUrLedgerData(this.urLedgerList);
        String data = urLedgerData.get(ledgerId);
        Assert.assertTrue((String)("Bookie " + shutdownBookie1 + "wrongly listed as missing the ledger: " + data), (!data.contains(shutdownBookie1) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Bookie " + shutdownBookie2 + " is not listed in the ledger as missing replicas :" + data), (boolean)data.contains(shutdownBookie2));
        LOG.info("*****************Test Complete");
    }

    private void waitForAuditToComplete() throws Exception {
        long endTime = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < endTime) {
            Auditor auditor = this.getAuditorBookiesAuditor();
            if (auditor != null) {
                Future task = auditor.submitAuditTask();
                task.get(5L, TimeUnit.SECONDS);
                return;
            }
            Thread.sleep(100L);
        }
        throw new TimeoutException("Could not find an audit within 5 seconds");
    }

    private boolean waitForLedgerMissingReplicas(Long ledgerId, long secondsToWait, String ... replicas) throws Exception {
        int i = 0;
        while ((long)i < secondsToWait) {
            try {
                DataFormats.UnderreplicatedLedgerFormat data = this.urLedgerMgr.getLedgerUnreplicationInfo(ledgerId.longValue());
                boolean all = true;
                for (String r : replicas) {
                    all = all && data.getReplicaList().contains((Object)r);
                }
                if (all) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.sleep(1000L);
            ++i;
        }
        return false;
    }

    private CountDownLatch registerUrLedgerWatcher(int count) throws KeeperException, InterruptedException {
        CountDownLatch underReplicaLatch = new CountDownLatch(count);
        for (Long ledgerId : this.ledgerList) {
            ChildWatcher urLedgerWatcher = new ChildWatcher(underReplicaLatch);
            String znode = ZkLedgerUnderreplicationManager.getUrLedgerZnode((String)this.underreplicatedPath, (long)ledgerId);
            this.zkc.exists(znode, (Watcher)urLedgerWatcher);
        }
        return underReplicaLatch;
    }

    private void doLedgerRereplication(Long ... ledgerIds) throws ReplicationException.UnavailableException {
        for (int i = 0; i < ledgerIds.length; ++i) {
            long lid = this.urLedgerMgr.getLedgerToRereplicate();
            Assert.assertTrue((String)"Received unexpected ledgerid", (boolean)Arrays.asList(ledgerIds).contains(lid));
            this.urLedgerMgr.markLedgerReplicated(lid);
            this.urLedgerMgr.releaseUnderreplicatedLedger(lid);
        }
    }

    private String shutdownBookie(int bkShutdownIndex) throws Exception {
        BookieServer bkServer = (BookieServer)this.bs.get(bkShutdownIndex);
        String bookieAddr = bkServer.getLocalAddress().toString();
        LOG.debug("Shutting down bookie:" + bookieAddr);
        this.killBookie(bkShutdownIndex);
        this.auditorElectors.get(bookieAddr).shutdown();
        this.auditorElectors.remove(bookieAddr);
        return bookieAddr;
    }

    private LedgerHandle createAndAddEntriesToLedger() throws BKException, InterruptedException {
        int numEntriesToWrite = 100;
        LedgerHandle lh = this.bkc.createLedger(this.digestType, ledgerPassword);
        LOG.info("Ledger ID: " + lh.getId());
        this.addEntry(numEntriesToWrite, lh);
        return lh;
    }

    private void addEntry(int numEntriesToWrite, LedgerHandle lh) throws InterruptedException, BKException {
        final CountDownLatch completeLatch = new CountDownLatch(numEntriesToWrite);
        final AtomicInteger rc = new AtomicInteger(0);
        for (int i = 0; i < numEntriesToWrite; ++i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(Integer.MAX_VALUE));
            entry.position(0);
            lh.asyncAddEntry(entry.array(), new AsyncCallback.AddCallback(){

                public void addComplete(int rc2, LedgerHandle lh, long entryId, Object ctx) {
                    rc.compareAndSet(0, rc2);
                    completeLatch.countDown();
                }
            }, null);
        }
        completeLatch.await();
        if (rc.get() != 0) {
            throw BKException.create((int)rc.get());
        }
    }

    private Map<Long, String> getUrLedgerData(Set<Long> urLedgerList) throws KeeperException, InterruptedException {
        HashMap<Long, String> urLedgerData = new HashMap<Long, String>();
        for (Long ledgerId : urLedgerList) {
            String znode = ZkLedgerUnderreplicationManager.getUrLedgerZnode((String)this.underreplicatedPath, (long)ledgerId);
            byte[] data = this.zkc.getData(znode, false, null);
            urLedgerData.put(ledgerId, new String(data));
        }
        return urLedgerData;
    }

    private BookieServer getAuditorBookie() throws Exception {
        LinkedList<BookieServer> auditors = new LinkedList<BookieServer>();
        byte[] data = this.zkc.getData(this.electionPath, false, null);
        Assert.assertNotNull((String)"Auditor election failed", (Object)data);
        for (BookieServer bks : this.bs) {
            if (!new String(data).contains(bks.getLocalAddress().getPort() + "")) continue;
            auditors.add(bks);
        }
        Assert.assertEquals((String)"Multiple Bookies acting as Auditor!", (long)1L, (long)auditors.size());
        return (BookieServer)auditors.get(0);
    }

    private Auditor getAuditorBookiesAuditor() throws Exception {
        BookieServer auditorBookieServer = this.getAuditorBookie();
        String bookieAddr = auditorBookieServer.getLocalAddress().toString();
        return this.auditorElectors.get((Object)bookieAddr).auditor;
    }

    private String shutDownNonAuditorBookie() throws Exception {
        int indexOf = this.bs.indexOf(this.getAuditorBookie());
        int bkIndexDownBookie = indexOf < this.bs.size() - 1 ? indexOf + 1 : indexOf - 1;
        return this.shutdownBookie(bkIndexDownBookie);
    }

    private int getShutDownNonAuditorBookieIdx(String exclude) throws Exception {
        int indexOf = this.bs.indexOf(this.getAuditorBookie());
        int bkIndexDownBookie = 0;
        for (int i = 0; i < this.bs.size(); ++i) {
            if (i == indexOf || ((BookieServer)this.bs.get(i)).getLocalAddress().toString().equals(exclude)) continue;
            bkIndexDownBookie = i;
            break;
        }
        return bkIndexDownBookie;
    }

    private String shutDownNonAuditorBookie(String exclude) throws Exception {
        return this.shutdownBookie(this.getShutDownNonAuditorBookieIdx(exclude));
    }

    private class ChildWatcher
    implements Watcher {
        private final CountDownLatch underReplicaLatch;

        public ChildWatcher(CountDownLatch underReplicaLatch) {
            this.underReplicaLatch = underReplicaLatch;
        }

        public void process(WatchedEvent event) {
            LOG.info("Received notification for the ledger path : " + event.getPath());
            for (Long ledgerId : AuditorLedgerCheckerTest.this.ledgerList) {
                if (!event.getPath().contains(ledgerId + "")) continue;
                AuditorLedgerCheckerTest.this.urLedgerList.add(ledgerId);
            }
            LOG.debug("Count down and waiting for next notification");
            this.underReplicaLatch.countDown();
        }
    }
}

