/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collections;
import java.util.List;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerHandleAdapter;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.AuditorElector;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestCallbacks;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditorPeriodicBookieCheckTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AuditorPeriodicBookieCheckTest.class);
    private AuditorElector auditorElector = null;
    private ZooKeeper auditorZookeeper = null;
    private static final int CHECK_INTERVAL = 1;

    public AuditorPeriodicBookieCheckTest() {
        super(3);
        this.baseConf.setPageLimit(1);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setAuditorPeriodicBookieCheckInterval(1L);
        conf.setMetadataServiceUri(this.metadataServiceUri);
        String addr = ((BookieServer)this.bs.get(0)).getLocalAddress().toString();
        this.auditorZookeeper = ZooKeeperClient.newBuilder().connectString(ZKMetadataDriverBase.resolveZkServers((AbstractConfiguration)conf)).sessionTimeoutMs(10000).build();
        this.auditorElector = new AuditorElector(addr, conf, this.auditorZookeeper);
        this.auditorElector.start();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.auditorElector.shutdown();
        this.auditorZookeeper.close();
        super.tearDown();
    }

    @Test
    public void testPeriodicBookieCheckInterval() throws Exception {
        ((ServerConfiguration)this.bsConfs.get(0)).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        MetadataDrivers.runFunctionWithLedgerManagerFactory((ServerConfiguration)((ServerConfiguration)this.bsConfs.get(0)), mFactory -> {
            try (LedgerManager ledgerManager = mFactory.newLedgerManager();){
                LedgerUnderreplicationManager underReplicationManager = mFactory.newLedgerUnderreplicationManager();
                try {
                    LedgerHandle lh = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, "passwd".getBytes());
                    LedgerMetadata md = LedgerHandleAdapter.getLedgerMetadata(lh);
                    List ensemble = (List)md.getEnsembles().get(0L);
                    ensemble.set(0, new BookieSocketAddress("1.1.1.1", 1000));
                    TestCallbacks.GenericCallbackFuture cb = new TestCallbacks.GenericCallbackFuture();
                    ledgerManager.writeLedgerMetadata(lh.getId(), md, cb);
                    cb.get();
                    long underReplicatedLedger = -1L;
                    for (int i = 0; i < 10 && (underReplicatedLedger = underReplicationManager.pollLedgerToRereplicate()) == -1L; ++i) {
                        Thread.sleep(1000L);
                    }
                    Assert.assertEquals((String)"Ledger should be under replicated", (long)lh.getId(), (long)underReplicatedLedger);
                }
                finally {
                    if (Collections.singletonList(underReplicationManager).get(0) != null) {
                        underReplicationManager.close();
                    }
                }
            }
            catch (Exception e) {
                throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
            }
            return null;
        });
    }
}

