/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.replication.AutoRecoveryMain;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;

public class AutoRecoveryMainTest
extends BookKeeperClusterTestCase {
    public AutoRecoveryMainTest() {
        super(3);
    }

    @Test
    public void testStartup() throws Exception {
        AutoRecoveryMain main = new AutoRecoveryMain((ServerConfiguration)this.bsConfs.get(0));
        try {
            main.start();
            Thread.sleep(500L);
            Assert.assertTrue((String)"AuditorElector should be running", (boolean)main.auditorElector.isRunning());
            Assert.assertTrue((String)"Replication worker should be running", (boolean)main.replicationWorker.isRunning());
        }
        finally {
            main.shutdown();
        }
    }

    @Test
    public void testShutdown() throws Exception {
        AutoRecoveryMain main = new AutoRecoveryMain((ServerConfiguration)this.bsConfs.get(0));
        main.start();
        Thread.sleep(500L);
        Assert.assertTrue((String)"AuditorElector should be running", (boolean)main.auditorElector.isRunning());
        Assert.assertTrue((String)"Replication worker should be running", (boolean)main.replicationWorker.isRunning());
        main.shutdown();
        Assert.assertFalse((String)"AuditorElector should not be running", (boolean)main.auditorElector.isRunning());
        Assert.assertFalse((String)"Replication worker should not be running", (boolean)main.replicationWorker.isRunning());
    }

    @Test
    public void testAutoRecoverySessionLoss() throws Exception {
        AutoRecoveryMain main1 = new AutoRecoveryMain((ServerConfiguration)this.bsConfs.get(0));
        AutoRecoveryMain main2 = new AutoRecoveryMain((ServerConfiguration)this.bsConfs.get(1));
        main1.start();
        main2.start();
        Thread.sleep(500L);
        Assert.assertTrue((String)"AuditorElectors should be running", (main1.auditorElector.isRunning() && main2.auditorElector.isRunning() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Replication workers should be running", (main1.replicationWorker.isRunning() && main2.replicationWorker.isRunning() ? 1 : 0) != 0);
        this.zkUtil.expireSession(main1.zk);
        this.zkUtil.expireSession(main2.zk);
        for (int i = 0; i < 10 && (main1.auditorElector.isRunning() || main2.auditorElector.isRunning() || main1.replicationWorker.isRunning() || main2.replicationWorker.isRunning()); ++i) {
            Thread.sleep(1000L);
        }
        Assert.assertFalse((String)"Elector1 should have shutdown", (boolean)main1.auditorElector.isRunning());
        Assert.assertFalse((String)"Elector2 should have shutdown", (boolean)main2.auditorElector.isRunning());
        Assert.assertFalse((String)"RW1 should have shutdown", (boolean)main1.replicationWorker.isRunning());
        Assert.assertFalse((String)"RW2 should have shutdown", (boolean)main2.replicationWorker.isRunning());
    }
}

