/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.AbstractZkLedgerManagerFactory;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.MSLedgerManagerFactory;
import org.apache.bookkeeper.meta.ZkLayoutManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.BookieLedgerIndexer;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieLedgerIndexTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BookieLedgerIndexTest.class);
    private Random rng;
    private ArrayList<byte[]> entries;
    private final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    private int numberOfLedgers = 3;
    private List<Long> ledgerList;
    private LedgerManagerFactory newLedgerManagerFactory;
    private LedgerManager ledgerManager;

    public BookieLedgerIndexTest() throws IOException, KeeperException, InterruptedException {
        this("org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory");
    }

    BookieLedgerIndexTest(String ledgerManagerFactory) throws IOException, KeeperException, InterruptedException {
        super(3);
        LOG.info("Running test case using ledger manager : " + ledgerManagerFactory);
        this.baseConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
        this.baseClientConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.rng = new Random(System.currentTimeMillis());
        this.entries = new ArrayList();
        this.ledgerList = new ArrayList<Long>(3);
        this.newLedgerManagerFactory = AbstractZkLedgerManagerFactory.newLedgerManagerFactory((AbstractConfiguration)this.baseConf, (LayoutManager)new ZkLayoutManager(this.zkc, ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseConf), ZkUtils.getACLs((AbstractConfiguration)this.baseConf)));
        this.ledgerManager = this.newLedgerManagerFactory.newLedgerManager();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (null != this.newLedgerManagerFactory) {
            this.newLedgerManagerFactory.close();
            this.newLedgerManagerFactory = null;
        }
        if (null != this.ledgerManager) {
            this.ledgerManager.close();
            this.ledgerManager = null;
        }
    }

    @Test
    public void testSimpleBookieLedgerMapping() throws Exception {
        for (int i = 0; i < this.numberOfLedgers; ++i) {
            this.createAndAddEntriesToLedger().close();
        }
        BookieLedgerIndexer bookieLedgerIndex = new BookieLedgerIndexer(this.ledgerManager);
        Map bookieToLedgerIndex = bookieLedgerIndex.getBookieToLedgerIndex();
        Assert.assertEquals((String)"Missed few bookies in the bookie-ledger mapping!", (long)3L, (long)bookieToLedgerIndex.size());
        Collection bk2ledgerEntry = bookieToLedgerIndex.values();
        for (Set ledgers : bk2ledgerEntry) {
            Assert.assertEquals((String)"Missed few ledgers in the bookie-ledger mapping!", (long)3L, (long)ledgers.size());
            for (Long ledgerId : ledgers) {
                Assert.assertTrue((String)"Unknown ledger-bookie mapping", (boolean)this.ledgerList.contains(ledgerId));
            }
        }
    }

    @Test
    public void testWithoutZookeeper() throws Exception {
        if (this.newLedgerManagerFactory instanceof MSLedgerManagerFactory) {
            return;
        }
        for (int i = 0; i < this.numberOfLedgers; ++i) {
            this.createAndAddEntriesToLedger().close();
        }
        BookieLedgerIndexer bookieLedgerIndex = new BookieLedgerIndexer(this.ledgerManager);
        this.stopZKCluster();
        try {
            bookieLedgerIndex.getBookieToLedgerIndex();
            Assert.fail((String)"Must throw exception as zookeeper are not running!");
        }
        catch (ReplicationException.BKAuditException bKAuditException) {
            // empty catch block
        }
    }

    @Test
    public void testEnsembleReformation() throws Exception {
        try {
            LedgerHandle lh1 = this.createAndAddEntriesToLedger();
            LedgerHandle lh2 = this.createAndAddEntriesToLedger();
            this.startNewBookie();
            this.shutdownBookie(this.bs.size() - 2);
            for (int i = 0; i < 10; ++i) {
                ByteBuffer entry = ByteBuffer.allocate(4);
                entry.putInt(this.rng.nextInt(Integer.MAX_VALUE));
                entry.position(0);
                this.entries.add(entry.array());
                lh1.addEntry(entry.array());
                lh2.addEntry(entry.array());
            }
            BookieLedgerIndexer bookieLedgerIndex = new BookieLedgerIndexer(this.ledgerManager);
            Map bookieToLedgerIndex = bookieLedgerIndex.getBookieToLedgerIndex();
            Assert.assertEquals((String)"Missed few bookies in the bookie-ledger mapping!", (long)4L, (long)bookieToLedgerIndex.size());
            Collection bk2ledgerEntry = bookieToLedgerIndex.values();
            for (Set ledgers : bk2ledgerEntry) {
                Assert.assertEquals((String)"Missed few ledgers in the bookie-ledger mapping!", (long)2L, (long)ledgers.size());
                for (Long ledgerNode : ledgers) {
                    Assert.assertTrue((String)"Unknown ledger-bookie mapping", (boolean)this.ledgerList.contains(ledgerNode));
                }
            }
        }
        catch (BKException e) {
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to BookKeeper exception");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to interruption");
        }
    }

    private void shutdownBookie(int bkShutdownIndex) throws IOException {
        ((BookieServer)this.bs.remove(bkShutdownIndex)).shutdown();
        File f = (File)this.tmpDirs.remove(bkShutdownIndex);
        FileUtils.deleteDirectory((File)f);
    }

    private LedgerHandle createAndAddEntriesToLedger() throws BKException, InterruptedException {
        int numEntriesToWrite = 20;
        LedgerHandle lh = this.bkc.createLedger(this.digestType, "admin".getBytes());
        LOG.info("Ledger ID: " + lh.getId());
        for (int i = 0; i < numEntriesToWrite; ++i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(Integer.MAX_VALUE));
            entry.position(0);
            this.entries.add(entry.array());
            lh.addEntry(entry.array());
        }
        this.ledgerList.add(lh.getId());
        return lh;
    }
}

