/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerHandleAdapter;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.replication.ReplicationTestUtil;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAutoRecoveryAlongWithBookieServers
extends BookKeeperClusterTestCase {
    private String basePath = "";

    public TestAutoRecoveryAlongWithBookieServers() {
        super(3);
        this.setAutoRecoveryEnabled(true);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.basePath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseClientConf) + '/' + "underreplication" + "/ledgers";
    }

    @Test
    public void testAutoRecoveryAlongWithBookieServers() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, "testpasswd".getBytes());
        byte[] testData = "testBuiltAutoRecovery".getBytes();
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(testData);
        }
        lh.close();
        BookieSocketAddress replicaToKill = (BookieSocketAddress)((ArrayList)LedgerHandleAdapter.getLedgerMetadata(lh).getEnsembles().get(0L)).get(0);
        this.killBookie(replicaToKill);
        BookieSocketAddress newBkAddr = this.startNewBookieAndReturnAddress();
        while (ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath)) {
            Thread.sleep(100L);
        }
        Set entrySet = LedgerHandleAdapter.getLedgerMetadata(lh).getEnsembles().entrySet();
        for (Map.Entry entry : entrySet) {
            ArrayList bookies = (ArrayList)entry.getValue();
            for (BookieSocketAddress bookie : bookies) {
                if (bookie.equals((Object)newBkAddr)) continue;
                this.killBookie(bookie);
            }
        }
        LedgerHandle lhs = this.bkc.openLedgerNoRecovery(lh.getId(), BookKeeper.DigestType.CRC32, "testpasswd".getBytes());
        Enumeration entries = lhs.readEntries(0L, 9L);
        Assert.assertTrue((String)"Should have the elements", (boolean)entries.hasMoreElements());
        while (entries.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)entries.nextElement();
            Assert.assertEquals((Object)"testBuiltAutoRecovery", (Object)new String(entry.getEntry()));
        }
    }
}

