/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.sasl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.login.Configuration;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.sasl.SASLBookieAuthProviderFactory;
import org.apache.bookkeeper.sasl.SASLClientProviderFactory;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSSAPIBookKeeperTest
extends BookKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(GSSAPIBookKeeperTest.class);
    private static final byte[] PASSWD = "testPasswd".getBytes();
    private static final byte[] ENTRY = "TestEntry".getBytes();
    private MiniKdc kdc;
    private Properties conf;
    @Rule
    public TemporaryFolder kdcDir = new TemporaryFolder();
    @Rule
    public TemporaryFolder kerberosWorkDir = new TemporaryFolder();

    @Before
    public void startMiniKdc() throws Exception {
        this.conf = MiniKdc.createConf();
        this.kdc = new MiniKdc(this.conf, this.kdcDir.getRoot());
        this.kdc.start();
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setUseHostNameAsBookieID(true);
        String localhostName = Bookie.getBookieAddress((ServerConfiguration)bookieConf).getHostName();
        String principalServerNoRealm = "bookkeeper/" + localhostName;
        String principalServer = "bookkeeper/" + localhostName + "@" + this.kdc.getRealm();
        LOG.info("principalServer: " + principalServer);
        String principalClientNoRealm = "bookkeeperclient/" + localhostName;
        String principalClient = principalClientNoRealm + "@" + this.kdc.getRealm();
        LOG.info("principalClient: " + principalClient);
        File keytabClient = new File(this.kerberosWorkDir.getRoot(), "bookkeeperclient.keytab");
        this.kdc.createPrincipal(keytabClient, new String[]{principalClientNoRealm});
        File keytabServer = new File(this.kerberosWorkDir.getRoot(), "bookkeeperserver.keytab");
        this.kdc.createPrincipal(keytabServer, new String[]{principalServerNoRealm});
        File jaasFile = new File(this.kerberosWorkDir.getRoot(), "jaas.conf");
        try (FileWriter writer = new FileWriter(jaasFile);){
            writer.write("\nBookie {\n  com.sun.security.auth.module.Krb5LoginModule required debug=true\n  useKeyTab=true\n  keyTab=\"" + keytabServer.getAbsolutePath() + "\n  storeKey=true\n  useTicketCache=false\n  principal=\"" + principalServer + "\";\n};\n\n\n\nBookKeeper {\n  com.sun.security.auth.module.Krb5LoginModule required debug=true\n  useKeyTab=true\n  keyTab=\"" + keytabClient.getAbsolutePath() + "\n  storeKey=true\n  useTicketCache=false\n  principal=\"" + principalClient + "\";\n};\n");
        }
        File krb5file = new File(this.kerberosWorkDir.getRoot(), "krb5.conf");
        try (FileWriter writer = new FileWriter(krb5file);){
            writer.write("[libdefaults]\n default_realm = " + this.kdc.getRealm() + "\n\n\n[realms]\n " + this.kdc.getRealm() + "  = {\n  kdc = " + this.kdc.getHost() + ":" + this.kdc.getPort() + "\n }");
        }
        System.setProperty("java.security.auth.login.config", jaasFile.getAbsolutePath());
        System.setProperty("java.security.krb5.conf", krb5file.getAbsolutePath());
        Configuration.getConfiguration().refresh();
    }

    @After
    public void stopMiniKdc() {
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty("java.security.krb5.conf");
        if (this.kdc != null) {
            this.kdc.stop();
        }
    }

    public GSSAPIBookKeeperTest() {
        super(0);
    }

    private void connectAndWriteToBookie(ClientConfiguration conf, AtomicLong ledgerWritten) throws BKException, InterruptedException, IOException, KeeperException {
        LOG.info("Connecting to bookie");
        try (BookKeeper bkc = new BookKeeper(conf, this.zkc);){
            LedgerHandle l = bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, PASSWD);
            ledgerWritten.set(l.getId());
            l.addEntry(ENTRY);
            l.close();
        }
    }

    /*
     * Exception decompiling
     */
    private int entryCount(long ledgerId, ClientConfiguration clientConf) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testSingleMessageAuth() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setUseHostNameAsBookieID(true);
        bookieConf.setBookieAuthProviderFactoryClass(SASLBookieAuthProviderFactory.class.getName());
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SASLClientProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        this.connectAndWriteToBookie(clientConf, ledgerId);
        Assert.assertFalse((ledgerId.get() == -1L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should have entry", (long)1L, (long)this.entryCount(ledgerId.get(), clientConf));
    }

    @Test
    public void testNotAllowedClientId() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setUseHostNameAsBookieID(true);
        bookieConf.setBookieAuthProviderFactoryClass(SASLBookieAuthProviderFactory.class.getName());
        bookieConf.setProperty("saslJaasClientAllowedIds", (Object)"nobody");
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SASLClientProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        try {
            this.connectAndWriteToBookie(clientConf, ledgerId);
            Assert.fail((String)"should not be able to access the bookie");
        }
        catch (BKException.BKUnauthorizedAccessException bKUnauthorizedAccessException) {
            // empty catch block
        }
    }

    BookieServer startAndStoreBookie(ServerConfiguration conf) throws Exception {
        this.bsConfs.add(conf);
        BookieServer s = this.startBookie(conf);
        this.bs.add(s);
        return s;
    }

    @AfterClass
    public static void resetJAAS() {
        System.clearProperty("java.security.auth.login.config");
        Configuration.getConfiguration().refresh();
    }
}

