/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.ByteBufList;
import org.apache.bookkeeper.util.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BookieClientTest {
    BookieServer bs;
    File tmpDir;
    public int port = 13645;
    public EventLoopGroup eventLoopGroup;
    public OrderedExecutor executor;
    private ScheduledExecutorService scheduler;
    BookkeeperInternalCallbacks.ReadEntryCallback recb = new BookkeeperInternalCallbacks.ReadEntryCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf bb, Object ctx) {
            ResultStruct rs;
            ResultStruct resultStruct = rs = (ResultStruct)ctx;
            synchronized (resultStruct) {
                rs.rc = rc;
                if (0 == rc && bb != null) {
                    bb.readerIndex(24);
                    rs.entry = bb.nioBuffer();
                }
                rs.notifyAll();
            }
        }
    };
    BookkeeperInternalCallbacks.WriteCallback wrcb = new BookkeeperInternalCallbacks.WriteCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeComplete(int rc, long ledgerId, long entryId, BookieSocketAddress addr, Object ctx) {
            if (ctx != null) {
                Object object = ctx;
                synchronized (object) {
                    if (ctx instanceof ResultStruct) {
                        ResultStruct rs = (ResultStruct)ctx;
                        rs.rc = rc;
                    }
                    ctx.notifyAll();
                }
            }
        }
    };

    @Before
    public void setUp() throws Exception {
        this.tmpDir = IOUtils.createTempDir((String)"bookieClient", (String)"test");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setBookiePort(this.port).setJournalDirName(this.tmpDir.getPath()).setLedgerDirNames(new String[]{this.tmpDir.getPath()}).setMetadataServiceUri(null);
        this.bs = new BookieServer(conf);
        this.bs.start();
        this.eventLoopGroup = new NioEventLoopGroup();
        this.executor = OrderedExecutor.newBuilder().name("BKClientOrderedSafeExecutor").numThreads(2).build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("BookKeeperClientScheduler"));
    }

    @After
    public void tearDown() throws Exception {
        this.scheduler.shutdown();
        this.bs.shutdown();
        BookieClientTest.recursiveDelete(this.tmpDir);
        this.eventLoopGroup.shutdownGracefully();
        this.executor.shutdown();
    }

    private static void recursiveDelete(File dir) {
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                BookieClientTest.recursiveDelete(child);
            }
        }
        dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteGaps() throws Exception {
        Object notifyObject = new Object();
        byte[] passwd = new byte[20];
        Arrays.fill(passwd, (byte)97);
        BookieSocketAddress addr = this.bs.getLocalAddress();
        ResultStruct arc = new ResultStruct();
        BookieClient bc = new BookieClient(new ClientConfiguration(), this.eventLoopGroup, this.executor, this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE);
        ByteBufList bb = this.createByteBuffer(1, 1L, 1L);
        bc.addEntry(addr, 1L, passwd, 1L, bb, this.wrcb, (Object)arc, 0);
        Object object = arc;
        synchronized (object) {
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            bc.readEntry(addr, 1L, 1L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((long)1L, (long)arc.entry.getInt());
        }
        bb = this.createByteBuffer(2, 1L, 2L);
        bc.addEntry(addr, 1L, passwd, 2L, bb, this.wrcb, null, 0);
        bb = this.createByteBuffer(3, 1L, 3L);
        bc.addEntry(addr, 1L, passwd, 3L, bb, this.wrcb, null, 0);
        bb = this.createByteBuffer(5, 1L, 5L);
        bc.addEntry(addr, 1L, passwd, 5L, bb, this.wrcb, null, 0);
        bb = this.createByteBuffer(7, 1L, 7L);
        bc.addEntry(addr, 1L, passwd, 7L, bb, this.wrcb, null, 0);
        object = notifyObject;
        synchronized (object) {
            bb = this.createByteBuffer(11, 1L, 11L);
            bc.addEntry(addr, 1L, passwd, 11L, bb, this.wrcb, notifyObject, 0);
            notifyObject.wait();
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 6L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)-13L, (long)arc.rc);
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 7L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((float)7.0f, (float)arc.entry.getInt(), (float)0.0f);
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 1L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((long)1L, (long)arc.entry.getInt());
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 2L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((long)2L, (long)arc.entry.getInt());
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 3L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((long)3L, (long)arc.entry.getInt());
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 4L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)-13L, (long)arc.rc);
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 11L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((long)11L, (long)arc.entry.getInt());
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 5L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((long)5L, (long)arc.entry.getInt());
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 10L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)-13L, (long)arc.rc);
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 12L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)-13L, (long)arc.rc);
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 13L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)-13L, (long)arc.rc);
        }
    }

    private ByteBufList createByteBuffer(int i, long lid, long eid) {
        ByteBuf bb = Unpooled.buffer((int)28);
        bb.writeLong(lid);
        bb.writeLong(eid);
        bb.writeLong(eid - 1L);
        bb.writeInt(i);
        return ByteBufList.get((ByteBuf)bb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoLedger() throws Exception {
        ResultStruct arc = new ResultStruct();
        BookieSocketAddress addr = this.bs.getLocalAddress();
        BookieClient bc = new BookieClient(new ClientConfiguration(), this.eventLoopGroup, this.executor, this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE);
        ResultStruct resultStruct = arc;
        synchronized (resultStruct) {
            bc.readEntry(addr, 2L, 13L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)-7L, (long)arc.rc);
        }
    }

    @Test
    public void testGetBookieInfo() throws IOException, InterruptedException {
        BookieSocketAddress addr = this.bs.getLocalAddress();
        BookieClient bc = new BookieClient(new ClientConfiguration(), (EventLoopGroup)new NioEventLoopGroup(), this.executor, this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE);
        long flags = 3L;
        class CallbackObj {
            int rc;
            long requested;
            long freeDiskSpace;
            long totalDiskCapacity;
            CountDownLatch latch = new CountDownLatch(1);

            CallbackObj(long requested) {
                this.requested = requested;
                this.rc = 0;
                this.freeDiskSpace = 0L;
                this.totalDiskCapacity = 0L;
            }
        }
        CallbackObj obj = new CallbackObj(flags);
        bc.getBookieInfo(addr, flags, new BookkeeperInternalCallbacks.GetBookieInfoCallback(){

            public void getBookieInfoComplete(int rc, BookieInfoReader.BookieInfo bInfo, Object ctx) {
                CallbackObj obj = (CallbackObj)ctx;
                obj.rc = rc;
                if (rc == 0) {
                    if ((obj.requested & 2L) != 0L) {
                        obj.freeDiskSpace = bInfo.getFreeDiskSpace();
                    }
                    if ((obj.requested & 1L) != 0L) {
                        obj.totalDiskCapacity = bInfo.getTotalDiskSpace();
                    }
                }
                obj.latch.countDown();
            }
        }, (Object)obj);
        obj.latch.await();
        System.out.println("Return code: " + obj.rc + "FreeDiskSpace: " + obj.freeDiskSpace + " TotalCapacity: " + obj.totalDiskCapacity);
        Assert.assertTrue((String)("GetBookieInfo failed with error " + obj.rc), (obj.rc == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("GetBookieInfo failed with error " + obj.rc), (obj.freeDiskSpace <= obj.totalDiskCapacity ? 1 : 0) != 0);
        Assert.assertTrue((String)("GetBookieInfo failed with error " + obj.rc), (obj.totalDiskCapacity > 0L ? 1 : 0) != 0);
    }

    static class ResultStruct {
        int rc = -123456;
        ByteBuffer entry;

        ResultStruct() {
        }
    }
}

