/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerDeleteTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerDeleteTest.class);
    BookKeeper.DigestType digestType;

    public LedgerDeleteTest() {
        this("org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory");
    }

    LedgerDeleteTest(String ledgerManagerFactory) {
        super(1);
        LOG.info("Running test case using ledger manager : " + ledgerManagerFactory);
        this.digestType = BookKeeper.DigestType.CRC32;
        this.baseConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
        this.baseClientConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.baseConf.setEntryLogSizeLimit(0x200000L);
        this.baseConf.setGcWaitTime(1000L);
        this.baseConf.setEntryLogFilePreAllocationEnabled(false);
        this.baseConf.setLedgerStorageClass(InterleavedLedgerStorage.class.getName());
        super.setUp();
    }

    private LedgerHandle[] writeLedgerEntries(int numLedgers, int msgSize, int numMsgs) throws Exception {
        LedgerHandle[] lhs = new LedgerHandle[numLedgers];
        for (int i = 0; i < numLedgers; ++i) {
            lhs[i] = this.bkc.createLedger(1, 1, this.digestType, "".getBytes());
        }
        StringBuilder msgSB = new StringBuilder();
        for (int i = 0; i < msgSize; ++i) {
            msgSB.append("a");
        }
        String msg = msgSB.toString();
        final CountDownLatch completeLatch = new CountDownLatch(numMsgs * numLedgers);
        final AtomicInteger rc = new AtomicInteger(0);
        for (int i = 0; i < numMsgs; ++i) {
            for (int j = 0; j < numLedgers; ++j) {
                lhs[j].asyncAddEntry(msg.getBytes(), new AsyncCallback.AddCallback(){

                    public void addComplete(int rc2, LedgerHandle lh, long entryId, Object ctx) {
                        rc.compareAndSet(0, rc2);
                        completeLatch.countDown();
                    }
                }, null);
            }
        }
        completeLatch.await();
        if (rc.get() != 0) {
            throw BKException.create((int)rc.get());
        }
        return lhs;
    }

    @Test
    public void testLedgerDelete() throws Exception {
        LedgerHandle[] lhs = this.writeLedgerEntries(3, 1024, 1024);
        this.restartBookies();
        for (LedgerHandle lh : lhs) {
            this.bkc.deleteLedger(lh.getId());
        }
        LOG.info("Finished deleting all ledgers so waiting for the GC thread to clean up the entryLogs");
        Thread.sleep(2000L);
        for (File ledgerDirectory : this.tmpDirs) {
            Assert.assertFalse((String)("Found the entry log file (0.log) that should have been deleted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0));
        }
    }

    @Test
    public void testLedgerDeleteWithExistingEntryLogs() throws Exception {
        LedgerHandle[] lhs = this.writeLedgerEntries(3, 1024, 1024);
        this.restartBookies();
        for (LedgerHandle lh : lhs) {
            this.bkc.deleteLedger(lh.getId());
        }
        LOG.info("Finished deleting all ledgers so waiting for the GC thread to clean up the entryLogs");
        Thread.sleep(2L * this.baseConf.getGcWaitTime());
        for (File ledgerDirectory : this.tmpDirs) {
            Assert.assertFalse((String)("Found the entry log file ([0,1].log) that should have been deleted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0, 1));
        }
    }
}

