/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import com.google.common.util.concurrent.AbstractFuture;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCallbacks {
    private static final Logger logger = LoggerFactory.getLogger(TestCallbacks.class);

    public static class AddCallbackFuture
    extends AbstractFuture<Long>
    implements AsyncCallback.AddCallback {
        private final long expectedEntryId;

        public AddCallbackFuture(long entryId) {
            this.expectedEntryId = entryId;
        }

        public long getExpectedEntryId() {
            return this.expectedEntryId;
        }

        public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
            logger.info("Add entry {} completed : entryId = {}, rc = {}", new Object[]{this.expectedEntryId, entryId, rc});
            if (rc != 0) {
                this.setException((Throwable)BKException.create((int)rc));
            } else {
                this.set(entryId);
            }
        }
    }

    public static class GenericCallbackFuture<T>
    extends CompletableFuture<T>
    implements BookkeeperInternalCallbacks.GenericCallback<T> {
        public void operationComplete(int rc, T value) {
            if (rc != 0) {
                this.completeExceptionally((Throwable)BKException.create((int)rc));
            } else {
                this.complete(value);
            }
        }
    }
}

