/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsData;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.commons.configuration.Configuration;

public class TestStatsProvider
implements StatsProvider {
    private Map<String, TestOpStatsLogger> opStatLoggerMap = new ConcurrentHashMap<String, TestOpStatsLogger>();
    private Map<String, TestCounter> counterMap = new ConcurrentHashMap<String, TestCounter>();
    private Map<String, Gauge<? extends Number>> gaugeMap = new ConcurrentHashMap<String, Gauge<? extends Number>>();

    public void start(Configuration conf) {
    }

    public void stop() {
    }

    public TestStatsLogger getStatsLogger(String scope) {
        return new TestStatsLogger(scope);
    }

    public TestOpStatsLogger getOpStatsLogger(String path) {
        return this.opStatLoggerMap.get(path);
    }

    public TestCounter getCounter(String path) {
        return this.counterMap.get(path);
    }

    public Gauge<? extends Number> getGauge(String path) {
        return this.gaugeMap.get(path);
    }

    public void forEachOpStatLogger(BiConsumer<String, TestOpStatsLogger> f) {
        for (Map.Entry<String, TestOpStatsLogger> entry : this.opStatLoggerMap.entrySet()) {
            f.accept(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        for (TestOpStatsLogger logger : this.opStatLoggerMap.values()) {
            logger.clear();
        }
        for (TestCounter counter : this.counterMap.values()) {
            counter.clear();
        }
    }

    private TestOpStatsLogger getOrCreateOpStatsLogger(String path) {
        return this.opStatLoggerMap.computeIfAbsent(path, s -> new TestOpStatsLogger());
    }

    private TestCounter getOrCreateCounter(String path) {
        return this.counterMap.computeIfAbsent(path, s -> new TestCounter());
    }

    private <T extends Number> void registerGauge(String name, Gauge<T> gauge) {
        this.gaugeMap.put(name, gauge);
    }

    private <T extends Number> void unregisterGauge(String name, Gauge<T> gauge) {
        this.gaugeMap.remove(name, gauge);
    }

    public class TestStatsLogger
    implements StatsLogger {
        private String path;

        TestStatsLogger(String path) {
            this.path = path;
        }

        private String getSubPath(String name) {
            if (this.path.isEmpty()) {
                return name;
            }
            return this.path + "." + name;
        }

        public OpStatsLogger getOpStatsLogger(String name) {
            return TestStatsProvider.this.getOrCreateOpStatsLogger(this.getSubPath(name));
        }

        public Counter getCounter(String name) {
            return TestStatsProvider.this.getOrCreateCounter(this.getSubPath(name));
        }

        public <T extends Number> void registerGauge(String name, Gauge<T> gauge) {
            TestStatsProvider.this.registerGauge(this.getSubPath(name), gauge);
        }

        public <T extends Number> void unregisterGauge(String name, Gauge<T> gauge) {
            TestStatsProvider.this.unregisterGauge(this.getSubPath(name), gauge);
        }

        public StatsLogger scope(String name) {
            return new TestStatsLogger(this.getSubPath(name));
        }

        public void removeScope(String name, StatsLogger statsLogger) {
        }
    }

    public class TestOpStatsLogger
    implements OpStatsLogger {
        private long successCount;
        private long successValue;
        private long failureCount;
        private long failureValue;

        TestOpStatsLogger() {
            this.clear();
        }

        public void registerFailedEvent(long eventLatency, TimeUnit unit) {
            this.registerFailedValue(unit.convert(eventLatency, TimeUnit.NANOSECONDS));
        }

        public void registerSuccessfulEvent(long eventLatency, TimeUnit unit) {
            this.registerSuccessfulValue(unit.convert(eventLatency, TimeUnit.NANOSECONDS));
        }

        public synchronized void registerSuccessfulValue(long value) {
            ++this.successCount;
            this.successValue += value;
        }

        public synchronized void registerFailedValue(long value) {
            ++this.failureCount;
            this.failureValue += value;
        }

        public OpStatsData toOpStatsData() {
            return null;
        }

        public synchronized void clear() {
            this.successCount = 0L;
            this.successValue = 0L;
            this.failureCount = 0L;
            this.failureValue = 0L;
        }

        public synchronized double getSuccessAverage() {
            if (this.successCount == 0L) {
                return 0.0;
            }
            return (double)this.successValue / (double)this.successCount;
        }

        public synchronized long getSuccessCount() {
            return this.successCount;
        }
    }

    public class TestCounter
    implements Counter {
        private AtomicLong val = new AtomicLong(0L);
        private AtomicLong max = new AtomicLong(0L);

        public void clear() {
            this.val.set(0L);
        }

        public void inc() {
            this.updateMax(this.val.incrementAndGet());
        }

        public void dec() {
            this.val.decrementAndGet();
        }

        public void add(long delta) {
            this.updateMax(this.val.addAndGet(delta));
        }

        public Long get() {
            return this.val.get();
        }

        private void updateMax(long newVal) {
            long curMax;
            while ((curMax = this.max.get()) <= newVal && !this.max.compareAndSet(curMax, newVal)) {
            }
        }

        public Long getMax() {
            return this.max.get();
        }
    }
}

