/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.bookkeeper.zookeeper.ZooKeeperWatcherBase;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Transaction;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperUtil {
    static final Logger LOG;
    protected Integer zooKeeperPort = 0;
    private InetSocketAddress zkaddr;
    protected ZooKeeperServer zks;
    protected ZooKeeper zkc;
    protected NIOServerCnxnFactory serverFactory;
    protected File zkTmpDir;
    private String connectString;

    public ZooKeeperUtil() {
        String loopbackIPAddr = InetAddress.getLoopbackAddress().getHostAddress();
        this.zkaddr = new InetSocketAddress(loopbackIPAddr, 0);
        this.connectString = loopbackIPAddr + ":" + this.zooKeeperPort;
    }

    public ZooKeeper getZooKeeperClient() {
        return this.zkc;
    }

    public String getZooKeeperConnectString() {
        return this.connectString;
    }

    public String getMetadataServiceUri() {
        return this.getMetadataServiceUri("/ledgers");
    }

    public String getMetadataServiceUri(String zkLedgersRootPath) {
        return "zk://" + this.connectString + zkLedgersRootPath;
    }

    public String getMetadataServiceUri(String zkLedgersRootPath, String type) {
        return "zk+" + type + "://" + this.connectString + zkLedgersRootPath;
    }

    public void startServer() throws Exception {
        LOG.debug("Running ZK server");
        ClientBase.setupTestEnv();
        this.zkTmpDir = IOUtils.createTempDir((String)"zookeeper", (String)"test");
        this.restartServer();
        this.createBKEnsemble("/ledgers");
    }

    public void createBKEnsemble(String ledgersPath) throws KeeperException, InterruptedException {
        Transaction txn = this.zkc.transaction();
        txn.create(ledgersPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        txn.create(ledgersPath + "/" + "available", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        txn.create(ledgersPath + "/" + "available" + "/" + "readonly", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        txn.commit();
    }

    public void restartServer() throws Exception {
        this.zks = new ZooKeeperServer(this.zkTmpDir, this.zkTmpDir, 3000);
        this.serverFactory = new NIOServerCnxnFactory();
        this.serverFactory.configure(this.zkaddr, 100);
        this.serverFactory.startup(this.zks);
        if (0 == this.zooKeeperPort) {
            this.zooKeeperPort = this.serverFactory.getLocalPort();
            this.zkaddr = new InetSocketAddress(this.zkaddr.getHostName(), (int)this.zooKeeperPort);
            this.connectString = this.zkaddr.getHostName() + ":" + this.zooKeeperPort;
        }
        boolean b = ClientBase.waitForServerUp((String)this.getZooKeeperConnectString(), (long)ClientBase.CONNECTION_TIMEOUT);
        LOG.debug("Server up: " + b);
        LOG.debug("Instantiate ZK Client");
        this.zkc = ZooKeeperClient.newBuilder().connectString(this.getZooKeeperConnectString()).sessionTimeoutMs(10000).build();
    }

    public void sleepServer(final int time, final TimeUnit timeUnit, final CountDownLatch l) throws InterruptedException, IOException {
        Thread[] allthreads = new Thread[Thread.activeCount()];
        Thread.enumerate(allthreads);
        for (final Thread t : allthreads) {
            if (!t.getName().contains("SyncThread:0")) continue;
            Thread sleeper = new Thread(){

                @Override
                public void run() {
                    try {
                        t.suspend();
                        l.countDown();
                        timeUnit.sleep(time);
                        t.resume();
                    }
                    catch (Exception e) {
                        LOG.error("Error suspending thread", (Throwable)e);
                    }
                }
            };
            sleeper.start();
            return;
        }
        throw new IOException("ZooKeeper thread not found");
    }

    public void expireSession(ZooKeeper zk) throws Exception {
        long id = zk.getSessionId();
        byte[] password = zk.getSessionPasswd();
        ZooKeeperWatcherBase w = new ZooKeeperWatcherBase(10000);
        ZooKeeper zk2 = new ZooKeeper(this.getZooKeeperConnectString(), zk.getSessionTimeout(), (Watcher)w, id, password);
        w.waitForConnection();
        zk2.close();
    }

    public void stopServer() throws Exception {
        if (this.zkc != null) {
            this.zkc.close();
        }
        if (this.serverFactory != null) {
            this.serverFactory.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown((String)this.getZooKeeperConnectString(), (long)ClientBase.CONNECTION_TIMEOUT));
        }
        if (this.zks != null) {
            this.zks.getTxnLogFactory().close();
        }
    }

    public void killServer() throws Exception {
        this.stopServer();
        FileUtils.deleteDirectory((File)this.zkTmpDir);
    }

    static {
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        LOG = LoggerFactory.getLogger(ZooKeeperUtil.class);
    }
}

