/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.io.File;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestUtils {
    private static final Logger log = LoggerFactory.getLogger(TestUtils.class);

    private TestUtils() {
    }

    public static boolean hasLogFiles(File ledgerDirectory, boolean partial, Integer ... logsId) {
        boolean result = !partial;
        HashSet<Integer> logs = new HashSet<Integer>();
        for (File file : Bookie.getCurrentDirectory((File)ledgerDirectory).listFiles()) {
            String name;
            if (!file.isFile() || !(name = file.getName()).endsWith(".log")) continue;
            logs.add(Integer.parseInt(name.split("\\.")[0], 16));
        }
        for (Comparable<File> comparable : logsId) {
            boolean exist = logs.contains(comparable);
            if ((!partial || !exist) && (partial || exist)) continue;
            return !result;
        }
        return result;
    }

    public static void waitUntilLacUpdated(ReadHandle rh, long newLac) throws Exception {
        long lac = rh.getLastAddConfirmed();
        while (lac < newLac) {
            TimeUnit.MILLISECONDS.sleep(20L);
            lac = rh.readLastAddConfirmed();
        }
    }

    public static long waitUntilExplicitLacUpdated(LedgerHandle rh, long newLac) throws Exception {
        long lac;
        while ((lac = rh.readExplicitLastConfirmed()) < newLac) {
            TimeUnit.MILLISECONDS.sleep(20L);
        }
        return lac;
    }
}

