/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.bookkeeper.util.ZeroBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestZeroBuffer {
    @Test
    public void testPut() {
        Random rand = new Random();
        ByteBuffer testBuffer = ByteBuffer.allocate(5);
        byte[] testBufferArray = testBuffer.array();
        testBufferArray[4] = 7;
        Assert.assertFalse((String)"Test1 - It is supposed to contain non-zero byte", (boolean)this.isFilledWithZeros(testBufferArray, 0, 5));
        ZeroBuffer.put((ByteBuffer)testBuffer);
        Assert.assertTrue((String)"Test1 - After calling, ZeroBuffer.put There aren't supposed to be non-zero bytes", (boolean)this.isFilledWithZeros(testBufferArray, 0, 5));
        testBuffer = ByteBuffer.allocate(65536);
        testBufferArray = testBuffer.array();
        rand.nextBytes(testBufferArray);
        Assert.assertFalse((String)"Test2 - It is supposed to contain random non-zero bytes", (boolean)this.isFilledWithZeros(testBufferArray, 0, 65536));
        ZeroBuffer.put((ByteBuffer)testBuffer);
        Assert.assertTrue((String)"Test2 - After calling, ZeroBuffer.put There aren't supposed to be non-zero bytes", (boolean)this.isFilledWithZeros(testBufferArray, 0, 65536));
        testBuffer = ByteBuffer.allocate(262144);
        testBufferArray = testBuffer.array();
        rand.nextBytes(testBufferArray);
        Assert.assertFalse((String)"Test3 - It is supposed to contain random non-zero bytes", (boolean)this.isFilledWithZeros(testBufferArray, 65536, 65536));
        testBuffer.position(65536);
        ZeroBuffer.put((ByteBuffer)testBuffer, (int)65536);
        Assert.assertTrue((String)"Test3 - After calling, ZeroBuffer.put There aren't supposed to be non-zero bytes in the particular section", (boolean)this.isFilledWithZeros(testBufferArray, 65536, 65536));
        Assert.assertFalse((String)"Test3 - After calling, ZeroBuffer.put other sections shouldnt be touched", (boolean)this.isFilledWithZeros(testBufferArray, 0, 65536));
        Assert.assertFalse((String)"Test3 - After calling, ZeroBuffer.put other sections shouldnt be touched", (boolean)this.isFilledWithZeros(testBufferArray, 131072, 131072));
    }

    @Test
    public void testReadOnlyBuffer() {
        ByteBuffer testReadOnlyBuffer = ZeroBuffer.readOnlyBuffer((int)5);
        Assert.assertTrue((String)("Test1 - ReadOnlyBuffer should have remaining 5 bytes but it has " + testReadOnlyBuffer.remaining()), (testReadOnlyBuffer.remaining() == 5 ? 1 : 0) != 0);
        byte[] testBufferArray = new byte[5];
        testReadOnlyBuffer.get(testBufferArray);
        Assert.assertTrue((String)"Test1 - supposed to contain only zero bytes", (boolean)this.isFilledWithZeros(testBufferArray, 0, 5));
        testReadOnlyBuffer = ZeroBuffer.readOnlyBuffer((int)65536);
        Assert.assertTrue((String)("Test2 - ReadOnlyBuffer should have remaining 64*1024 bytes but it has " + testReadOnlyBuffer.remaining()), (testReadOnlyBuffer.remaining() == 65536 ? 1 : 0) != 0);
        testBufferArray = new byte[65536];
        testReadOnlyBuffer.get(testBufferArray);
        Assert.assertTrue((String)"Test2 - supposed to contain only zero bytes", (boolean)this.isFilledWithZeros(testBufferArray, 0, 65536));
        testReadOnlyBuffer = ZeroBuffer.readOnlyBuffer((int)131072);
        Assert.assertTrue((String)("Test3 - ReadOnlyBuffer should have remaining 128*1024 bytes but it has " + testReadOnlyBuffer.remaining()), (testReadOnlyBuffer.remaining() == 131072 ? 1 : 0) != 0);
        testBufferArray = new byte[131072];
        testReadOnlyBuffer.get(testBufferArray);
        Assert.assertTrue((String)"Test3 - supposed to contain only zero bytes", (boolean)this.isFilledWithZeros(testBufferArray, 0, 131072));
    }

    boolean isFilledWithZeros(byte[] byteArray, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            if (byteArray[i] == 0) continue;
            return false;
        }
        return true;
    }
}

