/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util.collections;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongFunction;
import org.apache.bookkeeper.util.collections.ConcurrentLongHashMap;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentLongHashMapTest {
    static final int Iterations = 1;
    static final int ReadIterations = 100;
    static final int N = 1000000;

    @Test
    public void testConstructor() {
        try {
            new ConcurrentLongHashMap(0);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ConcurrentLongHashMap(16, 0);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ConcurrentLongHashMap(4, 8);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void simpleInsertions() {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(16);
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertNull((Object)map.put(1L, (Object)"one"));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertNull((Object)map.put(2L, (Object)"two"));
        Assert.assertNull((Object)map.put(3L, (Object)"three"));
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((Object)map.get(1L), (Object)"one");
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((Object)map.remove(1L), (Object)"one");
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((Object)map.get(1L), null);
        Assert.assertEquals((Object)map.get(5L), null);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertNull((Object)map.put(1L, (Object)"one"));
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((Object)map.put(1L, (Object)"uno"), (Object)"one");
        Assert.assertEquals((long)map.size(), (long)3L);
    }

    @Test
    public void testRemove() {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertNull((Object)map.put(1L, (Object)"one"));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertFalse((boolean)map.remove(0L, (Object)"zero"));
        Assert.assertFalse((boolean)map.remove(1L, (Object)"uno"));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertTrue((boolean)map.remove(1L, (Object)"one"));
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testRemoveIf() {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(16, 1);
        map.put(1L, (Object)"one");
        map.put(2L, (Object)"two");
        map.put(3L, (Object)"three");
        map.put(4L, (Object)"four");
        map.removeIf((k, v) -> k < 3L);
        Assert.assertFalse((boolean)map.containsKey(1L));
        Assert.assertFalse((boolean)map.containsKey(2L));
        Assert.assertTrue((boolean)map.containsKey(3L));
        Assert.assertTrue((boolean)map.containsKey(4L));
        Assert.assertEquals((long)2L, (long)map.size());
    }

    @Test
    public void testNegativeUsedBucketCount() {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(16, 1);
        map.put(0L, (Object)"zero");
        Assert.assertEquals((long)1L, (long)map.getUsedBucketCount());
        map.put(0L, (Object)"zero1");
        Assert.assertEquals((long)1L, (long)map.getUsedBucketCount());
        map.remove(0L);
        Assert.assertEquals((long)0L, (long)map.getUsedBucketCount());
        map.remove(0L);
        Assert.assertEquals((long)0L, (long)map.getUsedBucketCount());
    }

    @Test
    public void testRehashing() {
        int n = 16;
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(n / 2, 1);
        Assert.assertEquals((long)map.capacity(), (long)n);
        Assert.assertEquals((long)map.size(), (long)0L);
        for (int i = 0; i < n; ++i) {
            map.put((long)i, (Object)i);
        }
        Assert.assertEquals((long)map.capacity(), (long)(2 * n));
        Assert.assertEquals((long)map.size(), (long)n);
    }

    @Test
    public void testRehashingWithDeletes() {
        int i;
        int n = 16;
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(n / 2, 1);
        Assert.assertEquals((long)map.capacity(), (long)n);
        Assert.assertEquals((long)map.size(), (long)0L);
        for (i = 0; i < n / 2; ++i) {
            map.put((long)i, (Object)i);
        }
        for (i = 0; i < n / 2; ++i) {
            map.remove((long)i);
        }
        for (i = n; i < 2 * n; ++i) {
            map.put((long)i, (Object)i);
        }
        Assert.assertEquals((long)map.capacity(), (long)(2 * n));
        Assert.assertEquals((long)map.size(), (long)n);
    }

    @Test
    public void concurrentInsertions() throws Throwable {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int n = 100000;
        String value = "value";
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n2 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key = random.nextLong();
                    key -= key % (long)(threadIdx + 1);
                    map.put(key, (Object)value);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)map.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void concurrentInsertionsAndReads() throws Throwable {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int n = 100000;
        String value = "value";
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n2 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key = random.nextLong();
                    key -= key % (long)(threadIdx + 1);
                    map.put(key, (Object)value);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)map.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void stressConcurrentInsertionsAndReads() throws Throwable {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(4, 1);
        ExecutorService executor = Executors.newCachedThreadPool();
        int writeThreads = 16;
        int readThreads = 16;
        int n = 1000000;
        String value = "value";
        CyclicBarrier barrier = new CyclicBarrier(32);
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n2 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random(threadIdx);
                try {
                    barrier.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                for (int j = 0; j < 1000000; ++j) {
                    long key = random.nextLong();
                    key -= key % (long)(threadIdx + 1);
                    map.put(key, (Object)value);
                }
            }));
        }
        i = 0;
        while (i < 16) {
            int n3 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random(threadIdx);
                try {
                    barrier.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                for (int j = 0; j < 1000000; ++j) {
                    long key = random.nextLong();
                    key -= key % (long)(threadIdx + 1);
                    map.get(key);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)map.size(), (long)16000000L);
        executor.shutdown();
    }

    @Test
    public void testIteration() {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap();
        Assert.assertEquals((Object)map.keys(), Collections.emptyList());
        Assert.assertEquals((Object)map.values(), Collections.emptyList());
        map.put(0L, (Object)"zero");
        Assert.assertEquals((Object)map.keys(), (Object)Lists.newArrayList((Object[])new Long[]{0L}));
        Assert.assertEquals((Object)map.values(), (Object)Lists.newArrayList((Object[])new String[]{"zero"}));
        map.remove(0L);
        Assert.assertEquals((Object)map.keys(), Collections.emptyList());
        Assert.assertEquals((Object)map.values(), Collections.emptyList());
        map.put(0L, (Object)"zero");
        map.put(1L, (Object)"one");
        map.put(2L, (Object)"two");
        List keys = map.keys();
        Collections.sort(keys);
        Assert.assertEquals((Object)keys, (Object)Lists.newArrayList((Object[])new Long[]{0L, 1L, 2L}));
        List values = map.values();
        Collections.sort(values);
        Assert.assertEquals((Object)values, (Object)Lists.newArrayList((Object[])new String[]{"one", "two", "zero"}));
        map.put(1L, (Object)"uno");
        keys = map.keys();
        Collections.sort(keys);
        Assert.assertEquals((Object)keys, (Object)Lists.newArrayList((Object[])new Long[]{0L, 1L, 2L}));
        values = map.values();
        Collections.sort(values);
        Assert.assertEquals((Object)values, (Object)Lists.newArrayList((Object[])new String[]{"two", "uno", "zero"}));
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testHashConflictWithDeletion() {
        int buckets = 16;
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(16, 1);
        long key1 = 1L;
        long key2 = 27L;
        int bucket1 = ConcurrentLongHashMap.signSafeMod((long)ConcurrentLongHashMap.hash((long)key1), (int)16);
        int bucket2 = ConcurrentLongHashMap.signSafeMod((long)ConcurrentLongHashMap.hash((long)key2), (int)16);
        Assert.assertEquals((long)bucket1, (long)bucket2);
        Assert.assertEquals((Object)map.put(key1, (Object)"value-1"), null);
        Assert.assertEquals((Object)map.put(key2, (Object)"value-2"), null);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((Object)map.remove(key1), (Object)"value-1");
        Assert.assertEquals((long)map.size(), (long)1L);
        Assert.assertEquals((Object)map.put(key1, (Object)"value-1-overwrite"), null);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((Object)map.remove(key1), (Object)"value-1-overwrite");
        Assert.assertEquals((long)map.size(), (long)1L);
        Assert.assertEquals((Object)map.put(key2, (Object)"value-2-overwrite"), (Object)"value-2");
        Assert.assertEquals((Object)map.get(key2), (Object)"value-2-overwrite");
        Assert.assertEquals((long)map.size(), (long)1L);
        Assert.assertEquals((Object)map.remove(key2), (Object)"value-2-overwrite");
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testPutIfAbsent() {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap();
        Assert.assertEquals((Object)map.putIfAbsent(1L, (Object)"one"), null);
        Assert.assertEquals((Object)map.get(1L), (Object)"one");
        Assert.assertEquals((Object)map.putIfAbsent(1L, (Object)"uno"), (Object)"one");
        Assert.assertEquals((Object)map.get(1L), (Object)"one");
    }

    @Test
    public void testComputeIfAbsent() {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(16, 1);
        final AtomicInteger counter = new AtomicInteger();
        LongFunction<Integer> provider = new LongFunction<Integer>(){

            @Override
            public Integer apply(long key) {
                return counter.getAndIncrement();
            }
        };
        Assert.assertEquals((long)((Integer)map.computeIfAbsent(0L, (LongFunction)provider)).intValue(), (long)0L);
        Assert.assertEquals((long)((Integer)map.get(0L)).intValue(), (long)0L);
        Assert.assertEquals((long)((Integer)map.computeIfAbsent(1L, (LongFunction)provider)).intValue(), (long)1L);
        Assert.assertEquals((long)((Integer)map.get(1L)).intValue(), (long)1L);
        Assert.assertEquals((long)((Integer)map.computeIfAbsent(1L, (LongFunction)provider)).intValue(), (long)1L);
        Assert.assertEquals((long)((Integer)map.get(1L)).intValue(), (long)1L);
        Assert.assertEquals((long)((Integer)map.computeIfAbsent(2L, (LongFunction)provider)).intValue(), (long)2L);
        Assert.assertEquals((long)((Integer)map.get(2L)).intValue(), (long)2L);
    }

    public void benchConcurrentLongHashMap() throws Exception {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(1000000, 1);
        for (long i = 0L; i < 1L; ++i) {
            int j;
            for (j = 0; j < 1000000; ++j) {
                map.put(i, (Object)"value");
            }
            for (long h = 0L; h < 100L; ++h) {
                for (int j2 = 0; j2 < 1000000; ++j2) {
                    map.get(i);
                }
            }
            for (j = 0; j < 1000000; ++j) {
                map.remove(i);
            }
        }
    }

    public void benchConcurrentHashMap() throws Exception {
        ConcurrentHashMap<Long, String> map = new ConcurrentHashMap<Long, String>(1000000, 0.66f, 1);
        for (long i = 0L; i < 1L; ++i) {
            int j;
            for (j = 0; j < 1000000; ++j) {
                map.put(i, "value");
            }
            for (long h = 0L; h < 100L; ++h) {
                for (int j2 = 0; j2 < 1000000; ++j2) {
                    map.get(i);
                }
            }
            for (j = 0; j < 1000000; ++j) {
                map.remove(i);
            }
        }
    }

    void benchHashMap() throws Exception {
        HashMap<Long, String> map = new HashMap<Long, String>(1000000, 0.66f);
        for (long i = 0L; i < 1L; ++i) {
            int j;
            for (j = 0; j < 1000000; ++j) {
                map.put(i, "value");
            }
            for (long h = 0L; h < 100L; ++h) {
                for (int j2 = 0; j2 < 1000000; ++j2) {
                    map.get(i);
                }
            }
            for (j = 0; j < 1000000; ++j) {
                map.remove(i);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ConcurrentLongHashMapTest t = new ConcurrentLongHashMapTest();
        long start = System.nanoTime();
        long end = System.nanoTime();
        System.out.println("HM:   " + TimeUnit.NANOSECONDS.toMillis(end - start) + " ms");
        start = System.nanoTime();
        t.benchConcurrentHashMap();
        end = System.nanoTime();
        System.out.println("CHM:  " + TimeUnit.NANOSECONDS.toMillis(end - start) + " ms");
        start = System.nanoTime();
        end = System.nanoTime();
        System.out.println("CLHM: " + TimeUnit.NANOSECONDS.toMillis(end - start) + " ms");
    }
}

