/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util.collections;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.util.collections.ConcurrentLongLongHashMap;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentLongLongHashMapTest {
    @Test
    public void testConstructor() {
        try {
            new ConcurrentLongLongHashMap(0);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ConcurrentLongLongHashMap(16, 0);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ConcurrentLongLongHashMap(4, 8);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void simpleInsertions() {
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap(16);
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((long)map.put(1L, 11L), (long)-1L);
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertEquals((long)map.put(2L, 22L), (long)-1L);
        Assert.assertEquals((long)map.put(3L, 33L), (long)-1L);
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((long)map.get(1L), (long)11L);
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((long)map.remove(1L), (long)11L);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((long)map.get(1L), (long)-1L);
        Assert.assertEquals((long)map.get(5L), (long)-1L);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((long)map.put(1L, 11L), (long)-1L);
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((long)map.put(1L, 111L), (long)11L);
        Assert.assertEquals((long)map.size(), (long)3L);
    }

    @Test
    public void testRemove() {
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((long)map.put(1L, 11L), (long)-1L);
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertFalse((boolean)map.remove(0L, 0L));
        Assert.assertFalse((boolean)map.remove(1L, 111L));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertTrue((boolean)map.remove(1L, 11L));
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testNegativeUsedBucketCount() {
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap(16, 1);
        map.put(0L, 0L);
        Assert.assertEquals((long)1L, (long)map.getUsedBucketCount());
        map.put(0L, 1L);
        Assert.assertEquals((long)1L, (long)map.getUsedBucketCount());
        map.remove(0L);
        Assert.assertEquals((long)0L, (long)map.getUsedBucketCount());
        map.remove(0L);
        Assert.assertEquals((long)0L, (long)map.getUsedBucketCount());
    }

    @Test
    public void testRehashing() {
        int n = 16;
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap(n / 2, 1);
        Assert.assertEquals((long)map.capacity(), (long)n);
        Assert.assertEquals((long)map.size(), (long)0L);
        for (int i = 0; i < n; ++i) {
            map.put((long)i, (long)i);
        }
        Assert.assertEquals((long)map.capacity(), (long)(2 * n));
        Assert.assertEquals((long)map.size(), (long)n);
    }

    @Test
    public void testRehashingWithDeletes() {
        int i;
        int n = 16;
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap(n / 2, 1);
        Assert.assertEquals((long)map.capacity(), (long)n);
        Assert.assertEquals((long)map.size(), (long)0L);
        for (i = 0; i < n / 2; ++i) {
            map.put((long)i, (long)i);
        }
        for (i = 0; i < n / 2; ++i) {
            map.remove((long)i);
        }
        for (i = n; i < 2 * n; ++i) {
            map.put((long)i, (long)i);
        }
        Assert.assertEquals((long)map.capacity(), (long)(2 * n));
        Assert.assertEquals((long)map.size(), (long)n);
    }

    @Test
    public void concurrentInsertions() throws Throwable {
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int n = 100000;
        long value = 55L;
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n2 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key = Math.abs(random.nextLong());
                    key -= key % (long)(threadIdx + 1);
                    map.put(key, value);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)map.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void concurrentInsertionsAndReads() throws Throwable {
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int n = 100000;
        long value = 55L;
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n2 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key = Math.abs(random.nextLong());
                    key -= key % (long)(threadIdx + 1);
                    map.put(key, 55L);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)map.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void testIteration() {
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap();
        Assert.assertEquals((Object)map.keys(), Collections.emptyList());
        Assert.assertEquals((Object)map.values(), Collections.emptyList());
        map.put(0L, 0L);
        Assert.assertEquals((Object)map.keys(), (Object)Lists.newArrayList((Object[])new Long[]{0L}));
        Assert.assertEquals((Object)map.values(), (Object)Lists.newArrayList((Object[])new Long[]{0L}));
        map.remove(0L);
        Assert.assertEquals((Object)map.keys(), Collections.emptyList());
        Assert.assertEquals((Object)map.values(), Collections.emptyList());
        map.put(0L, 0L);
        map.put(1L, 11L);
        map.put(2L, 22L);
        List keys = map.keys();
        Collections.sort(keys);
        Assert.assertEquals((Object)keys, (Object)Lists.newArrayList((Object[])new Long[]{0L, 1L, 2L}));
        List values = map.values();
        Collections.sort(values);
        Assert.assertEquals((Object)values, (Object)Lists.newArrayList((Object[])new Long[]{0L, 11L, 22L}));
        map.put(1L, 111L);
        keys = map.keys();
        Collections.sort(keys);
        Assert.assertEquals((Object)keys, (Object)Lists.newArrayList((Object[])new Long[]{0L, 1L, 2L}));
        values = map.values();
        Collections.sort(values);
        Assert.assertEquals((Object)values, (Object)Lists.newArrayList((Object[])new Long[]{0L, 22L, 111L}));
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testHashConflictWithDeletion() {
        int buckets = 16;
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap(16, 1);
        long key1 = 1L;
        long key2 = 27L;
        int bucket1 = ConcurrentLongLongHashMap.signSafeMod((long)ConcurrentLongLongHashMap.hash((long)key1), (int)16);
        int bucket2 = ConcurrentLongLongHashMap.signSafeMod((long)ConcurrentLongLongHashMap.hash((long)key2), (int)16);
        Assert.assertEquals((long)bucket1, (long)bucket2);
        long value1 = 1L;
        long value2 = 2L;
        long value1Overwrite = 3L;
        long value2Overwrite = 3L;
        Assert.assertEquals((long)map.put(key1, 1L), (long)-1L);
        Assert.assertEquals((long)map.put(key2, 2L), (long)-1L);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((long)map.remove(key1), (long)1L);
        Assert.assertEquals((long)map.size(), (long)1L);
        Assert.assertEquals((long)map.put(key1, 3L), (long)-1L);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((long)map.remove(key1), (long)3L);
        Assert.assertEquals((long)map.size(), (long)1L);
        Assert.assertEquals((long)map.put(key2, 3L), (long)2L);
        Assert.assertEquals((long)map.get(key2), (long)3L);
        Assert.assertEquals((long)map.size(), (long)1L);
        Assert.assertEquals((long)map.remove(key2), (long)3L);
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testPutIfAbsent() {
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap();
        Assert.assertEquals((long)map.putIfAbsent(1L, 11L), (long)-1L);
        Assert.assertEquals((long)map.get(1L), (long)11L);
        Assert.assertEquals((long)map.putIfAbsent(1L, 111L), (long)11L);
        Assert.assertEquals((long)map.get(1L), (long)11L);
    }

    @Test
    public void testComputeIfAbsent() {
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap(16, 1);
        final AtomicLong counter = new AtomicLong();
        ConcurrentLongLongHashMap.LongLongFunction provider = new ConcurrentLongLongHashMap.LongLongFunction(){

            public long apply(long key) {
                return counter.getAndIncrement();
            }
        };
        Assert.assertEquals((long)map.computeIfAbsent(0L, provider), (long)0L);
        Assert.assertEquals((long)map.get(0L), (long)0L);
        Assert.assertEquals((long)map.computeIfAbsent(1L, provider), (long)1L);
        Assert.assertEquals((long)map.get(1L), (long)1L);
        Assert.assertEquals((long)map.computeIfAbsent(1L, provider), (long)1L);
        Assert.assertEquals((long)map.get(1L), (long)1L);
        Assert.assertEquals((long)map.computeIfAbsent(2L, provider), (long)2L);
        Assert.assertEquals((long)map.get(2L), (long)2L);
    }

    @Test
    public void testAddAndGet() {
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap(16, 1);
        Assert.assertEquals((long)map.addAndGet(0L, 0L), (long)0L);
        Assert.assertEquals((Object)map.containsKey(0L), (Object)true);
        Assert.assertEquals((long)map.get(0L), (long)0L);
        Assert.assertEquals((Object)map.containsKey(5L), (Object)false);
        Assert.assertEquals((long)map.addAndGet(0L, 5L), (long)5L);
        Assert.assertEquals((long)map.get(0L), (long)5L);
        Assert.assertEquals((long)map.addAndGet(0L, 1L), (long)6L);
        Assert.assertEquals((long)map.get(0L), (long)6L);
        Assert.assertEquals((long)map.addAndGet(0L, -2L), (long)4L);
        Assert.assertEquals((long)map.get(0L), (long)4L);
        try {
            map.addAndGet(0L, -5L);
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)map.get(0L), (long)4L);
    }

    @Test
    public void testRemoveIf() {
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap(16, 1);
        map.put(1L, 1L);
        map.put(2L, 2L);
        map.put(3L, 3L);
        map.put(4L, 4L);
        map.removeIf(key -> key < 3L);
        Assert.assertFalse((boolean)map.containsKey(1L));
        Assert.assertFalse((boolean)map.containsKey(2L));
        Assert.assertTrue((boolean)map.containsKey(3L));
        Assert.assertTrue((boolean)map.containsKey(4L));
        Assert.assertEquals((long)2L, (long)map.size());
    }

    @Test
    public void testRemoveIfValue() {
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap(16, 1);
        map.put(1L, 1L);
        map.put(2L, 2L);
        map.put(3L, 1L);
        map.put(4L, 2L);
        map.removeIf((key, value) -> value < 2L);
        Assert.assertFalse((boolean)map.containsKey(1L));
        Assert.assertTrue((boolean)map.containsKey(2L));
        Assert.assertFalse((boolean)map.containsKey(3L));
        Assert.assertTrue((boolean)map.containsKey(4L));
        Assert.assertEquals((long)2L, (long)map.size());
    }

    @Test
    public void testIvalidKeys() {
        ConcurrentLongLongHashMap map = new ConcurrentLongLongHashMap(16, 1);
        try {
            map.put(-5L, 4L);
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            map.get(-1L);
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            map.containsKey(-1L);
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            map.putIfAbsent(-1L, 1L);
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            map.computeIfAbsent(-1L, new ConcurrentLongLongHashMap.LongLongFunction(){

                public long apply(long key) {
                    return 1L;
                }
            });
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAsMap() {
        ConcurrentLongLongHashMap lmap = new ConcurrentLongLongHashMap(16, 1);
        lmap.put(1L, 11L);
        lmap.put(2L, 22L);
        lmap.put(3L, 33L);
        TreeMap map = Maps.newTreeMap();
        map.put(1L, 11L);
        map.put(2L, 22L);
        map.put(3L, 33L);
        Assert.assertEquals((Object)map, (Object)lmap.asMap());
    }
}

