/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util.collections;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.util.collections.GrowableArrayBlockingQueue;
import org.junit.Assert;
import org.junit.Test;

public class GrowableArrayBlockingQueueTest {
    @Test
    public void simple() throws Exception {
        GrowableArrayBlockingQueue queue = new GrowableArrayBlockingQueue(4);
        Assert.assertEquals(null, queue.poll());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)queue.remainingCapacity());
        Assert.assertEquals((Object)"[]", (Object)queue.toString());
        try {
            queue.element();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            queue.iterator();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        for (int i = 0; i < 100; ++i) {
            queue.add(i);
            Assert.assertEquals((long)i, (long)((Integer)queue.take()).intValue());
        }
        queue.offer(1);
        Assert.assertEquals((Object)"[1]", (Object)queue.toString());
        queue.offer(2);
        Assert.assertEquals((Object)"[1, 2]", (Object)queue.toString());
        queue.offer(3);
        Assert.assertEquals((Object)"[1, 2, 3]", (Object)queue.toString());
        queue.offer(4);
        Assert.assertEquals((Object)"[1, 2, 3, 4]", (Object)queue.toString());
        Assert.assertEquals((long)4L, (long)queue.size());
        ArrayList list = new ArrayList();
        queue.drainTo(list, 3);
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), list);
        Assert.assertEquals((Object)"[4]", (Object)queue.toString());
        Assert.assertEquals((long)4L, (long)((Integer)queue.peek()).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)queue.element()).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)queue.remove()).intValue());
        try {
            queue.remove();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void blockingTake() throws Exception {
        GrowableArrayBlockingQueue queue = new GrowableArrayBlockingQueue();
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> GrowableArrayBlockingQueueTest.lambda$blockingTake$0((BlockingQueue)queue, latch)).start();
        int n = 0;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                queue.put(n);
                ++n;
            }
            while (!queue.isEmpty()) {
                Thread.sleep(1L);
            }
        }
        latch.await();
    }

    @Test
    public void growArray() throws Exception {
        GrowableArrayBlockingQueue queue = new GrowableArrayBlockingQueue(4);
        Assert.assertEquals(null, queue.poll());
        Assert.assertTrue((boolean)queue.offer(1));
        Assert.assertTrue((boolean)queue.offer(2));
        Assert.assertTrue((boolean)queue.offer(3));
        Assert.assertTrue((boolean)queue.offer(4));
        Assert.assertTrue((boolean)queue.offer(5));
        Assert.assertEquals((long)5L, (long)queue.size());
        queue.clear();
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertTrue((boolean)queue.offer(1, 1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)queue.offer(2, 1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)queue.offer(3, 1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)3L, (long)queue.size());
        ArrayList list = new ArrayList();
        queue.drainTo(list);
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), list);
    }

    @Test
    public void pollTimeout() throws Exception {
        GrowableArrayBlockingQueue queue = new GrowableArrayBlockingQueue(4);
        Assert.assertEquals(null, queue.poll(1L, TimeUnit.MILLISECONDS));
        queue.put(1);
        Assert.assertEquals((long)1L, (long)((Integer)queue.poll(1L, TimeUnit.MILLISECONDS)).intValue());
        Assert.assertEquals(null, queue.poll(0L, TimeUnit.HOURS));
        queue.put(2);
        queue.put(3);
        Assert.assertEquals((long)2L, (long)((Integer)queue.poll(1L, TimeUnit.HOURS)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)queue.poll(1L, TimeUnit.HOURS)).intValue());
    }

    @Test
    public void pollTimeout2() throws Exception {
        GrowableArrayBlockingQueue queue = new GrowableArrayBlockingQueue();
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> GrowableArrayBlockingQueueTest.lambda$pollTimeout2$1((BlockingQueue)queue, latch)).start();
        Thread.sleep(100L);
        queue.put(1);
        latch.await();
    }

    private static /* synthetic */ void lambda$pollTimeout2$1(BlockingQueue queue, CountDownLatch latch) {
        try {
            queue.poll(1L, TimeUnit.HOURS);
            latch.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$blockingTake$0(BlockingQueue queue, CountDownLatch latch) {
        try {
            int expected = 0;
            for (int i = 0; i < 100; ++i) {
                int n = (Integer)queue.take();
                Assert.assertEquals((long)expected++, (long)n);
            }
            latch.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

