/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.zookeeper;

import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.bookkeeper.zookeeper.ExponentialBackoffRetryPolicy;
import org.junit.Assert;
import org.junit.Test;

public class TestRetryPolicy {
    private static void assertTimeRange(long waitTime, long minTime, long maxTime) {
        Assert.assertTrue((waitTime >= minTime ? 1 : 0) != 0);
        Assert.assertTrue((waitTime <= maxTime ? 1 : 0) != 0);
    }

    @Test
    public void testExponentialBackoffRetryPolicy() throws Exception {
        ExponentialBackoffRetryPolicy policy = new ExponentialBackoffRetryPolicy(1000L, Integer.MAX_VALUE);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(30, 2000L), 1000L, (long)(1000.0 * Math.pow(2.0, 31.0)));
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(31, 2000L), 1000L, (long)(1000.0 * Math.pow(2.0, 32.0)));
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(32, 2000L), 1000L, (long)(1000.0 * Math.pow(2.0, 33.0)));
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(127, 2000L), 1000L, 1000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(128, 2000L), 1000L, 2000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(129, 2000L), 1000L, 4000L);
    }

    @Test
    public void testBoundExponentialBackoffRetryPolicy() throws Exception {
        BoundExponentialBackoffRetryPolicy policy = new BoundExponentialBackoffRetryPolicy(1000L, 2000L, Integer.MAX_VALUE);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(30, 2000L), 1000L, 2000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(31, 2000L), 1000L, 2000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(32, 2000L), 1000L, 2000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(127, 2000L), 1000L, 1000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(128, 2000L), 1000L, 2000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(129, 2000L), 1000L, 2000L);
    }
}

