/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.EntryKey;
import org.apache.bookkeeper.bookie.FileInfo;
import org.apache.bookkeeper.bookie.LEPStateChangeCallback;
import org.apache.bookkeeper.bookie.ShortReadException;
import org.apache.bookkeeper.util.ZeroBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerEntryPage {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerEntryPage.class);
    private static final int indexEntrySize = 8;
    private final int pageSize;
    private final int entriesPerPage;
    private volatile EntryKey entryKey = new EntryKey(-1L, -1L);
    private final ByteBuffer page;
    private volatile boolean clean = true;
    private final AtomicInteger useCount = new AtomicInteger(0);
    private final AtomicInteger version = new AtomicInteger(0);
    private volatile int last = -1;
    private final LEPStateChangeCallback callback;

    public static int getIndexEntrySize() {
        return 8;
    }

    public LedgerEntryPage(int pageSize, int entriesPerPage) {
        this(pageSize, entriesPerPage, null);
    }

    public LedgerEntryPage(int pageSize, int entriesPerPage, LEPStateChangeCallback callback) {
        this.pageSize = pageSize;
        this.entriesPerPage = entriesPerPage;
        this.page = ByteBuffer.allocateDirect(pageSize);
        this.callback = callback;
        if (null != this.callback) {
            callback.onResetInUse(this);
        }
    }

    public void resetPage() {
        this.page.clear();
        ZeroBuffer.put(this.page);
        this.last = -1;
        this.entryKey = new EntryKey(-1L, -1L);
        this.clean = true;
        this.useCount.set(0);
        if (null != this.callback) {
            this.callback.onResetInUse(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLedger());
        sb.append('@');
        sb.append(this.getFirstEntry());
        sb.append(this.clean ? " clean " : " dirty ");
        sb.append(this.useCount.get());
        return sb.toString();
    }

    public void usePage() {
        int oldVal = this.useCount.getAndIncrement();
        if (0 == oldVal && null != this.callback) {
            this.callback.onSetInUse(this);
        }
    }

    public void releasePageNoCallback() {
        this.releasePageInternal(false);
    }

    public void releasePage() {
        this.releasePageInternal(true);
    }

    private void releasePageInternal(boolean shouldCallback) {
        int newUseCount = this.useCount.decrementAndGet();
        if (newUseCount < 0) {
            throw new IllegalStateException("Use count has gone below 0");
        }
        if (shouldCallback && null != this.callback && newUseCount == 0) {
            this.callback.onResetInUse(this);
        }
    }

    private void checkPage() {
        if (this.useCount.get() <= 0) {
            throw new IllegalStateException("Page not marked in use");
        }
    }

    public boolean equals(Object other) {
        if (other instanceof LedgerEntryPage) {
            LedgerEntryPage otherLEP = (LedgerEntryPage)other;
            return otherLEP.getLedger() == this.getLedger() && otherLEP.getFirstEntry() == this.getFirstEntry();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getLedger() ^ (int)this.getFirstEntry();
    }

    void setClean(int versionOfCleaning) {
        boolean bl = this.clean = versionOfCleaning == this.version.get();
        if (null != this.callback && this.clean) {
            this.callback.onSetClean(this);
        }
    }

    boolean isClean() {
        return this.clean;
    }

    public void setOffset(long offset, int position) {
        this.checkPage();
        this.page.putLong(position, offset);
        this.version.incrementAndGet();
        if (this.last < position / LedgerEntryPage.getIndexEntrySize()) {
            this.last = position / LedgerEntryPage.getIndexEntrySize();
        }
        this.clean = false;
        if (null != this.callback) {
            this.callback.onSetDirty(this);
        }
    }

    public long getOffset(int position) {
        this.checkPage();
        return this.page.getLong(position);
    }

    public void zeroPage() {
        this.checkPage();
        this.page.clear();
        ZeroBuffer.put(this.page);
        this.last = -1;
        this.clean = true;
    }

    public void readPage(FileInfo fi) throws IOException {
        this.checkPage();
        this.page.clear();
        try {
            fi.read(this.page, this.getFirstEntryPosition(), true);
        }
        catch (ShortReadException sre) {
            throw new ShortReadException("Short page read of ledger " + this.getLedger() + " tried to get " + this.page.capacity() + " from position " + this.getFirstEntryPosition() + " still need " + this.page.remaining(), sre);
        }
        catch (IllegalArgumentException iae) {
            LOG.error("IllegalArgumentException when trying to read ledger {} from position {}", new Object[]{this.getLedger(), this.getFirstEntryPosition(), iae});
            throw iae;
        }
        if (this.page.remaining() != 0) {
            LOG.info("Short page read of ledger {} : tried to read {} bytes from position {}, but only {} bytes read.", new Object[]{this.getLedger(), this.page.capacity(), this.getFirstEntryPosition(), this.page.position()});
            if (this.page.position() % 8 != 0) {
                int partialIndexEntryStart = this.page.position() - this.page.position() % 8;
                this.page.putLong(partialIndexEntryStart, 0L);
            }
        }
        this.last = this.getLastEntryIndex();
        this.clean = true;
    }

    public ByteBuffer getPageToWrite() {
        this.checkPage();
        this.page.clear();
        return this.page.duplicate();
    }

    long getLedger() {
        return this.entryKey.getLedgerId();
    }

    int getVersion() {
        return this.version.get();
    }

    public EntryKey getEntryKey() {
        return this.entryKey;
    }

    void setLedgerAndFirstEntry(long ledgerId, long firstEntry) {
        if (firstEntry % (long)this.entriesPerPage != 0L) {
            throw new IllegalArgumentException(firstEntry + " is not a multiple of " + this.entriesPerPage);
        }
        this.entryKey = new EntryKey(ledgerId, firstEntry);
    }

    long getFirstEntry() {
        return this.entryKey.getEntryId();
    }

    long getMaxPossibleEntry() {
        return this.entryKey.getEntryId() + (long)this.entriesPerPage;
    }

    long getFirstEntryPosition() {
        return this.entryKey.getEntryId() * 8L;
    }

    public boolean inUse() {
        return this.useCount.get() > 0;
    }

    private int getLastEntryIndex() {
        for (int i = this.entriesPerPage - 1; i >= 0; --i) {
            if (this.getOffset(i * LedgerEntryPage.getIndexEntrySize()) <= 0L) continue;
            return i;
        }
        return -1;
    }

    public long getLastEntry() {
        if (this.last >= 0) {
            return (long)this.last + this.entryKey.getEntryId();
        }
        int index = this.getLastEntryIndex();
        return index >= 0 ? (long)index + this.entryKey.getEntryId() : 0L;
    }
}

