/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.stats.StatsLogger;

public interface LedgerStorage {
    public void initialize(ServerConfiguration var1, LedgerManager var2, LedgerDirsManager var3, LedgerDirsManager var4, StateManager var5, CheckpointSource var6, Checkpointer var7, StatsLogger var8) throws IOException;

    public void start();

    public void shutdown() throws InterruptedException;

    public boolean ledgerExists(long var1) throws IOException;

    public boolean setFenced(long var1) throws IOException;

    public boolean isFenced(long var1) throws IOException;

    public void setMasterKey(long var1, byte[] var3) throws IOException;

    public byte[] readMasterKey(long var1) throws IOException, BookieException;

    public long addEntry(ByteBuf var1) throws IOException, BookieException;

    public ByteBuf getEntry(long var1, long var3) throws IOException;

    public long getLastAddConfirmed(long var1) throws IOException;

    public boolean waitForLastAddConfirmedUpdate(long var1, long var3, Watcher<LastAddConfirmedUpdateNotification> var5) throws IOException;

    public void flush() throws IOException;

    public void checkpoint(CheckpointSource.Checkpoint var1) throws IOException;

    public void deleteLedger(long var1) throws IOException;

    public void registerLedgerDeletionListener(LedgerDeletionListener var1);

    public void setExplicitlac(long var1, ByteBuf var3) throws IOException;

    public ByteBuf getExplicitLac(long var1);

    default public void forceGC() {
    }

    public static interface LedgerDeletionListener {
        public void ledgerDeleted(long var1);
    }
}

