/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingReadLacOp
implements BookkeeperInternalCallbacks.ReadLacCallback {
    static final Logger LOG = LoggerFactory.getLogger(PendingReadLacOp.class);
    LedgerHandle lh;
    LacCallback cb;
    int numResponsesPending;
    volatile boolean completed = false;
    int lastSeenError = -1;
    final DistributionSchedule.QuorumCoverageSet coverageSet;
    long maxLac = -1L;

    PendingReadLacOp(LedgerHandle lh, LacCallback cb) {
        this.lh = lh;
        this.cb = cb;
        this.numResponsesPending = lh.metadata.getEnsembleSize();
        this.coverageSet = lh.distributionSchedule.getCoverageSet();
    }

    public void initiate() {
        for (int i = 0; i < this.lh.metadata.currentEnsemble.size(); ++i) {
            this.lh.bk.getBookieClient().readLac(this.lh.metadata.currentEnsemble.get(i), this.lh.ledgerId, this, i);
        }
    }

    @Override
    public void readLacComplete(int rc, long ledgerId, ByteBuf lacBuffer, ByteBuf lastEntryBuffer, Object ctx) {
        int bookieIndex = (Integer)ctx;
        this.coverageSet.addBookie(bookieIndex, rc);
        --this.numResponsesPending;
        boolean heardValidResponse = false;
        if (this.completed) {
            return;
        }
        if (rc == 0) {
            try {
                DigestManager.RecoveryData recoveryData;
                long recoveredLac;
                long lac;
                if (lacBuffer != null && lacBuffer.readableBytes() > 0 && (lac = this.lh.macManager.verifyDigestAndReturnLac(lacBuffer)) > this.maxLac) {
                    this.maxLac = lac;
                }
                if (lastEntryBuffer != null && lastEntryBuffer.readableBytes() > 0 && (recoveredLac = (recoveryData = this.lh.macManager.verifyDigestAndReturnLastConfirmed(lastEntryBuffer)).getLastAddConfirmed()) > this.maxLac) {
                    this.maxLac = recoveredLac;
                }
                heardValidResponse = true;
            }
            catch (BKException.BKDigestMatchException e) {
                LOG.error("Mac mismatch while reading  ledger: " + ledgerId + " LAC from bookie: " + this.lh.metadata.currentEnsemble.get(bookieIndex));
                rc = -5;
            }
        }
        if (rc == -7 || rc == -13) {
            heardValidResponse = true;
        }
        if (rc == -102 && !this.completed) {
            this.cb.getLacComplete(rc, this.maxLac);
            this.completed = true;
            return;
        }
        if (!heardValidResponse && 0 != rc) {
            this.lastSeenError = rc;
        }
        if (heardValidResponse && this.coverageSet.checkCovered() && !this.completed) {
            this.completed = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read LAC complete with enough validResponse for ledger: {} LAC: {}", (Object)ledgerId, (Object)this.maxLac);
            }
            this.cb.getLacComplete(0, this.maxLac);
            return;
        }
        if (this.numResponsesPending == 0 && !this.completed) {
            LOG.info("While readLac ledger: " + ledgerId + " did not hear success responses from all of ensemble");
            this.cb.getLacComplete(this.lastSeenError, this.maxLac);
        }
    }

    static interface LacCallback {
        public void getLacComplete(int var1, long var2);
    }
}

