/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.util.HashedWheelTimer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicyImpl;
import org.apache.bookkeeper.client.TopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.net.Node;
import org.apache.bookkeeper.stats.StatsLogger;

public class RackawareEnsemblePlacementPolicy
extends RackawareEnsemblePlacementPolicyImpl
implements ITopologyAwareEnsemblePlacementPolicy<TopologyAwareEnsemblePlacementPolicy.BookieNode> {
    RackawareEnsemblePlacementPolicyImpl slave = null;

    public RackawareEnsemblePlacementPolicy() {
    }

    public RackawareEnsemblePlacementPolicy(boolean enforceDurability) {
        super(enforceDurability);
    }

    @Override
    protected RackawareEnsemblePlacementPolicy initialize(DNSToSwitchMapping dnsResolver, HashedWheelTimer timer, boolean reorderReadsRandom, int stabilizePeriodSeconds, boolean isWeighted, int maxWeightMultiple, StatsLogger statsLogger) {
        if (stabilizePeriodSeconds > 0) {
            super.initialize(dnsResolver, timer, reorderReadsRandom, 0, isWeighted, maxWeightMultiple, statsLogger);
            this.slave = new RackawareEnsemblePlacementPolicyImpl(this.enforceDurability);
            this.slave.initialize(dnsResolver, timer, reorderReadsRandom, stabilizePeriodSeconds, isWeighted, maxWeightMultiple, statsLogger);
        } else {
            super.initialize(dnsResolver, timer, reorderReadsRandom, stabilizePeriodSeconds, isWeighted, maxWeightMultiple, statsLogger);
            this.slave = null;
        }
        return this;
    }

    @Override
    public void uninitalize() {
        super.uninitalize();
        if (null != this.slave) {
            this.slave.uninitalize();
        }
    }

    @Override
    public Set<BookieSocketAddress> onClusterChanged(Set<BookieSocketAddress> writableBookies, Set<BookieSocketAddress> readOnlyBookies) {
        Set<BookieSocketAddress> deadBookies = super.onClusterChanged(writableBookies, readOnlyBookies);
        if (null != this.slave) {
            deadBookies = this.slave.onClusterChanged(writableBookies, readOnlyBookies);
        }
        return deadBookies;
    }

    @Override
    public ArrayList<BookieSocketAddress> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
        }
    }

    @Override
    public BookieSocketAddress replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieSocketAddress> currentEnsemble, BookieSocketAddress bookieToReplace, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
        }
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadSequence(ArrayList<BookieSocketAddress> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return super.reorderReadSequence(ensemble, bookiesHealthInfo, writeSet);
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadLACSequence(ArrayList<BookieSocketAddress> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return super.reorderReadLACSequence((ArrayList)ensemble, bookiesHealthInfo, writeSet);
    }

    @Override
    public ArrayList<BookieSocketAddress> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Set<BookieSocketAddress> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentPredicate) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, excludeBookies, parentEnsemble, parentPredicate);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, excludeBookies, parentEnsemble, parentPredicate);
        }
    }

    @Override
    public TopologyAwareEnsemblePlacementPolicy.BookieNode selectFromNetworkLocation(String networkLoc, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.selectFromNetworkLocation(networkLoc, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.selectFromNetworkLocation(networkLoc, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble);
        }
    }

    @Override
    public void handleBookiesThatLeft(Set<BookieSocketAddress> leftBookies) {
        super.handleBookiesThatLeft(leftBookies);
        if (null != this.slave) {
            this.slave.handleBookiesThatLeft(leftBookies);
        }
    }

    @Override
    public void handleBookiesThatJoined(Set<BookieSocketAddress> joinedBookies) {
        super.handleBookiesThatJoined(joinedBookies);
        if (null != this.slave) {
            this.slave.handleBookiesThatJoined(joinedBookies);
        }
    }
}

