/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.PacketProcessorBase;
import org.apache.bookkeeper.proto.ResponseBuilder;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadEntryProcessor
extends PacketProcessorBase<BookieProtocol.ReadRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ReadEntryProcessor.class);
    private final Recycler.Handle<ReadEntryProcessor> recyclerHandle;
    private static final Recycler<ReadEntryProcessor> RECYCLER = new Recycler<ReadEntryProcessor>(){

        protected ReadEntryProcessor newObject(Recycler.Handle<ReadEntryProcessor> handle) {
            return new ReadEntryProcessor(handle);
        }
    };

    public static ReadEntryProcessor create(BookieProtocol.ReadRequest request, Channel channel, BookieRequestProcessor requestProcessor) {
        ReadEntryProcessor rep = (ReadEntryProcessor)RECYCLER.get();
        rep.init(request, channel, requestProcessor);
        return rep;
    }

    @Override
    protected void processPacket() {
        ByteBuf data;
        long startTimeNanos;
        int errorCode;
        block23: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received new read request: {}", (Object)this.request);
            }
            errorCode = 101;
            startTimeNanos = MathUtils.nowInNano();
            data = null;
            try {
                SettableFuture<Boolean> fenceResult = null;
                if (((BookieProtocol.ReadRequest)this.request).isFencing()) {
                    LOG.warn("Ledger: {}  fenced by: {}", (Object)((BookieProtocol.ReadRequest)this.request).getLedgerId(), (Object)this.channel.remoteAddress());
                    if (((BookieProtocol.ReadRequest)this.request).hasMasterKey()) {
                        fenceResult = this.requestProcessor.bookie.fenceLedger(((BookieProtocol.ReadRequest)this.request).getLedgerId(), ((BookieProtocol.ReadRequest)this.request).getMasterKey());
                    } else {
                        LOG.error("Password not provided, Not safe to fence {}", (Object)((BookieProtocol.ReadRequest)this.request).getLedgerId());
                        throw BookieException.create(-1);
                    }
                }
                data = this.requestProcessor.bookie.readEntry(((BookieProtocol.ReadRequest)this.request).getLedgerId(), ((BookieProtocol.ReadRequest)this.request).getEntryId());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("##### Read entry ##### {} -- ref-count: {}", (Object)data.readableBytes(), (Object)data.refCnt());
                }
                if (null != fenceResult) {
                    try {
                        Boolean fenced = (Boolean)fenceResult.get(1000L, TimeUnit.MILLISECONDS);
                        if (null == fenced || !fenced.booleanValue()) {
                            errorCode = 101;
                            break block23;
                        }
                        errorCode = 0;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        LOG.error("Interrupting fence read entry {}", (Object)this.request, (Object)ie);
                        errorCode = 101;
                    }
                    catch (ExecutionException ee) {
                        LOG.error("Failed to fence read entry {}", (Object)this.request, (Object)ee);
                        errorCode = 101;
                    }
                    catch (TimeoutException te) {
                        LOG.error("Timeout to fence read entry {}", (Object)this.request, (Object)te);
                        errorCode = 101;
                    }
                    break block23;
                }
                errorCode = 0;
            }
            catch (Bookie.NoLedgerException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error reading {}", (Object)this.request, (Object)e);
                }
                errorCode = 1;
            }
            catch (Bookie.NoEntryException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error reading {}", (Object)this.request, (Object)e);
                }
                errorCode = 2;
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error reading {}", (Object)this.request, (Object)e);
                }
                errorCode = 101;
            }
            catch (BookieException e) {
                LOG.error("Unauthorized access to ledger {}", (Object)((BookieProtocol.ReadRequest)this.request).getLedgerId(), (Object)e);
                errorCode = 102;
            }
            catch (Throwable t) {
                LOG.error("Unexpected exception reading at {}:{} : {}", new Object[]{((BookieProtocol.ReadRequest)this.request).getLedgerId(), ((BookieProtocol.ReadRequest)this.request).getEntryId(), t.getMessage(), t});
                errorCode = 100;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Read entry rc = {} for {}", (Object)errorCode, (Object)this.request);
        }
        if (errorCode == 0) {
            this.requestProcessor.readEntryStats.registerSuccessfulEvent(MathUtils.elapsedNanos((long)startTimeNanos), TimeUnit.NANOSECONDS);
            this.sendResponse(errorCode, ResponseBuilder.buildReadResponse(data, this.request), this.requestProcessor.readRequestStats);
        } else {
            ReferenceCountUtil.release(data);
            this.requestProcessor.readEntryStats.registerFailedEvent(MathUtils.elapsedNanos((long)startTimeNanos), TimeUnit.NANOSECONDS);
            this.sendResponse(errorCode, ResponseBuilder.buildErrorResponse(errorCode, this.request), this.requestProcessor.readRequestStats);
        }
        this.recycle();
    }

    public String toString() {
        return String.format("ReadEntry(%d, %d)", ((BookieProtocol.ReadRequest)this.request).getLedgerId(), ((BookieProtocol.ReadRequest)this.request).getEntryId());
    }

    private void recycle() {
        super.reset();
        this.recyclerHandle.recycle((Object)this);
    }

    private ReadEntryProcessor(Recycler.Handle<ReadEntryProcessor> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }
}

