/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto.checksum;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.security.GeneralSecurityException;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.CRC32CDigestManager;
import org.apache.bookkeeper.proto.checksum.CRC32DigestManager;
import org.apache.bookkeeper.proto.checksum.DummyDigestManager;
import org.apache.bookkeeper.proto.checksum.MacDigestManager;
import org.apache.bookkeeper.util.ByteBufList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DigestManager {
    private static final Logger logger = LoggerFactory.getLogger(DigestManager.class);
    public static final int METADATA_LENGTH = 32;
    public static final int LAC_METADATA_LENGTH = 16;
    final long ledgerId;
    final boolean useV2Protocol;
    final int macCodeLength;

    abstract int getMacCodeLength();

    void update(byte[] data) {
        this.update(Unpooled.wrappedBuffer((byte[])data, (int)0, (int)data.length));
    }

    abstract void update(ByteBuf var1);

    abstract void populateValueAndReset(ByteBuf var1);

    public DigestManager(long ledgerId, boolean useV2Protocol) {
        this.ledgerId = ledgerId;
        this.useV2Protocol = useV2Protocol;
        this.macCodeLength = this.getMacCodeLength();
    }

    public static DigestManager instantiate(long ledgerId, byte[] passwd, DataFormats.LedgerMetadataFormat.DigestType digestType) throws GeneralSecurityException {
        return DigestManager.instantiate(ledgerId, passwd, digestType, false);
    }

    public static DigestManager instantiate(long ledgerId, byte[] passwd, DataFormats.LedgerMetadataFormat.DigestType digestType, boolean useV2Protocol) throws GeneralSecurityException {
        switch (digestType) {
            case HMAC: {
                return new MacDigestManager(ledgerId, passwd, useV2Protocol);
            }
            case CRC32: {
                return new CRC32DigestManager(ledgerId, useV2Protocol);
            }
            case CRC32C: {
                return new CRC32CDigestManager(ledgerId, useV2Protocol);
            }
            case DUMMY: {
                return new DummyDigestManager(ledgerId, useV2Protocol);
            }
        }
        throw new GeneralSecurityException("Unknown checksum type: " + digestType);
    }

    public ByteBufList computeDigestAndPackageForSending(long entryId, long lastAddConfirmed, long length, ByteBuf data) {
        if (this.useV2Protocol) {
            ByteBuf headersBuffer = PooledByteBufAllocator.DEFAULT.buffer(32 + this.macCodeLength);
            headersBuffer.writeLong(this.ledgerId);
            headersBuffer.writeLong(entryId);
            headersBuffer.writeLong(lastAddConfirmed);
            headersBuffer.writeLong(length);
            this.update(headersBuffer);
            this.update(data);
            this.populateValueAndReset(headersBuffer);
            return ByteBufList.get(headersBuffer, data);
        }
        ByteBuf sendBuffer = Unpooled.buffer((int)(32 + this.macCodeLength + data.readableBytes()));
        sendBuffer.writeLong(this.ledgerId);
        sendBuffer.writeLong(entryId);
        sendBuffer.writeLong(lastAddConfirmed);
        sendBuffer.writeLong(length);
        this.update(sendBuffer);
        this.update(data);
        this.populateValueAndReset(sendBuffer);
        sendBuffer.writeBytes(data, data.readerIndex(), data.readableBytes());
        return ByteBufList.get(sendBuffer);
    }

    public ByteBufList computeDigestAndPackageForSendingLac(long lac) {
        ByteBuf headersBuffer = this.useV2Protocol ? PooledByteBufAllocator.DEFAULT.buffer(16 + this.macCodeLength) : Unpooled.buffer((int)(16 + this.macCodeLength));
        headersBuffer.writeLong(this.ledgerId);
        headersBuffer.writeLong(lac);
        this.update(headersBuffer);
        this.populateValueAndReset(headersBuffer);
        return ByteBufList.get(headersBuffer);
    }

    private void verifyDigest(ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(-1L, dataReceived, true);
    }

    private void verifyDigest(long entryId, ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(entryId, dataReceived, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyDigest(long entryId, ByteBuf dataReceived, boolean skipEntryIdCheck) throws BKException.BKDigestMatchException {
        if (32 + this.macCodeLength > dataReceived.readableBytes()) {
            logger.error("Data received is smaller than the minimum for this digest type.  Either the packet it corrupt, or the wrong digest is configured.  Digest type: {}, Packet Length: {}", (Object)this.getClass().getName(), (Object)dataReceived.readableBytes());
            throw new BKException.BKDigestMatchException();
        }
        this.update(dataReceived.slice(0, 32));
        int offset = 32 + this.macCodeLength;
        this.update(dataReceived.slice(offset, dataReceived.readableBytes() - offset));
        ByteBuf digest = PooledByteBufAllocator.DEFAULT.buffer(this.macCodeLength);
        this.populateValueAndReset(digest);
        try {
            if (digest.compareTo(dataReceived.slice(32, this.macCodeLength)) != 0) {
                logger.error("Mac mismatch for ledger-id: " + this.ledgerId + ", entry-id: " + entryId);
                throw new BKException.BKDigestMatchException();
            }
        }
        finally {
            digest.release();
        }
        long actualLedgerId = dataReceived.readLong();
        long actualEntryId = dataReceived.readLong();
        if (actualLedgerId != this.ledgerId) {
            logger.error("Ledger-id mismatch in authenticated message, expected: " + this.ledgerId + " , actual: " + actualLedgerId);
            throw new BKException.BKDigestMatchException();
        }
        if (!skipEntryIdCheck && actualEntryId != entryId) {
            logger.error("Entry-id mismatch in authenticated message, expected: " + entryId + " , actual: " + actualEntryId);
            throw new BKException.BKDigestMatchException();
        }
    }

    public long verifyDigestAndReturnLac(ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        if (16 + this.macCodeLength > dataReceived.readableBytes()) {
            logger.error("Data received is smaller than the minimum for this digest type. Either the packet it corrupt, or the wrong digest is configured.  Digest type: {}, Packet Length: {}", (Object)this.getClass().getName(), (Object)dataReceived.readableBytes());
            throw new BKException.BKDigestMatchException();
        }
        this.update(dataReceived.slice(0, 16));
        ByteBuf digest = PooledByteBufAllocator.DEFAULT.buffer(this.macCodeLength);
        try {
            this.populateValueAndReset(digest);
            if (digest.compareTo(dataReceived.slice(16, this.macCodeLength)) != 0) {
                logger.error("Mac mismatch for ledger-id LAC: " + this.ledgerId);
                throw new BKException.BKDigestMatchException();
            }
        }
        finally {
            digest.release();
        }
        long actualLedgerId = dataReceived.readLong();
        long lac = dataReceived.readLong();
        if (actualLedgerId != this.ledgerId) {
            logger.error("Ledger-id mismatch in authenticated message, expected: " + this.ledgerId + " , actual: " + actualLedgerId);
            throw new BKException.BKDigestMatchException();
        }
        return lac;
    }

    public ByteBuf verifyDigestAndReturnData(long entryId, ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(entryId, dataReceived);
        dataReceived.readerIndex(32 + this.macCodeLength);
        return dataReceived;
    }

    public RecoveryData verifyDigestAndReturnLastConfirmed(ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(dataReceived);
        dataReceived.readerIndex(8);
        dataReceived.readLong();
        long lastAddConfirmed = dataReceived.readLong();
        long length = dataReceived.readLong();
        return new RecoveryData(lastAddConfirmed, length);
    }

    public static final class RecoveryData {
        final long lastAddConfirmed;
        final long length;

        public RecoveryData(long lastAddConfirmed, long length) {
            this.lastAddConfirmed = lastAddConfirmed;
            this.length = length;
        }

        public long getLastAddConfirmed() {
            return this.lastAddConfirmed;
        }

        public long getLength() {
            return this.length;
        }
    }
}

