/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.common.component.ComponentStarter;
import org.apache.bookkeeper.common.component.LifecycleComponent;
import org.apache.bookkeeper.common.component.LifecycleComponentStack;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.UncheckedConfigurationException;
import org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.server.http.BKHttpServiceProvider;
import org.apache.bookkeeper.server.service.AutoRecoveryService;
import org.apache.bookkeeper.server.service.BookieService;
import org.apache.bookkeeper.server.service.HttpService;
import org.apache.bookkeeper.server.service.StatsProviderService;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    static final Options BK_OPTS = new Options();

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        String header = "\nBookieServer provide an interface to start a bookie with configuration file and/or arguments.The settings in configuration file will be overwrite by provided arguments.\nOptions including:\n";
        String footer = "Here is an example:\n\tBookieServer -c bookie.conf -z localhost:2181 -m /bookkeeper/ledgers -p 3181 -j /mnt/journal -i \"/mnt/index1 /mnt/index2\" -l \"/mnt/ledger1 /mnt/ledger2 /mnt/ledger3\"\n";
        hf.printHelp("BookieServer [options]\n", header, BK_OPTS, footer, true);
    }

    private static void loadConfFile(ServerConfiguration conf, String confFile) throws IllegalArgumentException {
        try {
            conf.loadConf(new File(confFile).toURI().toURL());
            conf.validate();
        }
        catch (MalformedURLException e) {
            log.error("Could not open configuration file: {}", (Object)confFile, (Object)e);
            throw new IllegalArgumentException();
        }
        catch (ConfigurationException e) {
            log.error("Malformed configuration file: {}", (Object)confFile, (Object)e);
            throw new IllegalArgumentException();
        }
        log.info("Using configuration file {}", (Object)confFile);
    }

    private static ServerConfiguration parseArgs(String[] args) throws IllegalArgumentException {
        try {
            BasicParser parser = new BasicParser();
            CommandLine cmdLine = parser.parse(BK_OPTS, args);
            if (cmdLine.hasOption('h')) {
                throw new IllegalArgumentException();
            }
            ServerConfiguration conf = new ServerConfiguration();
            if (cmdLine.hasOption('c')) {
                String confFile = cmdLine.getOptionValue("c");
                Main.loadConfFile(conf, confFile);
            }
            if (cmdLine.hasOption("withAutoRecovery")) {
                conf.setAutoRecoveryDaemonEnabled(true);
            }
            if (cmdLine.hasOption("r")) {
                conf.setForceReadOnlyBookie(true);
            }
            boolean overwriteMetadataServiceUri = false;
            String sZkLedgersRootPath = "/ledgers";
            if (cmdLine.hasOption('m')) {
                sZkLedgersRootPath = cmdLine.getOptionValue('m');
                log.info("Get cmdline zookeeper ledger path: {}", (Object)sZkLedgersRootPath);
                overwriteMetadataServiceUri = true;
            }
            String sZK = conf.getZkServers();
            if (cmdLine.hasOption('z')) {
                sZK = cmdLine.getOptionValue('z');
                log.info("Get cmdline zookeeper instance: {}", (Object)sZK);
                overwriteMetadataServiceUri = true;
            }
            if (overwriteMetadataServiceUri) {
                String metadataServiceUri = "zk://" + sZK + sZkLedgersRootPath;
                conf.setMetadataServiceUri(metadataServiceUri);
                log.info("Overwritten service uri to {}", (Object)metadataServiceUri);
            }
            if (cmdLine.hasOption('p')) {
                String sPort = cmdLine.getOptionValue('p');
                log.info("Get cmdline bookie port: {}", (Object)sPort);
                Integer iPort = Integer.parseInt(sPort);
                conf.setBookiePort(iPort);
            }
            if (cmdLine.hasOption('j')) {
                String sJournalDir = cmdLine.getOptionValue('j');
                log.info("Get cmdline journal dir: {}", (Object)sJournalDir);
                conf.setJournalDirName(sJournalDir);
            }
            if (cmdLine.hasOption('i')) {
                String[] sIndexDirs = cmdLine.getOptionValues('i');
                log.info("Get cmdline index dirs: ");
                for (String index : sIndexDirs) {
                    log.info("indexDir : {}", (Object)index);
                }
                conf.setIndexDirName(sIndexDirs);
            }
            if (cmdLine.hasOption('l')) {
                String[] sLedgerDirs = cmdLine.getOptionValues('l');
                log.info("Get cmdline ledger dirs: ");
                for (String ledger : sLedgerDirs) {
                    log.info("ledgerdir : {}", (Object)ledger);
                }
                conf.setLedgerDirNames(sLedgerDirs);
            }
            return conf;
        }
        catch (ParseException e) {
            log.error("Error parsing command line arguments : ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static void main(String[] args) {
        int retCode = Main.doMain(args);
        Runtime.getRuntime().exit(retCode);
    }

    static int doMain(String[] args) {
        LifecycleComponentStack server;
        ServerConfiguration conf;
        try {
            conf = Main.parseCommandLine(args);
        }
        catch (IllegalArgumentException iae) {
            return 1;
        }
        try {
            server = Main.buildBookieServer(new BookieConfiguration(conf));
        }
        catch (Exception e) {
            log.error("Failed to build bookie server", (Throwable)e);
            return 2;
        }
        try {
            ComponentStarter.startComponent((LifecycleComponent)server).get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            log.info("Bookie server is interrupted. Exiting ...");
        }
        catch (ExecutionException ee) {
            log.error("Error in bookie shutdown", ee.getCause());
            return 2;
        }
        return 0;
    }

    private static ServerConfiguration parseCommandLine(String[] args) throws IllegalArgumentException, UncheckedConfigurationException {
        ServerConfiguration conf;
        try {
            conf = Main.parseArgs(args);
        }
        catch (IllegalArgumentException iae) {
            log.error("Error parsing command line arguments : ", (Throwable)iae);
            System.err.println(iae.getMessage());
            Main.printUsage();
            throw iae;
        }
        StringBuilder sb = new StringBuilder();
        String[] ledgerDirNames = conf.getLedgerDirNames();
        for (int i = 0; i < ledgerDirNames.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(ledgerDirNames[i]);
        }
        String hello = String.format("Hello, I'm your bookie, listening on port %1$s. Metadata service uri is %2$s. Journals are in %3$s. Ledgers are stored in %4$s.", conf.getBookiePort(), conf.getMetadataServiceUriUnchecked(), Arrays.asList(conf.getJournalDirNames()), sb);
        log.info(hello);
        return conf;
    }

    static LifecycleComponentStack buildBookieServer(BookieConfiguration conf) throws Exception {
        Object[] extraComponents;
        LifecycleComponentStack.Builder serverBuilder = LifecycleComponentStack.newBuilder().withName("bookie-server");
        StatsProviderService statsProviderService = new StatsProviderService(conf);
        StatsLogger rootStatsLogger = statsProviderService.getStatsProvider().getStatsLogger("");
        serverBuilder.addComponent((LifecycleComponent)statsProviderService);
        log.info("Load lifecycle component : {}", (Object)StatsProviderService.class.getName());
        BookieService bookieService = new BookieService(conf, rootStatsLogger);
        serverBuilder.addComponent((LifecycleComponent)bookieService);
        log.info("Load lifecycle component : {}", (Object)BookieService.class.getName());
        if (conf.getServerConf().isAutoRecoveryDaemonEnabled()) {
            AutoRecoveryService autoRecoveryService = new AutoRecoveryService(conf, rootStatsLogger.scope("replication"));
            serverBuilder.addComponent((LifecycleComponent)autoRecoveryService);
            log.info("Load lifecycle component : {}", (Object)AutoRecoveryService.class.getName());
        }
        if (conf.getServerConf().isHttpServerEnabled()) {
            BKHttpServiceProvider provider = new BKHttpServiceProvider.Builder().setBookieServer(bookieService.getServer()).setServerConfiguration(conf.getServerConf()).setStatsProvider(statsProviderService.getStatsProvider()).build();
            HttpService httpService = new HttpService(provider, conf, rootStatsLogger);
            serverBuilder.addComponent((LifecycleComponent)httpService);
            log.info("Load lifecycle component : {}", (Object)HttpService.class.getName());
        }
        if (null != (extraComponents = conf.getServerConf().getExtraServerComponents())) {
            try {
                List<ServerLifecycleComponent> components = ServerLifecycleComponent.loadServerComponents((String[])extraComponents, conf, rootStatsLogger);
                for (ServerLifecycleComponent component : components) {
                    serverBuilder.addComponent((LifecycleComponent)component);
                    log.info("Load lifecycle component : {}", (Object)((Object)((Object)component)).getClass().getName());
                }
            }
            catch (Exception e) {
                if (conf.getServerConf().getIgnoreExtraServerComponentsStartupFailures()) {
                    log.info("Failed to load extra components '{}' - {}. Continuing without those components.", (Object)StringUtils.join((Object[])extraComponents), (Object)e.getMessage());
                }
                throw e;
            }
        }
        return serverBuilder.build();
    }

    static {
        BK_OPTS.addOption("c", "conf", true, "Configuration for Bookie Server");
        BK_OPTS.addOption("withAutoRecovery", false, "Start Autorecovery service Bookie server");
        BK_OPTS.addOption("r", "readOnly", false, "Force Start a ReadOnly Bookie server");
        BK_OPTS.addOption("z", "zkserver", true, "Zookeeper Server");
        BK_OPTS.addOption("m", "zkledgerpath", true, "Zookeeper ledgers root path");
        BK_OPTS.addOption("p", "bookieport", true, "bookie port exported");
        BK_OPTS.addOption("j", "journal", true, "bookie journal directory");
        Option indexDirs = new Option("i", "indexdirs", true, "bookie index directories");
        indexDirs.setArgs(10);
        BK_OPTS.addOption(indexDirs);
        Option ledgerDirs = new Option("l", "ledgerdirs", true, "bookie ledgers directories");
        ledgerDirs.setArgs(10);
        BK_OPTS.addOption(ledgerDirs);
        BK_OPTS.addOption("h", "help", false, "Print help message");
    }
}

