/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.service;

import java.io.IOException;
import org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.commons.configuration.Configuration;

public class StatsProviderService
extends ServerLifecycleComponent {
    public static final String NAME = "stats-provider";
    private final StatsProvider statsProvider;

    public StatsProviderService(BookieConfiguration conf) throws Exception {
        super(NAME, conf, (StatsLogger)NullStatsLogger.INSTANCE);
        Class<? extends StatsProvider> statsProviderClass = conf.getServerConf().getStatsProviderClass();
        this.statsProvider = ReflectionUtils.newInstance(statsProviderClass);
    }

    public StatsProvider getStatsProvider() {
        return this.statsProvider;
    }

    protected void doStart() {
        this.statsProvider.start((Configuration)this.conf);
    }

    protected void doStop() {
        this.statsProvider.stop();
    }

    protected void doClose() throws IOException {
    }
}

