/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.client;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.api.BookKeeper;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.tools.cli.helpers.ClientCommand;

@Parameters(commandDescription="Simple test to create a ledger and write entries to it.")
public class SimpleTestCommand
extends ClientCommand {
    @Parameter(names={"-e", "--ensemble-size"}, description="Ensemble size (default 3)")
    private int ensembleSize = 3;
    @Parameter(names={"-w", "--write-quorum-size"}, description="Write quorum size (default 2)")
    private int writeQuorumSize = 2;
    @Parameter(names={"-a", "--ack-quorum-size"}, description="Ack quorum size (default 2)")
    private int ackQuorumSize = 2;
    @Parameter(names={"-n", "--num-entries"}, description="Entries to write (default 100)")
    private int numEntries = 100;

    @Override
    public String name() {
        return "simpletest";
    }

    @Override
    protected void run(BookKeeper bk) throws Exception {
        byte[] data = new byte[100];
        try (WriteHandle wh = (WriteHandle)FutureUtils.result(bk.newCreateLedgerOp().withEnsembleSize(this.ensembleSize).withWriteQuorumSize(this.writeQuorumSize).withAckQuorumSize(this.ackQuorumSize).withDigestType(DigestType.CRC32C).withPassword(new byte[0]).execute());){
            System.out.println("Ledger ID: " + wh.getId());
            long lastReport = System.nanoTime();
            for (int i = 0; i < this.numEntries; ++i) {
                wh.append(data);
                if (TimeUnit.SECONDS.convert(System.nanoTime() - lastReport, TimeUnit.NANOSECONDS) <= 1L) continue;
                System.out.println(i + " entries written");
                lastReport = System.nanoTime();
            }
            System.out.println(this.numEntries + " entries written to ledger " + wh.getId());
        }
    }

    public SimpleTestCommand ensembleSize(int ensembleSize) {
        this.ensembleSize = ensembleSize;
        return this;
    }

    public SimpleTestCommand writeQuorumSize(int writeQuorumSize) {
        this.writeQuorumSize = writeQuorumSize;
        return this;
    }

    public SimpleTestCommand ackQuorumSize(int ackQuorumSize) {
        this.ackQuorumSize = ackQuorumSize;
        return this;
    }

    public SimpleTestCommand numEntries(int numEntries) {
        this.numEntries = numEntries;
        return this;
    }
}

