/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.util.concurrent.RejectedExecutionException;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OrderedGenericCallback<T>
implements BookkeeperInternalCallbacks.GenericCallback<T> {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedGenericCallback.class);
    private final OrderedExecutor executor;
    private final long orderingKey;

    public OrderedGenericCallback(OrderedExecutor executor, long orderingKey) {
        this.executor = executor;
        this.orderingKey = orderingKey;
    }

    @Override
    public final void operationComplete(final int rc, final T result) {
        if (Thread.currentThread().getId() == this.executor.getThreadID(this.orderingKey)) {
            this.safeOperationComplete(rc, result);
        } else {
            try {
                this.executor.executeOrdered(this.orderingKey, new SafeRunnable(){

                    public void safeRun() {
                        OrderedGenericCallback.this.safeOperationComplete(rc, result);
                    }

                    public String toString() {
                        return String.format("Callback(key=%s, name=%s)", OrderedGenericCallback.this.orderingKey, OrderedGenericCallback.this);
                    }
                });
            }
            catch (RejectedExecutionException re) {
                LOG.warn("Failed to submit callback for {} : ", (Object)this.orderingKey, (Object)re);
            }
        }
    }

    public abstract void safeOperationComplete(int var1, T var2);
}

