/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieShutdownTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BookieShutdownTest.class);
    private LedgerHandle lh;
    private int numEntriesToWrite = 200;
    private int maxInt = Integer.MAX_VALUE;
    private Random rng = new Random(System.currentTimeMillis());
    private BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    public BookieShutdownTest() {
        super(3);
        this.baseConf.setAllowEphemeralPorts(false);
    }

    @Test
    public void testBookieRestartContinuously() throws Exception {
        for (int index = 0; index < 10; ++index) {
            SyncObj sync = new SyncObj();
            try {
                this.lh = this.bkc.createLedger(3, 2, this.digestType, "aaa".getBytes());
                LOG.info("Ledger ID: " + this.lh.getId());
                for (int i = 0; i < this.numEntriesToWrite; ++i) {
                    ByteBuffer entry = ByteBuffer.allocate(4);
                    entry.putInt(this.rng.nextInt(this.maxInt));
                    entry.position(0);
                    this.lh.asyncAddEntry(entry.array(), (AsyncCallback.AddCallback)new LedgerEntryAddCallback(), (Object)sync);
                }
                LOG.info("Wrote " + this.numEntriesToWrite + " and now going to fail bookie.");
                this.bsConfs.remove(0);
                ((BookieServer)this.bs.get(0)).shutdown();
                this.bs.remove(0);
                this.startNewBookie();
                LOG.info("Shutdown one bookie server and started new bookie server...");
                continue;
            }
            catch (BKException e) {
                LOG.error("Caught BKException", (Throwable)e);
                Assert.fail((String)e.toString());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error("Caught InterruptedException", (Throwable)e);
                Assert.fail((String)e.toString());
            }
        }
    }

    @Test
    public void testBookieShutdownFromBookieThread() throws Exception {
        ServerConfiguration conf = (ServerConfiguration)this.bsConfs.get(0);
        this.killBookie(0);
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch shutdownComplete = new CountDownLatch(1);
        Bookie bookie = new Bookie(conf){

            public void run() {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.triggerBookieShutdown(5);
            }

            synchronized int shutdown(int exitCode) {
                super.shutdown(exitCode);
                shutdownComplete.countDown();
                return exitCode;
            }
        };
        bookie.start();
        Thread.sleep(1000L);
        latch.countDown();
        shutdownComplete.await(5000L, TimeUnit.MILLISECONDS);
    }

    private class LedgerEntryAddCallback
    implements AsyncCallback.AddCallback {
        private LedgerEntryAddCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
            SyncObj x;
            SyncObj syncObj = x = (SyncObj)ctx;
            synchronized (syncObj) {
                x.notify();
            }
        }
    }

    class SyncObj {
        SyncObj() {
        }
    }
}

