/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.beust.jcommander.internal.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieStickyReadsTest
extends BookKeeperClusterTestCase {
    private static final Logger log = LoggerFactory.getLogger(BookieStickyReadsTest.class);
    private static final int NUM_BOOKIES = 3;
    private static final String READ_ENTRY_REQUEST_METRIC = "bookkeeper_server.READ_ENTRY_REQUEST";

    public BookieStickyReadsTest() {
        super(3);
    }

    @Test
    public void testNormalReads() throws Exception {
        ClientConfiguration conf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        this.writeAndReadEntries(conf, 3, 3, 3);
        this.getBookieReadRequestStats().values().forEach(readRequests -> Assert.assertTrue((readRequests > 0L ? 1 : 0) != 0));
    }

    @Test
    public void testStickyFlagWithStriping() throws Exception {
        ClientConfiguration conf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        conf.setStickyReadsEnabled(true);
        this.writeAndReadEntries(conf, 3, 2, 2);
        this.getBookieReadRequestStats().values().forEach(readRequests -> Assert.assertTrue((readRequests > 0L ? 1 : 0) != 0));
    }

    @Test
    public void stickyReadsWithNoFailures() throws Exception {
        ClientConfiguration conf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        conf.setStickyReadsEnabled(true);
        this.writeAndReadEntries(conf, 3, 3, 3);
        Map<Integer, Long> stats = this.getBookieReadRequestStats();
        boolean foundBookieWithRequests = false;
        for (long readRequests : stats.values()) {
            if (readRequests <= 0L) continue;
            Assert.assertFalse((String)"Another bookie already had received requests", (boolean)foundBookieWithRequests);
            foundBookieWithRequests = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void stickyReadsWithFailures() throws Exception {
        ClientConfiguration conf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        conf.setStickyReadsEnabled(true);
        BookKeeper bkc = new BookKeeper(conf);
        try {
            long ledgerId;
            int n = 10;
            try (WriteHandle wh = (WriteHandle)bkc.newCreateLedgerOp().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).withPassword("".getBytes()).execute().join();){
                ledgerId = wh.getId();
                for (int i = 0; i < 10; ++i) {
                    wh.append(("entry-" + i).getBytes());
                }
            }
            ReadHandle rh = (ReadHandle)bkc.newOpenLedgerOp().withLedgerId(ledgerId).withPassword("".getBytes()).execute().join();
            try {
                LedgerEntries entry0 = rh.read(0L, 0L);
                try {
                    int i;
                    Assert.assertArrayEquals((byte[])"entry-0".getBytes(), (byte[])entry0.getEntry(0L).getEntryBytes());
                    int bookieWithRequests = -1;
                    for (i = 0; i < 3; ++i) {
                        long requests = this.getStatsProvider(i).getOpStatsLogger(READ_ENTRY_REQUEST_METRIC).getSuccessCount();
                        log.info("Bookie {} --- requests: {}", (Object)i, (Object)requests);
                        if (requests <= 0L) continue;
                        Assert.assertTrue((String)"Another bookie already had received requests", (bookieWithRequests == -1 ? 1 : 0) != 0);
                        bookieWithRequests = i;
                    }
                    ((BookieServer)this.bs.get(bookieWithRequests)).suspendProcessing();
                    for (i = 0; i < 10; ++i) {
                        LedgerEntries entries = rh.read((long)i, (long)i);
                        try {
                            Assert.assertArrayEquals((byte[])("entry-" + i).getBytes(), (byte[])entries.getEntry((long)i).getEntryBytes());
                            continue;
                        }
                        finally {
                            if (Collections.singletonList(entries).get(0) != null) {
                                entries.close();
                            }
                        }
                    }
                    List requestCounts = Lists.newArrayList(this.getBookieReadRequestStats().values());
                    Collections.sort(requestCounts);
                    Assert.assertEquals((long)0L, (long)((Long)requestCounts.get(0)));
                    Assert.assertEquals((long)1L, (long)((Long)requestCounts.get(1)));
                    Assert.assertEquals((long)10L, (long)((Long)requestCounts.get(2)));
                }
                finally {
                    if (Collections.singletonList(entry0).get(0) != null) {
                        entry0.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(rh).get(0) != null) {
                    rh.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(bkc).get(0) != null) {
                bkc.close();
            }
        }
    }

    private Map<Integer, Long> getBookieReadRequestStats() throws Exception {
        TreeMap<Integer, Long> stats = new TreeMap<Integer, Long>();
        for (int i = 0; i < 3; ++i) {
            stats.put(i, this.getStatsProvider(i).getOpStatsLogger(READ_ENTRY_REQUEST_METRIC).getSuccessCount());
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndReadEntries(ClientConfiguration conf, int ensembleSize, int writeQuorum, int ackQuorum) throws Exception {
        BookKeeper bkc = new BookKeeper(conf);
        try {
            WriteHandle wh = (WriteHandle)bkc.newCreateLedgerOp().withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorum).withAckQuorumSize(ackQuorum).withPassword("".getBytes()).execute().join();
            try {
                int i;
                int n = 10;
                for (i = 0; i < 10; ++i) {
                    wh.append(("entry-" + i).getBytes());
                }
                for (i = 0; i < 10; ++i) {
                    LedgerEntries entries = wh.read((long)i, (long)i);
                    try {
                        Assert.assertArrayEquals((byte[])("entry-" + i).getBytes(), (byte[])entries.getEntry((long)i).getEntryBytes());
                        continue;
                    }
                    finally {
                        if (Collections.singletonList(entries).get(0) != null) {
                            entries.close();
                        }
                    }
                }
            }
            finally {
                if (Collections.singletonList(wh).get(0) != null) {
                    wh.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(bkc).get(0) != null) {
                bkc.close();
            }
        }
    }
}

