/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.UpdateLedgerOp;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.MathUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateLedgerOpTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateLedgerOpTest.class);
    private BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    private static final String PASSWORD = "testPasswd";
    private static final int printprogress = 5;
    BookieShell.UpdateLedgerNotifier progressable = new BookieShell.UpdateLedgerNotifier(){
        long lastReport = System.nanoTime();

        public void progress(long updated, long issued) {
            if (TimeUnit.MILLISECONDS.toSeconds(MathUtils.elapsedMSec((long)this.lastReport)) >= 5L) {
                LOG.info("Number of ledgers issued={}, updated={}", (Object)issued, (Object)updated);
                this.lastReport = MathUtils.nowInNano();
            }
        }
    };

    public UpdateLedgerOpTest() {
        super(3);
        this.baseConf.setGcWaitTime(100000L);
    }

    @Test
    public void testManyLedgersWithFQDNHostname() throws Exception {
        this.testManyLedgers(false);
    }

    @Test(timeout=120000L)
    public void testManyLedgersWithShortHostname() throws Exception {
        this.testManyLedgers(true);
    }

    public void testManyLedgers(boolean useShortHostName) throws Exception {
        try (BookKeeper bk = new BookKeeper(this.baseClientConf, this.zkc);
             BookKeeperAdmin bkadmin = new BookKeeperAdmin(bk);){
            LOG.info("Create ledger and add entries to it");
            ArrayList<LedgerHandle> ledgers = new ArrayList<LedgerHandle>();
            LedgerHandle lh1 = this.createLedgerWithEntries(bk, 0);
            ledgers.add(lh1);
            for (int i = 0; i < 99; ++i) {
                ledgers.add(this.createLedgerWithEntries(bk, 0));
            }
            List ensemble = lh1.getLedgerMetadata().getEnsembleAt(0L);
            BookieSocketAddress curBookieAddr = (BookieSocketAddress)ensemble.get(0);
            this.baseConf.setUseHostNameAsBookieID(true);
            this.baseConf.setUseShortHostName(useShortHostName);
            BookieSocketAddress curBookieId = Bookie.getBookieAddress((ServerConfiguration)this.baseConf);
            BookieSocketAddress toBookieAddr = new BookieSocketAddress(curBookieId.getHostName() + ":" + curBookieAddr.getPort());
            UpdateLedgerOp updateLedgerOp = new UpdateLedgerOp(bk, bkadmin);
            updateLedgerOp.updateBookieIdInLedgers(curBookieAddr, toBookieAddr, 5, Integer.MIN_VALUE, this.progressable);
            for (LedgerHandle lh : ledgers) {
                lh.close();
                LedgerHandle openLedger = bk.openLedger(lh.getId(), this.digestType, PASSWORD.getBytes());
                ensemble = openLedger.getLedgerMetadata().getEnsembleAt(0L);
                Assert.assertTrue((String)"Failed to update the ledger metadata to use bookie host name", (boolean)ensemble.contains(toBookieAddr));
                Assert.assertFalse((String)"Failed to update the ledger metadata to use bookie host name", (boolean)ensemble.contains(curBookieAddr));
            }
        }
    }

    @Test
    public void testLimitLessThanTotalLedgers() throws Exception {
        try (BookKeeper bk = new BookKeeper(this.baseClientConf, this.zkc);
             BookKeeperAdmin bkadmin = new BookKeeperAdmin(bk);){
            LOG.info("Create ledger and add entries to it");
            ArrayList<LedgerHandle> ledgers = new ArrayList<LedgerHandle>();
            LedgerHandle lh1 = this.createLedgerWithEntries(bk, 0);
            ledgers.add(lh1);
            for (int i = 1; i < 10; ++i) {
                ledgers.add(this.createLedgerWithEntries(bk, 0));
            }
            List ensemble = lh1.getLedgerMetadata().getEnsembleAt(0L);
            BookieSocketAddress curBookieAddr = (BookieSocketAddress)ensemble.get(0);
            this.baseConf.setUseHostNameAsBookieID(true);
            BookieSocketAddress toBookieId = Bookie.getBookieAddress((ServerConfiguration)this.baseConf);
            BookieSocketAddress toBookieAddr = new BookieSocketAddress(toBookieId.getHostName() + ":" + curBookieAddr.getPort());
            UpdateLedgerOp updateLedgerOp = new UpdateLedgerOp(bk, bkadmin);
            updateLedgerOp.updateBookieIdInLedgers(curBookieAddr, toBookieAddr, 7, 4, this.progressable);
            int updatedLedgersCount = this.getUpdatedLedgersCount(bk, ledgers, toBookieAddr);
            Assert.assertEquals((String)"Failed to update the ledger metadata to use bookie host name", (long)4L, (long)updatedLedgersCount);
            updateLedgerOp.updateBookieIdInLedgers(curBookieAddr, toBookieAddr, 2, 10, this.progressable);
            updatedLedgersCount = this.getUpdatedLedgersCount(bk, ledgers, toBookieAddr);
            Assert.assertEquals((String)"Failed to update the ledger metadata to use bookie host name", (long)10L, (long)updatedLedgersCount);
            updateLedgerOp.updateBookieIdInLedgers(curBookieAddr, toBookieAddr, 3, 20, this.progressable);
            updatedLedgersCount = this.getUpdatedLedgersCount(bk, ledgers, toBookieAddr);
            Assert.assertEquals((String)"Failed to update the ledger metadata to use bookie host name", (long)10L, (long)updatedLedgersCount);
            updateLedgerOp.updateBookieIdInLedgers(curBookieAddr, toBookieAddr, 3, Integer.MIN_VALUE, this.progressable);
            updatedLedgersCount = this.getUpdatedLedgersCount(bk, ledgers, toBookieAddr);
            Assert.assertEquals((String)"Failed to update the ledger metadata to use bookie host name", (long)10L, (long)updatedLedgersCount);
        }
    }

    @Test
    public void testChangeEnsembleAfterRenamingToFQDNHostname() throws Exception {
        this.testChangeEnsembleAfterRenaming(false);
    }

    @Test(timeout=120000L)
    public void testChangeEnsembleAfterRenamingToShortHostname() throws Exception {
        this.testChangeEnsembleAfterRenaming(true);
    }

    public void testChangeEnsembleAfterRenaming(boolean useShortHostName) throws Exception {
        try (BookKeeper bk = new BookKeeper(this.baseClientConf, this.zkc);
             BookKeeperAdmin bkadmin = new BookKeeperAdmin(bk);){
            LOG.info("Create ledger and add entries to it");
            LedgerHandle lh = this.createLedgerWithEntries(bk, 100);
            BookieServer bookieServer = (BookieServer)this.bs.get(0);
            List ensemble = lh.getLedgerMetadata().getEnsembleAt(0L);
            BookieSocketAddress curBookieAddr = null;
            for (BookieSocketAddress bookieSocketAddress : ensemble) {
                if (!bookieServer.getLocalAddress().equals((Object)bookieSocketAddress)) continue;
                curBookieAddr = bookieSocketAddress;
            }
            Assert.assertNotNull((String)"Couldn't find the bookie in ledger metadata!", curBookieAddr);
            this.baseConf.setUseHostNameAsBookieID(true);
            this.baseConf.setUseShortHostName(useShortHostName);
            BookieSocketAddress toBookieId = Bookie.getBookieAddress((ServerConfiguration)this.baseConf);
            BookieSocketAddress toBookieAddr = new BookieSocketAddress(toBookieId.getHostName() + ":" + curBookieAddr.getPort());
            UpdateLedgerOp updateLedgerOp = new UpdateLedgerOp(bk, bkadmin);
            updateLedgerOp.updateBookieIdInLedgers(curBookieAddr, toBookieAddr, 5, 100, this.progressable);
            bookieServer.shutdown();
            ServerConfiguration serverConf1 = this.newServerConfiguration();
            this.bsConfs.add(serverConf1);
            this.bs.add(this.startBookie(serverConf1));
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicInteger rc = new AtomicInteger(0);
            lh.asyncAddEntry("foobar".getBytes(), new AsyncCallback.AddCallback(){

                public void addComplete(int rccb, LedgerHandle lh, long entryId, Object ctx) {
                    rc.compareAndSet(0, rccb);
                    latch.countDown();
                }
            }, null);
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                throw new Exception("Entries took too long to add");
            }
            if (rc.get() != 0) {
                throw BKException.create((int)rc.get());
            }
            lh.close();
            LedgerHandle openLedger = bk.openLedger(lh.getId(), this.digestType, PASSWORD.getBytes());
            LedgerMetadata ledgerMetadata = openLedger.getLedgerMetadata();
            Assert.assertEquals((String)"Failed to reform ensemble!", (long)2L, (long)ledgerMetadata.getAllEnsembles().size());
            ensemble = ledgerMetadata.getEnsembleAt(0L);
            Assert.assertTrue((String)"Failed to update the ledger metadata to use bookie host name", (boolean)ensemble.contains(toBookieAddr));
        }
    }

    @Test
    public void testRenameWhenAddEntryInProgress() throws Exception {
        try (BookKeeper bk = new BookKeeper(this.baseClientConf, this.zkc);
             BookKeeperAdmin bkadmin = new BookKeeperAdmin(bk);){
            LOG.info("Create ledger and add entries to it");
            int numOfEntries = 5000;
            final CountDownLatch latch = new CountDownLatch(5000);
            final AtomicInteger rc = new AtomicInteger(0);
            final LedgerHandle lh = this.createLedgerWithEntries(bk, 1);
            latch.countDown();
            Thread th = new Thread(){

                @Override
                public void run() {
                    AsyncCallback.AddCallback cb = new AsyncCallback.AddCallback(){

                        public void addComplete(int rccb, LedgerHandle lh, long entryId, Object ctx) {
                            rc.compareAndSet(0, rccb);
                            if (entryId % 100L == 0L) {
                                LOG.info("Added entries till entryId:{}", (Object)entryId);
                            }
                            latch.countDown();
                        }
                    };
                    for (int i = 1; i < 5000; ++i) {
                        lh.asyncAddEntry(("foobar" + i).getBytes(), cb, null);
                    }
                }
            };
            th.start();
            List ensemble = lh.getLedgerMetadata().getEnsembleAt(0L);
            BookieSocketAddress curBookieAddr = (BookieSocketAddress)ensemble.get(0);
            BookieSocketAddress toBookieAddr = new BookieSocketAddress("localhost:" + curBookieAddr.getPort());
            UpdateLedgerOp updateLedgerOp = new UpdateLedgerOp(bk, bkadmin);
            updateLedgerOp.updateBookieIdInLedgers(curBookieAddr, toBookieAddr, 5, 100, this.progressable);
            if (!latch.await(120L, TimeUnit.SECONDS)) {
                throw new Exception("Entries took too long to add");
            }
            if (rc.get() != 0) {
                throw BKException.create((int)rc.get());
            }
            lh.close();
            LedgerHandle openLedger = bk.openLedger(lh.getId(), this.digestType, PASSWORD.getBytes());
            ensemble = openLedger.getLedgerMetadata().getEnsembleAt(0L);
            Assert.assertTrue((String)"Failed to update the ledger metadata to use bookie host name", (boolean)ensemble.contains(toBookieAddr));
        }
    }

    private int getUpdatedLedgersCount(BookKeeper bk, List<LedgerHandle> ledgers, BookieSocketAddress toBookieAddr) throws InterruptedException, BKException {
        int updatedLedgersCount = 0;
        for (LedgerHandle lh : ledgers) {
            lh.close();
            LedgerHandle openLedger = bk.openLedger(lh.getId(), this.digestType, PASSWORD.getBytes());
            List ensemble = openLedger.getLedgerMetadata().getEnsembleAt(0L);
            if (!ensemble.contains(toBookieAddr)) continue;
            ++updatedLedgersCount;
        }
        return updatedLedgersCount;
    }

    private LedgerHandle createLedgerWithEntries(BookKeeper bk, int numOfEntries) throws Exception {
        LedgerHandle lh = bk.createLedger(3, 3, this.digestType, PASSWORD.getBytes());
        final AtomicInteger rc = new AtomicInteger(0);
        final CountDownLatch latch = new CountDownLatch(numOfEntries);
        AsyncCallback.AddCallback cb = new AsyncCallback.AddCallback(){

            public void addComplete(int rccb, LedgerHandle lh, long entryId, Object ctx) {
                rc.compareAndSet(0, rccb);
                latch.countDown();
            }
        };
        for (int i = 0; i < numOfEntries; ++i) {
            lh.asyncAddEntry(("foobar" + i).getBytes(), cb, null);
        }
        if (!latch.await(30L, TimeUnit.SECONDS)) {
            throw new Exception("Entries took too long to add");
        }
        if (rc.get() != 0) {
            throw BKException.create((int)rc.get());
        }
        return lh;
    }
}

