/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.impl;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.impl.LedgerEntriesImpl;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class LedgerEntriesImplTest {
    private final int entryNumber = 7;
    private LedgerEntriesImpl ledgerEntriesImpl;
    private final List<LedgerEntry> entryList = Lists.newArrayList();
    private final long ledgerId = 1234L;
    private final long entryId = 5678L;
    private final long length = 9876L;
    private final byte[] dataBytes = "test-ledger-entry-impl".getBytes(Charsets.UTF_8);
    private final ArrayList<ByteBuf> bufs = Lists.newArrayListWithExpectedSize((int)7);

    public LedgerEntriesImplTest() {
        for (int i = 0; i < 7; ++i) {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])this.dataBytes);
            this.bufs.add(buf);
            this.entryList.add((LedgerEntry)LedgerEntryImpl.create((long)(1234L + (long)i), (long)(5678L + (long)i), (long)(9876L + (long)i), (ByteBuf)buf));
        }
        this.ledgerEntriesImpl = LedgerEntriesImpl.create(this.entryList);
    }

    @After
    public void tearDown() {
        this.ledgerEntriesImpl.close();
        this.bufs.forEach(byteBuf -> Assert.assertEquals((long)0L, (long)byteBuf.refCnt()));
        try {
            this.ledgerEntriesImpl.getEntry(5678L);
            Assert.fail((String)"should fail getEntry after close");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.ledgerEntriesImpl.iterator();
            Assert.fail((String)"should fail iterator after close");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetEntry() {
        LedgerEntry entry3;
        for (int i = 0; i < 7; ++i) {
            LedgerEntry entry2 = this.ledgerEntriesImpl.getEntry(5678L + (long)i);
            Assert.assertEquals((long)this.entryList.get(i).getLedgerId(), (long)entry2.getLedgerId());
            Assert.assertEquals((long)this.entryList.get(i).getEntryId(), (long)entry2.getEntryId());
            Assert.assertEquals((long)this.entryList.get(i).getLength(), (long)entry2.getLength());
            ByteBuf buf = entry2.getEntryBuffer();
            byte[] content = new byte[buf.readableBytes()];
            buf.readBytes(content);
            Assert.assertArrayEquals((byte[])this.dataBytes, (byte[])content);
            Assert.assertEquals((long)1L, (long)entry2.getEntryBuffer().refCnt());
        }
        try {
            entry3 = this.ledgerEntriesImpl.getEntry(5677L);
            Assert.fail((String)"Should get IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException entry3) {
            // empty catch block
        }
        try {
            entry3 = this.ledgerEntriesImpl.getEntry(5685L);
            Assert.fail((String)"Should get IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testIterator() {
        Iterator entryIterator = this.ledgerEntriesImpl.iterator();
        entryIterator.forEachRemaining(ledgerEntry -> Assert.assertEquals((long)1L, (long)ledgerEntry.getEntryBuffer().refCnt()));
    }
}

